/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.download.tilesource;

import java.net.MalformedURLException;
import java.net.URL;
import org.mapsforge.core.model.Tile;
import org.mapsforge.map.layer.download.tilesource.AbstractTileSource;

public class OpenCycleMap
extends AbstractTileSource {
    public static final OpenCycleMap INSTANCE = new OpenCycleMap(new String[]{"a.tile.opencyclemap.org", "b.tile.opencyclemap.org", "c.tile.opencyclemap.org"}, 80);
    private static final int PARALLEL_REQUESTS_LIMIT = 8;
    private static final String PROTOCOL = "http";
    private static final int ZOOM_LEVEL_MAX = 18;
    private static final int ZOOM_LEVEL_MIN = 0;

    public OpenCycleMap(String[] hostNames, int port) {
        super(hostNames, port);
    }

    @Override
    public int getParallelRequestsLimit() {
        return 8;
    }

    @Override
    public URL getTileUrl(Tile tile) throws MalformedURLException {
        return new URL(PROTOCOL, this.getHostName(), this.port, "/cycle/" + tile.zoomLevel + '/' + tile.tileX + '/' + tile.tileY + ".png");
    }

    @Override
    public byte getZoomLevelMax() {
        return 18;
    }

    @Override
    public byte getZoomLevelMin() {
        return 0;
    }

    @Override
    public boolean hasAlpha() {
        return false;
    }
}

