/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.download.tilesource;

import java.net.MalformedURLException;
import java.net.URL;
import org.mapsforge.core.model.Tile;
import org.mapsforge.map.layer.download.tilesource.AbstractTileSource;

public class OpenStreetMapMapnik
extends AbstractTileSource {
    public static final OpenStreetMapMapnik INSTANCE = new OpenStreetMapMapnik(new String[]{"a.tile.openstreetmap.org", "b.tile.openstreetmap.org", "c.tile.openstreetmap.org"}, 80);
    private static final int PARALLEL_REQUESTS_LIMIT = 8;
    private static final String PROTOCOL = "http";
    private static final int ZOOM_LEVEL_MAX = 18;
    private static final int ZOOM_LEVEL_MIN = 0;

    public OpenStreetMapMapnik(String[] hostNames, int port) {
        super(hostNames, port);
        this.defaultTimeToLive = 8279000L;
    }

    @Override
    public int getParallelRequestsLimit() {
        return 8;
    }

    @Override
    public URL getTileUrl(Tile tile) throws MalformedURLException {
        return new URL(PROTOCOL, this.getHostName(), this.port, "/" + tile.zoomLevel + '/' + tile.tileX + '/' + tile.tileY + ".png");
    }

    @Override
    public byte getZoomLevelMax() {
        return 18;
    }

    @Override
    public byte getZoomLevelMin() {
        return 0;
    }

    @Override
    public boolean hasAlpha() {
        return false;
    }
}

