/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.hills;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.map.layer.hills.ShadingAlgorithm;

public class HillsRenderConfig {
    private File demFolder;
    private int demCacheSize = 4;
    private ShadingAlgorithm algorithm;
    private FutureTask<HgtCache> hgtCacheFuture;
    private final GraphicFactory graphicsFactory;

    public HillsRenderConfig(File demFolder, GraphicFactory graphicsFactory, ShadingAlgorithm algorithm) {
        this.graphicsFactory = graphicsFactory;
        this.algorithm = algorithm;
        this.setDemFolder(demFolder);
    }

    public Bitmap getShadingTile(int latitudeOfSouthWestCorner, int longituedOfSouthWestCorner) throws ExecutionException, InterruptedException {
        if (this.hgtCacheFuture == null) {
            return null;
        }
        Bitmap ret = this.getShadingTileInternal(latitudeOfSouthWestCorner, longituedOfSouthWestCorner);
        if (ret == null && Math.abs(longituedOfSouthWestCorner) > 178) {
            ret = this.getShadingTileInternal(latitudeOfSouthWestCorner, longituedOfSouthWestCorner > 0 ? longituedOfSouthWestCorner - 180 : longituedOfSouthWestCorner + 180);
        }
        return ret;
    }

    public Bitmap getShadingTileInternal(int northInt, int eastInt) throws ExecutionException, InterruptedException {
        HgtCache hgtCache = this.hgtCacheFuture.get();
        HgtCache.HgtFileInfo hgtFileInfo = hgtCache.hgtFiles.get(new TileKey(northInt, eastInt));
        if (hgtFileInfo == null) {
            return null;
        }
        Future<Bitmap> future = hgtFileInfo.getParsed();
        return future.get();
    }

    public File getDemFolder() {
        return this.demFolder;
    }

    public void setDemFolder(final File demFolder) {
        if (demFolder == null) {
            this.hgtCacheFuture = null;
        } else if (demFolder.equals(this.demFolder)) {
            return;
        }
        this.demFolder = demFolder;
        this.hgtCacheFuture = new FutureTask<HgtCache>(new Callable<HgtCache>(){

            @Override
            public HgtCache call() throws Exception {
                return new HgtCache(demFolder);
            }
        });
        new Thread(this.hgtCacheFuture, "DEM HGT index").start();
    }

    private static final class TileKey {
        final int north;
        final int east;

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TileKey tileKey = (TileKey)o;
            if (this.north != tileKey.north) {
                return false;
            }
            return this.east == tileKey.east;
        }

        public int hashCode() {
            int result = this.north;
            result = 31 * result + this.east;
            return result;
        }

        private TileKey(int north, int east) {
            this.east = east;
            this.north = north;
        }
    }

    class HgtCache {
        LinkedHashSet<Future<Bitmap>> lru = new LinkedHashSet();
        List<String> problems = new ArrayList<String>();
        Map<TileKey, HgtFileInfo> hgtFiles = new HashMap<TileKey, HgtFileInfo>();

        HgtCache(File demFolder) {
            this.crawl(demFolder, Pattern.compile("(n|s)(\\d{1,2})(e|w)(\\d{1,3})\\.hgt", 2).matcher(""), this.problems);
        }

        private void crawl(File file, Matcher matcher, List<String> problems) {
            block3: {
                block4: {
                    long length;
                    int east;
                    int north;
                    block5: {
                        if (!file.exists()) break block3;
                        if (!file.isFile()) break block4;
                        String name = file.getName();
                        if (!matcher.reset(name).matches()) break block3;
                        int northsouth = Integer.parseInt(matcher.group(2));
                        int eastwest = Integer.parseInt(matcher.group(4));
                        north = "n".equals(matcher.group(1).toLowerCase()) ? northsouth : -northsouth;
                        east = "e".equals(matcher.group(3).toLowerCase()) ? eastwest : -eastwest;
                        length = file.length();
                        long heights = length / 2L;
                        long sqrt = (long)Math.sqrt(heights);
                        if (sqrt * sqrt == heights) break block5;
                        if (problems != null) {
                            problems.add(file + " length in shorts (" + heights + ") is not a square number");
                        }
                        break block3;
                    }
                    TileKey tileKey = new TileKey(north, east);
                    HgtFileInfo existing = this.hgtFiles.get(tileKey);
                    if (existing != null && existing.size >= length) break block3;
                    this.hgtFiles.put(tileKey, new HgtFileInfo(file, length, east, north));
                    break block3;
                }
                if (file.isDirectory()) {
                    for (File sub : file.listFiles()) {
                        this.crawl(sub, matcher, problems);
                    }
                }
            }
        }

        class HgtFileInfo
        implements Callable<Bitmap>,
        ShadingAlgorithm.RawHillTileSource {
            final File file;
            WeakReference<Future<Bitmap>> weakRef = null;
            final long size;
            private final int east;
            private final int north;

            HgtFileInfo(File file, int east, int north) {
                this(file, file.length(), east, north);
            }

            HgtFileInfo(File file, long length, int east, int north) {
                this.file = file;
                this.size = file.length();
                this.east = east;
                this.north = north;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            Future<Bitmap> getParsed() {
                Future<Bitmap> future = this.getBeforeLru();
                if (HillsRenderConfig.this.demCacheSize > 0) {
                    LinkedHashSet<Future<Bitmap>> linkedHashSet = HgtCache.this.lru;
                    synchronized (linkedHashSet) {
                        if (!HgtCache.this.lru.remove(future) && HgtCache.this.lru.size() + 1 >= HillsRenderConfig.this.demCacheSize) {
                            Future oldest = (Future)HgtCache.this.lru.iterator().next();
                            HgtCache.this.lru.remove(oldest);
                        }
                        HgtCache.this.lru.add(future);
                    }
                }
                return future;
            }

            private Future<Bitmap> getBeforeLru() {
                Future existing;
                Future future = existing = this.weakRef == null ? null : (Future)this.weakRef.get();
                if (existing != null) {
                    return existing;
                }
                FutureTask<Bitmap> created = new FutureTask<Bitmap>(this);
                this.weakRef = new WeakReference<FutureTask<Bitmap>>(created);
                created.run();
                return created;
            }

            @Override
            public Bitmap call() throws Exception {
                return HillsRenderConfig.this.algorithm.convertTile(this, HillsRenderConfig.this.graphicsFactory);
            }

            @Override
            public long getSize() {
                return this.size;
            }

            @Override
            public BufferedInputStream openInputStream() throws IOException {
                return new BufferedInputStream(new FileInputStream(this.file));
            }

            @Override
            public ShadingAlgorithm.RawHillTileSource getNeighborNorth() {
                return HgtCache.this.hgtFiles.get(new TileKey(this.north + 1, this.east));
            }

            @Override
            public ShadingAlgorithm.RawHillTileSource getNeighborSouth() {
                return HgtCache.this.hgtFiles.get(new TileKey(this.north + 1, this.east));
            }

            @Override
            public ShadingAlgorithm.RawHillTileSource getNeighborEast() {
                return HgtCache.this.hgtFiles.get(new TileKey(this.north, this.east + 1));
            }

            @Override
            public ShadingAlgorithm.RawHillTileSource getNeighborWest() {
                return HgtCache.this.hgtFiles.get(new TileKey(this.north, this.east - 1));
            }
        }
    }
}

