/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.hills;

import java.io.BufferedInputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.util.IOUtils;
import org.mapsforge.map.layer.hills.ShadingAlgorithm;

public class SimpleShadingAlgortithm
implements ShadingAlgorithm {
    private static final Logger LOGGER = Logger.getLogger(SimpleShadingAlgortithm.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Bitmap convertTile(ShadingAlgorithm.RawHillTileSource source, GraphicFactory graphicFactory) {
        long size = source.getSize();
        long elements = size / 2L;
        int rowLen = (int)Math.ceil(Math.sqrt(elements));
        if ((long)(rowLen * rowLen * 2) != size) {
            return null;
        }
        BufferedInputStream in = null;
        try {
            in = source.openInputStream();
            Bitmap bitmap = SimpleShadingAlgortithm.convert(in, size, graphicFactory);
            return bitmap;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
            Bitmap bitmap = null;
            return bitmap;
        }
        finally {
            IOUtils.closeQuietly((Closeable)in);
        }
    }

    private static Bitmap convert(InputStream in, long streamLen, GraphicFactory graphicFactory) throws IOException {
        int rowLen = (int)Math.ceil(Math.sqrt(streamLen / 2L));
        int axisLength = rowLen - 1;
        short[] ringbuffer = new short[rowLen];
        byte[] bytes = new byte[axisLength * axisLength];
        DataInputStream din = new DataInputStream(in);
        int outidx = 0;
        int rbcur = 0;
        short last = 0;
        for (int col = 0; col < rowLen; ++col) {
            last = SimpleShadingAlgortithm.readNext(din, last);
            ringbuffer[rbcur++] = last;
        }
        for (int line = 1; line <= axisLength; ++line) {
            if (rbcur >= rowLen) {
                rbcur = 0;
            }
            short nw = ringbuffer[rbcur];
            short sw = SimpleShadingAlgortithm.readNext(din, nw);
            ringbuffer[rbcur++] = sw;
            for (int col = 1; col <= axisLength; ++col) {
                short ne = ringbuffer[rbcur];
                short se = SimpleShadingAlgortithm.readNext(din, ne);
                ringbuffer[rbcur++] = se;
                int noso = -(se - ne + (sw - nw));
                int eawe = -(ne - nw + (se - sw));
                int intVal = Math.min(255, Math.max(0, noso + eawe + 128));
                int shade = intVal & 0xFF;
                bytes[outidx++] = (byte)shade;
                nw = ne;
                sw = se;
            }
        }
        return graphicFactory.createMonoBitmap(axisLength, axisLength, bytes);
    }

    private static short readNext(DataInputStream din, short fallback) throws IOException {
        short read = din.readShort();
        if (read == Short.MIN_VALUE) {
            return fallback;
        }
        return read;
    }
}

