/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.renderer;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.Color;
import org.mapsforge.core.graphics.Filter;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.GraphicUtils;
import org.mapsforge.core.graphics.Matrix;
import org.mapsforge.core.graphics.Path;
import org.mapsforge.core.mapelements.MapElementContainer;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Rectangle;
import org.mapsforge.core.model.Tile;
import org.mapsforge.map.layer.renderer.CircleContainer;
import org.mapsforge.map.layer.renderer.HillshadingContainer;
import org.mapsforge.map.layer.renderer.PolylineContainer;
import org.mapsforge.map.layer.renderer.RendererUtils;
import org.mapsforge.map.layer.renderer.ShapeContainer;
import org.mapsforge.map.layer.renderer.ShapePaintContainer;
import org.mapsforge.map.layer.renderer.ShapeType;
import org.mapsforge.map.rendertheme.RenderContext;

public class CanvasRasterer {
    private final Canvas canvas;
    private final Path path;
    private final Matrix symbolMatrix;

    public CanvasRasterer(GraphicFactory graphicFactory) {
        this.canvas = graphicFactory.createCanvas();
        this.path = graphicFactory.createPath();
        this.symbolMatrix = graphicFactory.createMatrix();
    }

    public void destroy() {
        this.canvas.destroy();
    }

    void drawWays(RenderContext renderContext) {
        int levelsPerLayer = renderContext.ways.get(0).size();
        int layers = renderContext.ways.size();
        for (int layer = 0; layer < layers; ++layer) {
            List<List<ShapePaintContainer>> shapePaintContainers = renderContext.ways.get(layer);
            for (int level = 0; level < levelsPerLayer; ++level) {
                List<ShapePaintContainer> wayList = shapePaintContainers.get(level);
                for (int index = wayList.size() - 1; index >= 0; --index) {
                    this.drawShapePaintContainer(wayList.get(index));
                }
            }
        }
    }

    void drawMapElements(Set<MapElementContainer> elements, Tile tile) {
        ArrayList<MapElementContainer> elementsAsList = new ArrayList<MapElementContainer>(elements);
        Collections.sort(elementsAsList);
        for (MapElementContainer element : elementsAsList) {
            element.draw(this.canvas, tile.getOrigin(), this.symbolMatrix, Filter.NONE);
        }
    }

    void fill(int color) {
        if (GraphicUtils.getAlpha((int)color) > 0) {
            this.canvas.fillColor(color);
        }
    }

    void fillOutsideAreas(Color color, Rectangle insideArea) {
        this.canvas.setClipDifference((int)insideArea.left, (int)insideArea.top, (int)insideArea.getWidth(), (int)insideArea.getHeight());
        this.canvas.fillColor(color);
        this.canvas.resetClip();
    }

    void fillOutsideAreas(int color, Rectangle insideArea) {
        this.canvas.setClipDifference((int)insideArea.left, (int)insideArea.top, (int)insideArea.getWidth(), (int)insideArea.getHeight());
        this.canvas.fillColor(color);
        this.canvas.resetClip();
    }

    void setCanvasBitmap(Bitmap bitmap) {
        this.canvas.setBitmap(bitmap);
    }

    private void drawCircleContainer(ShapePaintContainer shapePaintContainer) {
        CircleContainer circleContainer = (CircleContainer)shapePaintContainer.shapeContainer;
        Point point = circleContainer.point;
        this.canvas.drawCircle((int)point.x, (int)point.y, (int)circleContainer.radius, shapePaintContainer.paint);
    }

    private void drawHillshading(HillshadingContainer container) {
        this.canvas.shadeBitmap(container.bitmap, container.hillsRect, container.tileRect, container.magnitude);
    }

    private void drawPath(ShapePaintContainer shapePaintContainer, Point[][] coordinates, float dy) {
        this.path.clear();
        for (Point[] innerList : coordinates) {
            Point[] points = dy != 0.0f ? RendererUtils.parallelPath(innerList, dy) : innerList;
            if (points.length < 2) continue;
            Point point = points[0];
            this.path.moveTo((float)point.x, (float)point.y);
            for (int i = 1; i < points.length; ++i) {
                point = points[i];
                this.path.lineTo((float)((int)point.x), (float)((int)point.y));
            }
        }
        this.canvas.drawPath(this.path, shapePaintContainer.paint);
    }

    private void drawShapePaintContainer(ShapePaintContainer shapePaintContainer) {
        ShapeContainer shapeContainer = shapePaintContainer.shapeContainer;
        ShapeType shapeType = shapeContainer.getShapeType();
        switch (shapeType) {
            case CIRCLE: {
                this.drawCircleContainer(shapePaintContainer);
                break;
            }
            case HILLSHADING: {
                HillshadingContainer hillshadingContainer = (HillshadingContainer)shapeContainer;
                this.drawHillshading(hillshadingContainer);
                break;
            }
            case POLYLINE: {
                PolylineContainer polylineContainer = (PolylineContainer)shapeContainer;
                this.drawPath(shapePaintContainer, polylineContainer.getCoordinatesRelativeToOrigin(), shapePaintContainer.dy);
            }
        }
    }
}

