/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.renderer;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Color;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.TileBitmap;
import org.mapsforge.core.mapelements.MapElementContainer;
import org.mapsforge.core.model.Rectangle;
import org.mapsforge.core.model.Tile;
import org.mapsforge.map.datastore.MapDataStore;
import org.mapsforge.map.datastore.MapReadResult;
import org.mapsforge.map.layer.cache.TileCache;
import org.mapsforge.map.layer.hills.HillsRenderConfig;
import org.mapsforge.map.layer.labels.TileBasedLabelStore;
import org.mapsforge.map.layer.renderer.CanvasRasterer;
import org.mapsforge.map.layer.renderer.RendererJob;
import org.mapsforge.map.layer.renderer.StandardRenderer;
import org.mapsforge.map.layer.renderer.TileDependencies;
import org.mapsforge.map.rendertheme.RenderContext;
import org.mapsforge.map.util.LayerUtil;

public class DatabaseRenderer
extends StandardRenderer {
    private static final Logger LOGGER = Logger.getLogger(DatabaseRenderer.class.getName());
    private final TileBasedLabelStore labelStore;
    private final boolean renderLabels;
    private final TileCache tileCache;
    private final TileDependencies tileDependencies;

    public DatabaseRenderer(MapDataStore mapDataStore, GraphicFactory graphicFactory, TileCache tileCache, TileBasedLabelStore labelStore, boolean renderLabels, boolean cacheLabels, HillsRenderConfig hillsRenderConfig) {
        super(mapDataStore, graphicFactory, renderLabels || cacheLabels, hillsRenderConfig);
        this.tileCache = tileCache;
        this.labelStore = labelStore;
        this.renderLabels = renderLabels;
        this.tileDependencies = !renderLabels ? null : new TileDependencies();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TileBitmap executeJob(RendererJob rendererJob) {
        RenderContext renderContext = null;
        try {
            renderContext = new RenderContext(rendererJob, new CanvasRasterer(this.graphicFactory));
            if (this.renderBitmap(renderContext)) {
                TileBitmap bitmap = null;
                if (this.mapDataStore != null) {
                    MapReadResult mapReadResult = this.mapDataStore.readMapData(rendererJob.tile);
                    this.processReadMapData(renderContext, mapReadResult);
                }
                if (!rendererJob.labelsOnly) {
                    renderContext.renderTheme.matchHillShadings(this, renderContext);
                    bitmap = this.graphicFactory.createTileBitmap(rendererJob.tile.tileSize, rendererJob.hasAlpha);
                    bitmap.setTimestamp(rendererJob.mapDataStore.getDataTimestamp(rendererJob.tile));
                    renderContext.canvasRasterer.setCanvasBitmap((Bitmap)bitmap);
                    if (!rendererJob.hasAlpha && rendererJob.displayModel.getBackgroundColor() != renderContext.renderTheme.getMapBackground()) {
                        renderContext.canvasRasterer.fill(renderContext.renderTheme.getMapBackground());
                    }
                    renderContext.canvasRasterer.drawWays(renderContext);
                }
                if (this.renderLabels) {
                    Set<MapElementContainer> labelsToDraw = this.processLabels(renderContext);
                    renderContext.canvasRasterer.drawMapElements(labelsToDraw, rendererJob.tile);
                }
                if (this.labelStore != null) {
                    this.labelStore.storeMapItems(rendererJob.tile, renderContext.labels);
                }
                if (!rendererJob.labelsOnly && renderContext.renderTheme.hasMapBackgroundOutside()) {
                    Rectangle insideArea = this.mapDataStore.boundingBox().getPositionRelativeToTile(rendererJob.tile);
                    if (!rendererJob.hasAlpha) {
                        renderContext.canvasRasterer.fillOutsideAreas(renderContext.renderTheme.getMapBackgroundOutside(), insideArea);
                    } else {
                        renderContext.canvasRasterer.fillOutsideAreas(Color.TRANSPARENT, insideArea);
                    }
                }
                TileBitmap tileBitmap = bitmap;
                return tileBitmap;
            }
            TileBitmap bitmap = this.createBackgroundBitmap(renderContext);
            return bitmap;
        }
        catch (Exception e) {
            LOGGER.warning(e.getMessage());
            TileBitmap tileBitmap = null;
            return tileBitmap;
        }
        finally {
            if (renderContext != null) {
                renderContext.destroy();
            }
        }
    }

    public MapDataStore getMapDatabase() {
        return this.mapDataStore;
    }

    void removeTileInProgress(Tile tile) {
        if (this.tileDependencies != null) {
            this.tileDependencies.removeTileInProgress(tile);
        }
    }

    private TileBitmap createBackgroundBitmap(RenderContext renderContext) {
        TileBitmap bitmap = this.graphicFactory.createTileBitmap(renderContext.rendererJob.tile.tileSize, renderContext.rendererJob.hasAlpha);
        renderContext.canvasRasterer.setCanvasBitmap((Bitmap)bitmap);
        if (!renderContext.rendererJob.hasAlpha) {
            renderContext.canvasRasterer.fill(renderContext.renderTheme.getMapBackgroundOutside());
        }
        return bitmap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<MapElementContainer> processLabels(RenderContext renderContext) {
        HashSet<MapElementContainer> labelsToDraw = new HashSet<MapElementContainer>();
        TileDependencies tileDependencies = this.tileDependencies;
        synchronized (tileDependencies) {
            Set neighbours = renderContext.rendererJob.tile.getNeighbours();
            Iterator tileIterator = neighbours.iterator();
            HashSet<MapElementContainer> undrawableElements = new HashSet<MapElementContainer>();
            this.tileDependencies.addTileInProgress(renderContext.rendererJob.tile);
            while (tileIterator.hasNext()) {
                Tile neighbour = (Tile)tileIterator.next();
                if (this.tileDependencies.isTileInProgress(neighbour) || this.tileCache.containsKey(renderContext.rendererJob.otherTile(neighbour))) {
                    labelsToDraw.addAll(this.tileDependencies.getOverlappingElements(neighbour, renderContext.rendererJob.tile));
                    for (MapElementContainer current : renderContext.labels) {
                        if (!current.intersects(neighbour.getBoundaryAbsolute())) continue;
                        undrawableElements.add(current);
                    }
                    tileIterator.remove();
                    continue;
                }
                this.tileDependencies.removeTileData(neighbour);
            }
            renderContext.labels.removeAll(undrawableElements);
            List<MapElementContainer> currentElementsOrdered = LayerUtil.collisionFreeOrdered(renderContext.labels);
            Iterator<MapElementContainer> currentMapElementsIterator = currentElementsOrdered.iterator();
            block5: while (currentMapElementsIterator.hasNext()) {
                MapElementContainer current;
                current = currentMapElementsIterator.next();
                for (MapElementContainer label : labelsToDraw) {
                    if (!label.clashesWith(current)) continue;
                    currentMapElementsIterator.remove();
                    continue block5;
                }
            }
            labelsToDraw.addAll(currentElementsOrdered);
            for (Tile tile : neighbours) {
                this.tileDependencies.removeTileData(renderContext.rendererJob.tile, tile);
                for (MapElementContainer element : labelsToDraw) {
                    if (!element.intersects(tile.getBoundaryAbsolute())) continue;
                    this.tileDependencies.addOverlappingElement(renderContext.rendererJob.tile, tile, element);
                }
            }
        }
        return labelsToDraw;
    }
}

