/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.renderer;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapsforge.core.graphics.TileBitmap;
import org.mapsforge.map.layer.Layer;
import org.mapsforge.map.layer.cache.TileCache;
import org.mapsforge.map.layer.queue.JobQueue;
import org.mapsforge.map.layer.renderer.DatabaseRenderer;
import org.mapsforge.map.layer.renderer.RendererJob;

public class MapWorkerPool
implements Runnable {
    private static final Logger LOGGER = Logger.getLogger(MapWorkerPool.class.getName());
    public static final int DEFAULT_NUMBER_OF_THREADS = 1;
    public static int NUMBER_OF_THREADS = 1;
    public static boolean DEBUG_TIMING = false;
    private final AtomicInteger concurrentJobs = new AtomicInteger();
    private final AtomicLong totalExecutions = new AtomicLong();
    private final AtomicLong totalTime = new AtomicLong();
    private final DatabaseRenderer databaseRenderer;
    private boolean inShutdown;
    private boolean isRunning;
    private final JobQueue<RendererJob> jobQueue;
    private final Layer layer;
    private ExecutorService self;
    private ExecutorService workers;
    private final TileCache tileCache;

    public MapWorkerPool(TileCache tileCache, JobQueue<RendererJob> jobQueue, DatabaseRenderer databaseRenderer, Layer layer) {
        this.tileCache = tileCache;
        this.jobQueue = jobQueue;
        this.databaseRenderer = databaseRenderer;
        this.layer = layer;
        this.inShutdown = false;
        this.isRunning = false;
    }

    @Override
    public void run() {
        try {
            while (!this.inShutdown) {
                RendererJob rendererJob = this.jobQueue.get(NUMBER_OF_THREADS);
                if (rendererJob == null) continue;
                if (!this.tileCache.containsKey(rendererJob) || rendererJob.labelsOnly) {
                    this.workers.execute(new MapWorker(rendererJob));
                    continue;
                }
                this.jobQueue.remove(rendererJob);
            }
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.SEVERE, "MapWorkerPool interrupted", e);
        }
        catch (RejectedExecutionException e) {
            LOGGER.log(Level.SEVERE, "MapWorkerPool rejected", e);
        }
    }

    public synchronized void start() {
        if (this.isRunning) {
            return;
        }
        this.inShutdown = false;
        this.self = Executors.newSingleThreadExecutor();
        this.workers = Executors.newFixedThreadPool(NUMBER_OF_THREADS);
        this.self.execute(this);
        this.isRunning = true;
    }

    public synchronized void stop() {
        if (!this.isRunning) {
            return;
        }
        this.inShutdown = true;
        this.jobQueue.interrupt();
        this.self.shutdown();
        this.workers.shutdown();
        try {
            if (!this.self.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                this.self.shutdownNow();
                if (!this.self.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                    LOGGER.warning("Shutdown self executor failed");
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.SEVERE, "Shutdown self executor interrupted", e);
        }
        try {
            if (!this.workers.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                this.workers.shutdownNow();
                if (!this.workers.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                    LOGGER.warning("Shutdown workers executor failed");
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.log(Level.SEVERE, "Shutdown workers executor interrupted", e);
        }
        this.isRunning = false;
    }

    class MapWorker
    implements Runnable {
        private final RendererJob rendererJob;

        MapWorker(RendererJob rendererJob) {
            this.rendererJob = rendererJob;
            this.rendererJob.renderThemeFuture.incrementRefCount();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            TileBitmap bitmap = null;
            try {
                long start = 0L;
                if (MapWorkerPool.this.inShutdown) {
                    return;
                }
                if (DEBUG_TIMING) {
                    start = System.currentTimeMillis();
                    LOGGER.info("ConcurrentJobs " + MapWorkerPool.this.concurrentJobs.incrementAndGet());
                }
                bitmap = MapWorkerPool.this.databaseRenderer.executeJob(this.rendererJob);
                if (MapWorkerPool.this.inShutdown) {
                    return;
                }
                if (!this.rendererJob.labelsOnly && bitmap != null) {
                    MapWorkerPool.this.tileCache.put(this.rendererJob, bitmap);
                    MapWorkerPool.this.databaseRenderer.removeTileInProgress(this.rendererJob.tile);
                }
                MapWorkerPool.this.layer.requestRedraw();
                if (DEBUG_TIMING) {
                    long end = System.currentTimeMillis();
                    long te = MapWorkerPool.this.totalExecutions.incrementAndGet();
                    long tt = MapWorkerPool.this.totalTime.addAndGet(end - start);
                    if (te % 10L == 0L) {
                        LOGGER.info("TIMING " + Long.toString(te) + " " + Double.toString(tt / te));
                    }
                    MapWorkerPool.this.concurrentJobs.decrementAndGet();
                }
            }
            finally {
                this.rendererJob.renderThemeFuture.decrementRefCount();
                MapWorkerPool.this.jobQueue.remove(this.rendererJob);
                if (bitmap != null) {
                    bitmap.decrementRefCount();
                }
            }
        }
    }
}

