/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.layer.renderer;

import java.util.List;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Tag;
import org.mapsforge.core.model.Tile;
import org.mapsforge.core.util.LatLongUtils;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.datastore.Way;
import org.mapsforge.map.layer.renderer.GeometryUtils;
import org.mapsforge.map.layer.renderer.ShapeContainer;
import org.mapsforge.map.layer.renderer.ShapeType;

public class PolylineContainer
implements ShapeContainer {
    private Point center;
    private Point[][] coordinatesAbsolute;
    private Point[][] coordinatesRelativeToTile;
    private final List<Tag> tags;
    private final byte layer;
    private final Tile upperLeft;
    private final Tile lowerRight;
    private final boolean isClosedWay;
    private Way way;

    public PolylineContainer(Way way, Tile upperLeft, Tile lowerRight) {
        this.coordinatesAbsolute = null;
        this.coordinatesRelativeToTile = null;
        this.tags = way.tags;
        this.upperLeft = upperLeft;
        this.lowerRight = lowerRight;
        this.layer = way.layer;
        this.way = way;
        this.isClosedWay = LatLongUtils.isClosedWay((LatLong[])way.latLongs[0]);
    }

    public PolylineContainer(Point[] coordinates, Tile upperLeft, Tile lowerRight, List<Tag> tags) {
        this.coordinatesAbsolute = new Point[1][];
        this.coordinatesRelativeToTile = null;
        this.coordinatesAbsolute[0] = new Point[coordinates.length];
        System.arraycopy(coordinates, 0, this.coordinatesAbsolute[0], 0, coordinates.length);
        this.tags = tags;
        this.upperLeft = upperLeft;
        this.lowerRight = lowerRight;
        this.layer = 0;
        this.isClosedWay = coordinates[0].equals((Object)coordinates[coordinates.length - 1]);
    }

    public Point getCenterAbsolute() {
        if (null == this.center) {
            this.center = GeometryUtils.calculateCenterOfBoundingBox(this.getCoordinatesAbsolute()[0]);
        }
        return this.center;
    }

    public Point[][] getCoordinatesAbsolute() {
        if (this.coordinatesAbsolute == null) {
            this.coordinatesAbsolute = new Point[this.way.latLongs.length][];
            for (int i = 0; i < this.way.latLongs.length; ++i) {
                this.coordinatesAbsolute[i] = new Point[this.way.latLongs[i].length];
                for (int j = 0; j < this.way.latLongs[i].length; ++j) {
                    this.coordinatesAbsolute[i][j] = MercatorProjection.getPixelAbsolute((LatLong)this.way.latLongs[i][j], (long)this.upperLeft.mapSize);
                }
            }
            this.way = null;
        }
        return this.coordinatesAbsolute;
    }

    public Point[][] getCoordinatesRelativeToOrigin() {
        if (this.coordinatesRelativeToTile == null) {
            Point tileOrigin = this.upperLeft.getOrigin();
            this.coordinatesRelativeToTile = new Point[this.getCoordinatesAbsolute().length][];
            for (int i = 0; i < this.coordinatesRelativeToTile.length; ++i) {
                this.coordinatesRelativeToTile[i] = new Point[this.coordinatesAbsolute[i].length];
                for (int j = 0; j < this.coordinatesRelativeToTile[i].length; ++j) {
                    this.coordinatesRelativeToTile[i][j] = this.coordinatesAbsolute[i][j].offset(-tileOrigin.x, -tileOrigin.y);
                }
            }
        }
        return this.coordinatesRelativeToTile;
    }

    public byte getLayer() {
        return this.layer;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.POLYLINE;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public boolean isClosedWay() {
        return this.isClosedWay;
    }

    public Tile getUpperLeft() {
        return this.upperLeft;
    }

    public Tile getLowerRight() {
        return this.lowerRight;
    }
}

