/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.model;

import org.mapsforge.core.graphics.Filter;
import org.mapsforge.map.model.common.Observable;
import org.mapsforge.map.rendertheme.ThemeCallback;

public class DisplayModel
extends Observable {
    private static final int DEFAULT_BACKGROUND_COLOR = -1118482;
    private static final int DEFAULT_TILE_SIZE = 256;
    private static final float DEFAULT_MAX_TEXT_WIDTH_FACTOR = 0.7f;
    private static final int DEFAULT_MAX_TEXT_WIDTH = 179;
    private static float defaultUserScaleFactor = 1.0f;
    private static float deviceScaleFactor = 1.0f;
    private int backgroundColor = -1118482;
    private Filter filter = Filter.NONE;
    private int fixedTileSize;
    private int maxTextWidth = 179;
    private float maxTextWidthFactor = 0.7f;
    private ThemeCallback themeCallback;
    private int tileSize = 256;
    private int tileSizeMultiple = 64;
    private float userScaleFactor = defaultUserScaleFactor;

    public static synchronized float getDefaultUserScaleFactor() {
        return defaultUserScaleFactor;
    }

    public static synchronized float getDeviceScaleFactor() {
        return deviceScaleFactor;
    }

    public static synchronized void setDefaultUserScaleFactor(float scaleFactor) {
        defaultUserScaleFactor = scaleFactor;
    }

    public static synchronized void setDeviceScaleFactor(float scaleFactor) {
        deviceScaleFactor = scaleFactor;
    }

    public DisplayModel() {
        this.setTileSize();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof DisplayModel)) {
            return false;
        }
        DisplayModel other = (DisplayModel)obj;
        if (this.backgroundColor != other.backgroundColor) {
            return false;
        }
        if (this.filter != other.filter) {
            return false;
        }
        if (this.fixedTileSize != other.fixedTileSize) {
            return false;
        }
        if (this.maxTextWidth != other.maxTextWidth) {
            return false;
        }
        if (Float.floatToIntBits(this.maxTextWidthFactor) != Float.floatToIntBits(other.maxTextWidthFactor)) {
            return false;
        }
        if (this.tileSize != other.tileSize) {
            return false;
        }
        if (this.tileSizeMultiple != other.tileSizeMultiple) {
            return false;
        }
        return Float.floatToIntBits(this.userScaleFactor) == Float.floatToIntBits(other.userScaleFactor);
    }

    public synchronized int getBackgroundColor() {
        return this.backgroundColor;
    }

    public synchronized Filter getFilter() {
        return this.filter;
    }

    public int getMaxTextWidth() {
        return this.maxTextWidth;
    }

    public synchronized float getScaleFactor() {
        return deviceScaleFactor * this.userScaleFactor;
    }

    public synchronized ThemeCallback getThemeCallback() {
        return this.themeCallback;
    }

    public synchronized int getTileSize() {
        return this.tileSize;
    }

    public synchronized int getTileSizeMultiple() {
        return this.tileSizeMultiple;
    }

    public synchronized float getUserScaleFactor() {
        return this.userScaleFactor;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.backgroundColor;
        result = 31 * result + this.filter.hashCode();
        result = 31 * result + this.fixedTileSize;
        result = 31 * result + this.maxTextWidth;
        result = 31 * result + Float.floatToIntBits(this.maxTextWidthFactor);
        result = 31 * result + this.tileSize;
        result = 31 * result + this.tileSizeMultiple;
        result = 31 * result + Float.floatToIntBits(this.userScaleFactor);
        return result;
    }

    public synchronized void setBackgroundColor(int color) {
        this.backgroundColor = color;
    }

    public synchronized void setFilter(Filter filter) {
        this.filter = filter;
    }

    public void setFixedTileSize(int tileSize) {
        this.fixedTileSize = tileSize;
        this.setTileSize();
    }

    public void setMaxTextWidthFactor(float maxTextWidthFactor) {
        this.maxTextWidthFactor = maxTextWidthFactor;
        this.setMaxTextWidth();
    }

    public synchronized void setThemeCallback(ThemeCallback themeCallback) {
        this.themeCallback = themeCallback;
    }

    public synchronized void setTileSizeMultiple(int multiple) {
        this.tileSizeMultiple = multiple;
        this.setTileSize();
    }

    public synchronized void setUserScaleFactor(float scaleFactor) {
        this.userScaleFactor = scaleFactor;
        this.setTileSize();
    }

    private void setMaxTextWidth() {
        this.maxTextWidth = (int)((float)this.tileSize * this.maxTextWidthFactor);
    }

    private void setTileSize() {
        if (this.fixedTileSize == 0) {
            float temp = 256.0f * deviceScaleFactor * this.userScaleFactor;
            this.tileSize = Math.max(this.tileSizeMultiple, Math.round(temp / (float)this.tileSizeMultiple) * this.tileSizeMultiple);
        } else {
            this.tileSize = this.fixedTileSize;
        }
        this.setMaxTextWidth();
    }
}

