/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import org.mapsforge.map.rendertheme.XmlRenderTheme;
import org.mapsforge.map.rendertheme.XmlRenderThemeMenuCallback;

public class ExternalRenderTheme
implements XmlRenderTheme {
    private final long lastModifiedTime;
    private final XmlRenderThemeMenuCallback menuCallback;
    private final File renderThemeFile;

    public ExternalRenderTheme(File renderThemeFile) throws FileNotFoundException {
        this(renderThemeFile, null);
    }

    public ExternalRenderTheme(File renderThemeFile, XmlRenderThemeMenuCallback menuCallback) throws FileNotFoundException {
        if (!renderThemeFile.exists()) {
            throw new FileNotFoundException("file does not exist: " + renderThemeFile.getAbsolutePath());
        }
        if (!renderThemeFile.isFile()) {
            throw new FileNotFoundException("not a file: " + renderThemeFile.getAbsolutePath());
        }
        if (!renderThemeFile.canRead()) {
            throw new FileNotFoundException("cannot read file: " + renderThemeFile.getAbsolutePath());
        }
        this.lastModifiedTime = renderThemeFile.lastModified();
        if (this.lastModifiedTime == 0L) {
            throw new FileNotFoundException("cannot read last modified time: " + renderThemeFile.getAbsolutePath());
        }
        this.renderThemeFile = renderThemeFile;
        this.menuCallback = menuCallback;
    }

    public ExternalRenderTheme(String renderThemePath) throws FileNotFoundException {
        this(renderThemePath, null);
    }

    public ExternalRenderTheme(String renderThemePath, XmlRenderThemeMenuCallback menuCallback) throws FileNotFoundException {
        this(new File(renderThemePath), menuCallback);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ExternalRenderTheme)) {
            return false;
        }
        ExternalRenderTheme other = (ExternalRenderTheme)obj;
        if (this.lastModifiedTime != other.lastModifiedTime) {
            return false;
        }
        return !(this.renderThemeFile == null ? other.renderThemeFile != null : !this.renderThemeFile.equals(other.renderThemeFile));
    }

    @Override
    public XmlRenderThemeMenuCallback getMenuCallback() {
        return this.menuCallback;
    }

    @Override
    public String getRelativePathPrefix() {
        return this.renderThemeFile.getParent();
    }

    @Override
    public InputStream getRenderThemeAsStream() throws FileNotFoundException {
        return new FileInputStream(this.renderThemeFile);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.lastModifiedTime ^ this.lastModifiedTime >>> 32);
        result = 31 * result + (this.renderThemeFile == null ? 0 : this.renderThemeFile.hashCode());
        return result;
    }
}

