/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme.renderinstruction;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Rectangle;
import org.mapsforge.core.model.Tile;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.layer.hills.HillsRenderConfig;
import org.mapsforge.map.layer.renderer.HillshadingContainer;
import org.mapsforge.map.layer.renderer.ShapePaintContainer;
import org.mapsforge.map.rendertheme.RenderContext;

public class Hillshading {
    private static final Logger LOGGER = Logger.getLogger(Hillshading.class.getName());
    private final GraphicFactory graphicFactory;
    private final int level;
    private final byte layer;
    private final byte minZoom;
    private final byte maxZoom;
    private final float magnitude;

    public Hillshading(byte minZoom, byte maxZoom, short magnitude, byte layer, int level, GraphicFactory graphicFactory) {
        this.graphicFactory = graphicFactory;
        this.level = level;
        this.layer = layer;
        this.minZoom = minZoom;
        this.maxZoom = maxZoom;
        this.magnitude = (float)Math.min(Math.max(0, magnitude), 255) / 255.0f;
    }

    public void render(RenderContext renderContext, HillsRenderConfig hillsRenderConfig) {
        if (hillsRenderConfig == null) {
            return;
        }
        Tile tile = renderContext.rendererJob.tile;
        byte zoomLevel = tile.zoomLevel;
        if (zoomLevel > this.maxZoom || zoomLevel < this.minZoom) {
            return;
        }
        Point origin = tile.getOrigin();
        double maptileTopLat = MercatorProjection.pixelYToLatitude((double)((long)origin.y), (long)tile.mapSize);
        double maptileLeftLng = MercatorProjection.pixelXToLongitude((double)((long)origin.x), (long)tile.mapSize);
        double maptileBottomLat = MercatorProjection.pixelYToLatitude((double)((long)origin.y + (long)tile.tileSize), (long)tile.mapSize);
        double maptileRightLng = MercatorProjection.pixelXToLongitude((double)((long)origin.x + (long)tile.tileSize), (long)tile.mapSize);
        if (maptileRightLng < maptileLeftLng) {
            maptileRightLng += (double)tile.mapSize;
        }
        int shadingLngStep = 1;
        int shadingLatStep = 1;
        int shadingLeftLng = (int)maptileLeftLng;
        while ((double)shadingLeftLng <= maptileRightLng) {
            int shadingBottomLat = (int)maptileBottomLat;
            while ((double)shadingBottomLat <= maptileTopLat) {
                int shadingRightLng = shadingLeftLng + 1;
                int shadingTopLat = shadingBottomLat + 1;
                Bitmap shadingTile = null;
                try {
                    shadingTile = hillsRenderConfig.getShadingTile(shadingBottomLat, shadingLeftLng);
                }
                catch (Exception e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
                if (shadingTile != null) {
                    double shadingPixelOffset = 0.0;
                    double shadingSubrectTop = 0.0;
                    double shadingSubrectLeft = 0.0;
                    double shadingSubrectRight = shadingTile.getWidth();
                    double shadingSubrectBottom = shadingTile.getHeight();
                    double maptileSubrectLeft = 0.0;
                    double maptileSubrectTop = 0.0;
                    double maptileSubrectRight = tile.tileSize;
                    double maptileSubrectBottom = tile.tileSize;
                    if ((double)shadingTopLat > maptileTopLat) {
                        shadingSubrectTop = (double)shadingTile.getHeight() * (((double)shadingTopLat - maptileTopLat) / (double)shadingLatStep);
                    } else if (maptileTopLat > (double)shadingTopLat) {
                        maptileSubrectTop = MercatorProjection.latitudeToPixelY((double)((double)shadingTopLat + shadingPixelOffset / (double)shadingTile.getHeight()), (long)tile.mapSize) - origin.y;
                    }
                    if ((double)shadingBottomLat < maptileBottomLat) {
                        shadingSubrectBottom = (double)shadingTile.getHeight() - (double)shadingTile.getHeight() * ((maptileBottomLat - (double)shadingBottomLat) / (double)shadingLatStep);
                    } else if (maptileBottomLat < (double)shadingBottomLat) {
                        maptileSubrectBottom = MercatorProjection.latitudeToPixelY((double)((double)shadingBottomLat + shadingPixelOffset / (double)shadingTile.getHeight()), (long)tile.mapSize) - origin.y;
                    }
                    if ((double)shadingLeftLng < maptileLeftLng) {
                        shadingSubrectLeft = (double)shadingTile.getWidth() * ((maptileLeftLng - (double)shadingLeftLng) / (double)shadingLngStep);
                    } else if (maptileLeftLng < (double)shadingLeftLng) {
                        maptileSubrectLeft = MercatorProjection.longitudeToPixelX((double)((double)shadingLeftLng + shadingPixelOffset / (double)shadingTile.getWidth()), (long)tile.mapSize) - origin.x;
                    }
                    if ((double)shadingRightLng > maptileRightLng) {
                        shadingSubrectRight = (double)shadingTile.getWidth() - (double)shadingTile.getWidth() * (((double)shadingRightLng - maptileRightLng) / (double)shadingLngStep);
                    } else if (maptileRightLng > (double)shadingRightLng) {
                        maptileSubrectRight = MercatorProjection.longitudeToPixelX((double)((double)shadingRightLng + shadingPixelOffset / (double)shadingTile.getHeight()), (long)tile.mapSize) - origin.x;
                    }
                    Rectangle hillsRect = new Rectangle(shadingSubrectLeft, shadingSubrectTop, shadingSubrectRight, shadingSubrectBottom);
                    Rectangle maptileRect = new Rectangle(maptileSubrectLeft, maptileSubrectTop, maptileSubrectRight, maptileSubrectBottom);
                    HillshadingContainer hillShape = new HillshadingContainer(shadingTile, this.magnitude, hillsRect, maptileRect);
                    renderContext.setDrawingLayers(this.layer);
                    renderContext.addToCurrentDrawingLayer(this.level, new ShapePaintContainer(hillShape, null));
                }
                shadingBottomLat += shadingLatStep;
            }
            shadingLeftLng += shadingLngStep;
        }
    }
}

