/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme.renderinstruction;

import java.io.IOException;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.map.datastore.PointOfInterest;
import org.mapsforge.map.layer.renderer.PolylineContainer;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.rendertheme.RenderCallback;
import org.mapsforge.map.rendertheme.RenderContext;
import org.mapsforge.map.rendertheme.XmlUtils;

public abstract class RenderInstruction {
    static final String ALIGN_CENTER = "align-center";
    static final String ALL = "all";
    static final String CAT = "cat";
    static final String DISPLAY = "display";
    static final String DY = "dy";
    static final String FILL = "fill";
    static final String FONT_FAMILY = "font-family";
    static final String FONT_SIZE = "font-size";
    static final String FONT_STYLE = "font-style";
    static final String ID = "id";
    static final String K = "k";
    static final String NONE = "none";
    static final String POSITION = "position";
    static final String PRIORITY = "priority";
    static final String R = "r";
    static final String RADIUS = "radius";
    static final String REPEAT = "repeat";
    static final String REPEAT_GAP = "repeat-gap";
    static final String REPEAT_START = "repeat-start";
    static final String ROTATE = "rotate";
    static final String SCALE = "scale";
    static final String SCALE_RADIUS = "scale-radius";
    static final String SRC = "src";
    static final String STROKE = "stroke";
    static final String STROKE_DASHARRAY = "stroke-dasharray";
    static final String STROKE_LINECAP = "stroke-linecap";
    static final String STROKE_LINEJOIN = "stroke-linejoin";
    static final String STROKE_WIDTH = "stroke-width";
    static final String SYMBOL_HEIGHT = "symbol-height";
    static final String SYMBOL_ID = "symbol-id";
    static final String SYMBOL_PERCENT = "symbol-percent";
    static final String SYMBOL_SCALING = "symbol-scaling";
    static final String SYMBOL_WIDTH = "symbol-width";
    protected String category;
    public final DisplayModel displayModel;
    public final GraphicFactory graphicFactory;
    protected float height;
    protected int percent = 100;
    protected float width;

    protected RenderInstruction(GraphicFactory graphicFactory, DisplayModel displayModel) {
        this.displayModel = displayModel;
        this.graphicFactory = graphicFactory;
    }

    protected Bitmap createBitmap(String relativePathPrefix, String src) throws IOException {
        if (null == src || src.isEmpty()) {
            return null;
        }
        return XmlUtils.createBitmap(this.graphicFactory, this.displayModel, relativePathPrefix, src, (int)this.width, (int)this.height, this.percent);
    }

    public abstract void destroy();

    public String getCategory() {
        return this.category;
    }

    public abstract void renderNode(RenderCallback var1, RenderContext var2, PointOfInterest var3);

    public abstract void renderWay(RenderCallback var1, RenderContext var2, PolylineContainer var3);

    protected Scale scaleFromValue(String value) {
        if (value.equals(ALL)) {
            return Scale.ALL;
        }
        if (value.equals(NONE)) {
            return Scale.NONE;
        }
        return Scale.STROKE;
    }

    public abstract void scaleStrokeWidth(float var1, byte var2);

    public abstract void scaleTextSize(float var1, byte var2);

    static enum Scale {
        ALL,
        NONE,
        STROKE;

    }
}

