/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme.renderinstruction;

import java.io.IOException;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Display;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.map.datastore.PointOfInterest;
import org.mapsforge.map.layer.renderer.PolylineContainer;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.rendertheme.RenderCallback;
import org.mapsforge.map.rendertheme.RenderContext;
import org.mapsforge.map.rendertheme.XmlUtils;
import org.mapsforge.map.rendertheme.renderinstruction.RenderInstruction;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class Symbol
extends RenderInstruction {
    private Bitmap bitmap;
    private boolean bitmapInvalid;
    private Display display;
    private String id;
    private int priority;
    private final String relativePathPrefix;
    private String src;

    public Symbol(GraphicFactory graphicFactory, DisplayModel displayModel, String elementName, XmlPullParser pullParser, String relativePathPrefix) throws IOException, XmlPullParserException {
        super(graphicFactory, displayModel);
        this.relativePathPrefix = relativePathPrefix;
        this.display = Display.IFSPACE;
        this.extractValues(elementName, pullParser);
    }

    @Override
    public void destroy() {
        if (this.bitmap != null) {
            this.bitmap.decrementRefCount();
        }
    }

    private void extractValues(String elementName, XmlPullParser pullParser) throws IOException, XmlPullParserException {
        for (int i = 0; i < pullParser.getAttributeCount(); ++i) {
            String name = pullParser.getAttributeName(i);
            String value = pullParser.getAttributeValue(i);
            if ("src".equals(name)) {
                this.src = value;
                continue;
            }
            if ("cat".equals(name)) {
                this.category = value;
                continue;
            }
            if ("display".equals(name)) {
                this.display = Display.fromString((String)value);
                continue;
            }
            if ("id".equals(name)) {
                this.id = value;
                continue;
            }
            if ("priority".equals(name)) {
                this.priority = Integer.parseInt(value);
                continue;
            }
            if ("symbol-height".equals(name)) {
                this.height = (float)XmlUtils.parseNonNegativeInteger(name, value) * this.displayModel.getScaleFactor();
                continue;
            }
            if ("symbol-percent".equals(name)) {
                this.percent = XmlUtils.parseNonNegativeInteger(name, value);
                continue;
            }
            if ("symbol-scaling".equals(name)) continue;
            if ("symbol-width".equals(name)) {
                this.width = (float)XmlUtils.parseNonNegativeInteger(name, value) * this.displayModel.getScaleFactor();
                continue;
            }
            throw XmlUtils.createXmlPullParserException(elementName, name, value, i);
        }
    }

    public Bitmap getBitmap() {
        if (this.bitmap == null && !this.bitmapInvalid) {
            try {
                this.bitmap = this.createBitmap(this.relativePathPrefix, this.src);
            }
            catch (IOException ioException) {
                this.bitmapInvalid = true;
            }
        }
        return this.bitmap;
    }

    public String getId() {
        return this.id;
    }

    @Override
    public void renderNode(RenderCallback renderCallback, RenderContext renderContext, PointOfInterest poi) {
        if (Display.NEVER == this.display) {
            return;
        }
        if (this.getBitmap() != null) {
            renderCallback.renderPointOfInterestSymbol(renderContext, this.display, this.priority, this.bitmap, poi);
        }
    }

    @Override
    public void renderWay(RenderCallback renderCallback, RenderContext renderContext, PolylineContainer way) {
        if (Display.NEVER == this.display) {
            return;
        }
        if (this.getBitmap() != null) {
            renderCallback.renderAreaSymbol(renderContext, this.display, this.priority, this.bitmap, way);
        }
    }

    @Override
    public void scaleStrokeWidth(float scaleFactor, byte zoomLevel) {
    }

    @Override
    public void scaleTextSize(float scaleFactor, byte zoomLevel) {
    }
}

