/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.rendertheme.rule;

import org.mapsforge.core.graphics.Color;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.rendertheme.XmlUtils;
import org.mapsforge.map.rendertheme.rule.RenderTheme;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RenderThemeBuilder {
    private static final String BASE_STROKE_WIDTH = "base-stroke-width";
    private static final String BASE_TEXT_SIZE = "base-text-size";
    private static final String MAP_BACKGROUND = "map-background";
    private static final String MAP_BACKGROUND_OUTSIDE = "map-background-outside";
    private static final int RENDER_THEME_VERSION = 5;
    private static final String VERSION = "version";
    private static final String XMLNS = "xmlns";
    private static final String XMLNS_XSI = "xmlns:xsi";
    private static final String XSI_SCHEMALOCATION = "xsi:schemaLocation";
    float baseStrokeWidth;
    float baseTextSize;
    private final DisplayModel displayModel;
    boolean hasBackgroundOutside;
    int mapBackground;
    int mapBackgroundOutside;
    private Integer version;

    public RenderThemeBuilder(GraphicFactory graphicFactory, DisplayModel displayModel, String elementName, XmlPullParser pullParser) throws XmlPullParserException {
        this.displayModel = displayModel;
        this.baseStrokeWidth = 1.0f;
        this.baseTextSize = 1.0f;
        this.mapBackground = graphicFactory.createColor(Color.WHITE);
        this.extractValues(graphicFactory, elementName, pullParser);
    }

    public RenderTheme build() {
        return new RenderTheme(this);
    }

    private void extractValues(GraphicFactory graphicFactory, String elementName, XmlPullParser pullParser) throws XmlPullParserException {
        for (int i = 0; i < pullParser.getAttributeCount(); ++i) {
            String name = pullParser.getAttributeName(i);
            String value = pullParser.getAttributeValue(i);
            if (XMLNS.equals(name) || XMLNS_XSI.equals(name) || XSI_SCHEMALOCATION.equals(name)) continue;
            if (VERSION.equals(name)) {
                this.version = XmlUtils.parseNonNegativeInteger(name, value);
                continue;
            }
            if (MAP_BACKGROUND.equals(name)) {
                this.mapBackground = XmlUtils.getColor(graphicFactory, value, this.displayModel.getThemeCallback());
                continue;
            }
            if (MAP_BACKGROUND_OUTSIDE.equals(name)) {
                this.mapBackgroundOutside = XmlUtils.getColor(graphicFactory, value, this.displayModel.getThemeCallback());
                this.hasBackgroundOutside = true;
                continue;
            }
            if (BASE_STROKE_WIDTH.equals(name)) {
                this.baseStrokeWidth = XmlUtils.parseNonNegativeFloat(name, value);
                continue;
            }
            if (BASE_TEXT_SIZE.equals(name)) {
                this.baseTextSize = XmlUtils.parseNonNegativeFloat(name, value);
                continue;
            }
            throw XmlUtils.createXmlPullParserException(elementName, name, value, i);
        }
        this.validate(elementName);
    }

    private void validate(String elementName) throws XmlPullParserException {
        XmlUtils.checkMandatoryAttribute(elementName, VERSION, this.version);
        if (this.version > 5) {
            throw new XmlPullParserException("unsupported render theme version: " + this.version);
        }
    }
}

