/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.scalebar;

import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.GraphicContext;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.model.MapPosition;
import org.mapsforge.core.util.MercatorProjection;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.model.MapViewDimension;
import org.mapsforge.map.model.MapViewPosition;
import org.mapsforge.map.scalebar.DistanceUnitAdapter;
import org.mapsforge.map.scalebar.MetricUnitAdapter;

public abstract class MapScaleBar {
    private static final ScaleBarPosition DEFAULT_SCALE_BAR_POSITION = ScaleBarPosition.BOTTOM_LEFT;
    private static final double LATITUDE_REDRAW_THRESHOLD = 0.2;
    protected final DisplayModel displayModel;
    protected DistanceUnitAdapter distanceUnitAdapter;
    protected final GraphicFactory graphicFactory;
    protected final Bitmap mapScaleBitmap;
    protected final Canvas mapScaleCanvas;
    private final MapViewDimension mapViewDimension;
    private final MapViewPosition mapViewPosition;
    private int marginHorizontal;
    private int marginVertical;
    private MapPosition prevMapPosition;
    protected boolean redrawNeeded;
    protected ScaleBarPosition scaleBarPosition;
    private boolean visible;

    public MapScaleBar(MapViewPosition mapViewPosition, MapViewDimension mapViewDimension, DisplayModel displayModel, GraphicFactory graphicFactory, int width, int height) {
        this.mapViewPosition = mapViewPosition;
        this.mapViewDimension = mapViewDimension;
        this.displayModel = displayModel;
        this.graphicFactory = graphicFactory;
        this.mapScaleBitmap = graphicFactory.createBitmap(width, height);
        this.scaleBarPosition = DEFAULT_SCALE_BAR_POSITION;
        this.mapScaleCanvas = graphicFactory.createCanvas();
        this.mapScaleCanvas.setBitmap(this.mapScaleBitmap);
        this.distanceUnitAdapter = MetricUnitAdapter.INSTANCE;
        this.visible = true;
        this.redrawNeeded = true;
    }

    public void destroy() {
        this.mapScaleBitmap.decrementRefCount();
        this.mapScaleCanvas.destroy();
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public DistanceUnitAdapter getDistanceUnitAdapter() {
        return this.distanceUnitAdapter;
    }

    public void setDistanceUnitAdapter(DistanceUnitAdapter distanceUnitAdapter) {
        if (distanceUnitAdapter == null) {
            throw new IllegalArgumentException("adapter must not be null");
        }
        this.distanceUnitAdapter = distanceUnitAdapter;
        this.redrawNeeded = true;
    }

    public int getMarginHorizontal() {
        return this.marginHorizontal;
    }

    public void setMarginHorizontal(int marginHorizontal) {
        if (this.marginHorizontal != marginHorizontal) {
            this.marginHorizontal = marginHorizontal;
            this.redrawNeeded = true;
        }
    }

    public int getMarginVertical() {
        return this.marginVertical;
    }

    public void setMarginVertical(int marginVertical) {
        if (this.marginVertical != marginVertical) {
            this.marginVertical = marginVertical;
            this.redrawNeeded = true;
        }
    }

    public ScaleBarPosition getScaleBarPosition() {
        return this.scaleBarPosition;
    }

    public void setScaleBarPosition(ScaleBarPosition scaleBarPosition) {
        if (this.scaleBarPosition != scaleBarPosition) {
            this.scaleBarPosition = scaleBarPosition;
            this.redrawNeeded = true;
        }
    }

    private int calculatePositionLeft(int left, int right, int width) {
        switch (this.scaleBarPosition) {
            case BOTTOM_LEFT: 
            case TOP_LEFT: {
                return this.marginHorizontal;
            }
            case BOTTOM_CENTER: 
            case TOP_CENTER: {
                return (right - left - width) / 2;
            }
            case BOTTOM_RIGHT: 
            case TOP_RIGHT: {
                return right - left - width - this.marginHorizontal;
            }
        }
        throw new IllegalArgumentException("unknown horizontal position: " + (Object)((Object)this.scaleBarPosition));
    }

    private int calculatePositionTop(int top, int bottom, int height) {
        switch (this.scaleBarPosition) {
            case TOP_LEFT: 
            case TOP_CENTER: 
            case TOP_RIGHT: {
                return this.marginVertical;
            }
            case BOTTOM_LEFT: 
            case BOTTOM_CENTER: 
            case BOTTOM_RIGHT: {
                return bottom - top - height - this.marginVertical;
            }
        }
        throw new IllegalArgumentException("unknown vertical position: " + (Object)((Object)this.scaleBarPosition));
    }

    protected ScaleBarLengthAndValue calculateScaleBarLengthAndValue(DistanceUnitAdapter unitAdapter) {
        int scaleBarValue;
        this.prevMapPosition = this.mapViewPosition.getMapPosition();
        double groundResolution = MercatorProjection.calculateGroundResolution((double)this.prevMapPosition.latLong.latitude, (long)MercatorProjection.getMapSize((byte)this.prevMapPosition.zoomLevel, (int)this.displayModel.getTileSize()));
        groundResolution /= unitAdapter.getMeterRatio();
        int[] scaleBarValues = unitAdapter.getScaleBarValues();
        int scaleBarLength = 0;
        int mapScaleValue = 0;
        int[] nArray = scaleBarValues;
        int n = nArray.length;
        for (int i = 0; i < n && (scaleBarLength = (int)((double)(mapScaleValue = (scaleBarValue = nArray[i])) / groundResolution)) >= this.mapScaleBitmap.getWidth() - 10; ++i) {
        }
        return new ScaleBarLengthAndValue(scaleBarLength, mapScaleValue);
    }

    protected ScaleBarLengthAndValue calculateScaleBarLengthAndValue() {
        return this.calculateScaleBarLengthAndValue(this.distanceUnitAdapter);
    }

    public void draw(GraphicContext graphicContext) {
        if (!this.visible) {
            return;
        }
        if (this.mapViewDimension.getDimension() == null) {
            return;
        }
        if (this.isRedrawNecessary()) {
            this.redraw(this.mapScaleCanvas);
            this.redrawNeeded = false;
        }
        int positionLeft = this.calculatePositionLeft(0, this.mapViewDimension.getDimension().width, this.mapScaleBitmap.getWidth());
        int positionTop = this.calculatePositionTop(0, this.mapViewDimension.getDimension().height, this.mapScaleBitmap.getHeight());
        graphicContext.drawBitmap(this.mapScaleBitmap, positionLeft, positionTop);
    }

    public void drawScaleBar() {
        this.draw((GraphicContext)this.mapScaleCanvas);
    }

    public void redrawScaleBar() {
        this.redrawNeeded = true;
    }

    protected boolean isRedrawNecessary() {
        if (this.redrawNeeded || this.prevMapPosition == null) {
            return true;
        }
        MapPosition currentMapPosition = this.mapViewPosition.getMapPosition();
        if (currentMapPosition.zoomLevel != this.prevMapPosition.zoomLevel) {
            return true;
        }
        double latitudeDiff = Math.abs(currentMapPosition.latLong.latitude - this.prevMapPosition.latLong.latitude);
        return latitudeDiff > 0.2;
    }

    protected abstract void redraw(Canvas var1);

    protected static class ScaleBarLengthAndValue {
        public int scaleBarLength;
        public int scaleBarValue;

        public ScaleBarLengthAndValue(int scaleBarLength, int scaleBarValue) {
            this.scaleBarLength = scaleBarLength;
            this.scaleBarValue = scaleBarValue;
        }
    }

    public static enum ScaleBarPosition {
        BOTTOM_CENTER,
        BOTTOM_LEFT,
        BOTTOM_RIGHT,
        TOP_CENTER,
        TOP_LEFT,
        TOP_RIGHT;

    }
}

