/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.view;

import java.util.concurrent.TimeUnit;
import org.mapsforge.core.graphics.Color;
import org.mapsforge.core.graphics.FontFamily;
import org.mapsforge.core.graphics.FontStyle;
import org.mapsforge.core.graphics.GraphicContext;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Style;
import org.mapsforge.map.model.DisplayModel;

public class FpsCounter {
    private static final long ONE_SECOND = TimeUnit.SECONDS.toNanos(1L);
    private final DisplayModel displayModel;
    private String fps;
    private int frameCounter;
    private long lastTime;
    private final Paint paintBack;
    private final Paint paintFront;
    private boolean visible;

    private static Paint createPaintFront(GraphicFactory graphicFactory, DisplayModel displayModel) {
        Paint paint = graphicFactory.createPaint();
        paint.setColor(Color.RED);
        paint.setTypeface(FontFamily.DEFAULT, FontStyle.BOLD);
        paint.setTextSize(25.0f * displayModel.getScaleFactor());
        return paint;
    }

    private static Paint createPaintBack(GraphicFactory graphicFactory, DisplayModel displayModel) {
        Paint paint = graphicFactory.createPaint();
        paint.setColor(Color.WHITE);
        paint.setTypeface(FontFamily.DEFAULT, FontStyle.BOLD);
        paint.setTextSize(25.0f * displayModel.getScaleFactor());
        paint.setStrokeWidth(2.0f * displayModel.getScaleFactor());
        paint.setStyle(Style.STROKE);
        return paint;
    }

    public FpsCounter(GraphicFactory graphicFactory, DisplayModel displayModel) {
        this.displayModel = displayModel;
        this.paintBack = FpsCounter.createPaintBack(graphicFactory, displayModel);
        this.paintFront = FpsCounter.createPaintFront(graphicFactory, displayModel);
    }

    public FpsCounter(DisplayModel displayModel, Paint paintBack, Paint paintFront) {
        this.displayModel = displayModel;
        this.paintBack = paintBack;
        this.paintFront = paintFront;
    }

    public void draw(GraphicContext graphicContext) {
        if (!this.visible) {
            return;
        }
        long currentTime = System.nanoTime();
        long elapsedTime = currentTime - this.lastTime;
        if (elapsedTime > ONE_SECOND) {
            this.fps = String.valueOf(Math.round((float)((long)this.frameCounter * ONE_SECOND) / (float)elapsedTime));
            this.lastTime = currentTime;
            this.frameCounter = 0;
        }
        int x = (int)(20.0f * this.displayModel.getScaleFactor());
        int y = (int)(40.0f * this.displayModel.getScaleFactor());
        graphicContext.drawText(this.fps, x, y, this.paintBack);
        graphicContext.drawText(this.fps, x, y, this.paintFront);
        ++this.frameCounter;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }
}

