/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.view;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.GraphicContext;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.model.MapPosition;
import org.mapsforge.map.model.DisplayModel;
import org.mapsforge.map.model.FrameBufferModel;
import org.mapsforge.map.view.FrameBuffer;

public class FrameBufferHA
extends FrameBuffer {
    private static final Logger LOGGER = Logger.getLogger(FrameBufferHA.class.getName());
    private boolean allowBitmapSwap = true;
    private final Object lmBitmapLock = new Object();
    private MapPosition lmMapPosition;

    public FrameBufferHA(FrameBufferModel frameBufferModel, DisplayModel displayModel, GraphicFactory graphicFactory) {
        super(frameBufferModel, displayModel, graphicFactory);
    }

    @Override
    public void draw(GraphicContext graphicContext) {
        graphicContext.fillColor(this.displayModel.getBackgroundColor());
        this.swapBitmaps();
        if (this.odBitmap != null) {
            graphicContext.drawBitmap(this.odBitmap, this.matrix);
        }
    }

    @Override
    public void frameFinished(MapPosition frameMapPosition) {
        this.freeLmBitmap(frameMapPosition);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeLmBitmap(MapPosition frameMapPosition) {
        Object object = this.lmBitmapLock;
        synchronized (object) {
            this.lmMapPosition = frameMapPosition;
            this.allowBitmapSwap = true;
        }
    }

    @Override
    public Bitmap getDrawingBitmap() {
        this.lockLmBitmap();
        return super.getDrawingBitmap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void lockLmBitmap() {
        Object object = this.lmBitmapLock;
        synchronized (object) {
            if (this.lmBitmap != null && this.allowBitmapSwap) {
                try {
                    this.lmBitmapLock.wait();
                }
                catch (InterruptedException e) {
                    LOGGER.log(Level.SEVERE, e.getMessage(), e);
                }
            }
            this.allowBitmapSwap = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void swapBitmaps() {
        Object object = this.lmBitmapLock;
        synchronized (object) {
            if (this.allowBitmapSwap) {
                Bitmap bitmapTemp = this.odBitmap;
                this.odBitmap = this.lmBitmap;
                this.lmBitmap = bitmapTemp;
                this.frameBufferModel.setMapPosition(this.lmMapPosition);
                this.allowBitmapSwap = false;
                this.lmBitmapLock.notify();
            }
        }
    }
}

