/*
 * Decompiled with CFR 0.152.
 */
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class GenerateAttributes {
    public static void main(String[] args) {
        File inFile = new File(args[0]);
        try {
            GenerateAttributes.writeHeader();
            FileInputStream inputStream = new FileInputStream(inFile);
            InputStreamReader reader = new InputStreamReader((InputStream)inputStream, "UTF-8");
            InputSource is = new InputSource(reader);
            is.setEncoding("UTF-8");
            GenerateAttributes.parseAttributes(is);
            GenerateAttributes.writeTrailer();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void writeHeader() {
        System.out.print("// This is a generated file, do not change manually!\n\n# internal name   | gcid | ocid | acode | man | license | copyright holder | URL\n");
    }

    private static String formattedId(int id, int width) {
        String result = String.valueOf("                            ".substring(0, width - 1)) + id;
        return result.substring(result.length() - width);
    }

    private static void writeAttr(AttrInfo attr) {
        System.out.println("                  | " + GenerateAttributes.formattedId(attr.gc_id, 4) + " | " + GenerateAttributes.formattedId(attr.oc_de_id, 4) + " | " + GenerateAttributes.formattedId(attr.acode, 5) + " |");
    }

    private static void writeTrailer() {
        System.out.println();
    }

    private static void parseAttributes(InputSource stream) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            DefaultHandler handler = new DefaultHandler(){
                AttrInfo attr;
                ArrayList<String> names;
                boolean readingName;

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    if (qName.equalsIgnoreCase("attr")) {
                        this.attr = new AttrInfo();
                        this.names = new ArrayList();
                        this.attr.acode = Integer.parseInt(attributes.getValue("acode").substring(1));
                    }
                    if (this.attr != null && qName.equalsIgnoreCase("opencaching")) {
                        if ("http://www.opencaching.de/".equalsIgnoreCase(attributes.getValue("schema"))) {
                            this.attr.oc_de_id = Integer.parseInt(attributes.getValue("id"));
                        } else if ("http://opencaching.pl/".equalsIgnoreCase(attributes.getValue("schema"))) {
                            this.attr.oc_pl_id = Integer.parseInt(attributes.getValue("id"));
                        } else if ("http://www.opencaching.nl/".equalsIgnoreCase(attributes.getValue("schema"))) {
                            this.attr.oc_nl_id = Integer.parseInt(attributes.getValue("id"));
                        }
                    }
                    if (this.attr != null && qName.equalsIgnoreCase("groundspeak")) {
                        this.attr.gc_id = Integer.parseInt(attributes.getValue("id"));
                    }
                    if (this.names != null && qName.equalsIgnoreCase("name")) {
                        this.readingName = true;
                    }
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    if (this.attr != null && qName.equalsIgnoreCase("attr")) {
                        this.attr.names = this.names.toArray(new String[0]);
                        this.names = null;
                        GenerateAttributes.writeAttr(this.attr);
                        this.attr = null;
                    }
                    this.readingName = false;
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    if (this.readingName) {
                        this.names.add(new String(ch, start, length));
                    }
                }
            };
            saxParser.parse(stream, handler);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    static class AttrInfo {
        public int oc_de_id;
        public int oc_nl_id;
        public int oc_pl_id;
        public int acode;
        public int gc_id;
        public String[] names;

        AttrInfo() {
        }
    }
}

