/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.android.graphics;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.mapsforge.core.graphics.Bitmap;

public class AndroidBitmap
implements Bitmap {
    private static final List<AndroidBitmap> BITMAP_LIST;
    private static final AtomicInteger BITMAP_INSTANCES;
    private static final Logger LOGGER;
    private static final Set<SoftReference<android.graphics.Bitmap>> REUSABLE_BITMAPS;
    protected android.graphics.Bitmap bitmap;
    private AtomicInteger refCount = new AtomicInteger();

    protected static android.graphics.Bitmap createAndroidBitmap(int width, int height, Bitmap.Config config) {
        return android.graphics.Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
    }

    protected static final BitmapFactory.Options createBitmapFactoryOptions(Bitmap.Config config) {
        BitmapFactory.Options bitmapFactoryOptions = new BitmapFactory.Options();
        bitmapFactoryOptions.inPreferredConfig = config;
        return bitmapFactoryOptions;
    }

    protected AndroidBitmap() {
    }

    public AndroidBitmap(android.graphics.Bitmap bitmap) {
        this();
        if (bitmap.isRecycled()) {
            throw new IllegalArgumentException("bitmap is already recycled");
        }
        this.bitmap = bitmap;
    }

    AndroidBitmap(int width, int height, Bitmap.Config config) {
        this();
        this.bitmap = this.getBitmapFromReusableSet(width, height, config);
        if (this.bitmap == null) {
            this.bitmap = AndroidBitmap.createAndroidBitmap(width, height, config);
        }
    }

    public void compress(OutputStream outputStream) throws IOException {
        if (!this.bitmap.compress(Bitmap.CompressFormat.PNG, 0, outputStream)) {
            throw new IOException("Failed to write bitmap to output stream");
        }
    }

    public void decrementRefCount() {
        if (this.refCount.decrementAndGet() < 0) {
            this.destroy();
        }
    }

    public int getHeight() {
        return this.bitmap.getHeight();
    }

    public int getWidth() {
        return this.bitmap.getWidth();
    }

    public void incrementRefCount() {
        this.refCount.incrementAndGet();
    }

    public boolean isDestroyed() {
        return this.bitmap == null;
    }

    public void scaleTo(int width, int height) {
        if (this.getWidth() != width || this.getHeight() != height) {
            android.graphics.Bitmap scaledBitmap = android.graphics.Bitmap.createScaledBitmap((android.graphics.Bitmap)this.bitmap, (int)width, (int)height, (boolean)true);
            this.destroy();
            this.bitmap = scaledBitmap;
        }
    }

    public void setBackgroundColor(int color) {
        this.bitmap.eraseColor(color);
    }

    public String toString() {
        String info = this.bitmap != null ? (this.bitmap.hasAlpha() ? " has alpha" : " no alpha") : " is recycled";
        return super.toString() + " rC " + Integer.toString(this.refCount.get()) + info;
    }

    protected final boolean canUseBitmap(android.graphics.Bitmap candidate, int width, int height) {
        return candidate.getWidth() == width && candidate.getHeight() == height;
    }

    protected void destroy() {
        this.destroyBitmap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TargetApi(value=11)
    protected void destroyBitmap() {
        if (this.bitmap != null) {
            if (Build.VERSION.SDK_INT >= 11) {
                Set<SoftReference<android.graphics.Bitmap>> set = REUSABLE_BITMAPS;
                synchronized (set) {
                    REUSABLE_BITMAPS.add(new SoftReference<android.graphics.Bitmap>(this.bitmap));
                }
            } else {
                this.bitmap.recycle();
            }
            this.bitmap = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final android.graphics.Bitmap getBitmapFromReusableSet(int width, int height, Bitmap.Config config) {
        android.graphics.Bitmap result = null;
        if (REUSABLE_BITMAPS != null && !REUSABLE_BITMAPS.isEmpty()) {
            Set<SoftReference<android.graphics.Bitmap>> set = REUSABLE_BITMAPS;
            synchronized (set) {
                Iterator<SoftReference<android.graphics.Bitmap>> iterator = REUSABLE_BITMAPS.iterator();
                while (iterator.hasNext()) {
                    android.graphics.Bitmap candidate = iterator.next().get();
                    if (null != candidate && candidate.isMutable()) {
                        if (!this.canUseBitmap(candidate, width, height)) continue;
                        result = candidate;
                        iterator.remove();
                        break;
                    }
                    iterator.remove();
                }
            }
        }
        return result;
    }

    static {
        LOGGER = Logger.getLogger(AndroidBitmap.class.getName());
        REUSABLE_BITMAPS = new HashSet<SoftReference<android.graphics.Bitmap>>();
        BITMAP_LIST = null;
        BITMAP_INSTANCES = null;
    }
}

