/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.android.graphics;

import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.Region;
import org.mapsforge.core.graphics.Bitmap;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.Color;
import org.mapsforge.core.graphics.Filter;
import org.mapsforge.core.graphics.Matrix;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.model.Dimension;
import org.mapsforge.core.model.Rectangle;
import org.mapsforge.map.android.graphics.AndroidGraphicFactory;

class AndroidCanvas
implements Canvas {
    private static final float[] INVERT_MATRIX = new float[]{-1.0f, 0.0f, 0.0f, 0.0f, 255.0f, 0.0f, -1.0f, 0.0f, 0.0f, 255.0f, 0.0f, 0.0f, -1.0f, 0.0f, 255.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    android.graphics.Canvas canvas;
    private final android.graphics.Paint bitmapPaint = new android.graphics.Paint();
    private final android.graphics.Paint shadePaint = new android.graphics.Paint();
    private ColorFilter grayscaleFilter;
    private ColorFilter grayscaleInvertFilter;
    private ColorFilter invertFilter;

    AndroidCanvas() {
        this.canvas = new android.graphics.Canvas();
        this.bitmapPaint.setAntiAlias(true);
        this.bitmapPaint.setFilterBitmap(true);
        this.shadePaint.setAntiAlias(true);
        this.shadePaint.setFilterBitmap(true);
        this.createFilters();
    }

    AndroidCanvas(android.graphics.Canvas canvas) {
        this.canvas = canvas;
        this.createFilters();
    }

    private void applyFilter(Filter filter) {
        if (filter == Filter.NONE) {
            return;
        }
        switch (filter) {
            case GRAYSCALE: {
                this.bitmapPaint.setColorFilter(this.grayscaleFilter);
                break;
            }
            case GRAYSCALE_INVERT: {
                this.bitmapPaint.setColorFilter(this.grayscaleInvertFilter);
                break;
            }
            case INVERT: {
                this.bitmapPaint.setColorFilter(this.invertFilter);
            }
        }
    }

    private void createFilters() {
        ColorMatrix grayscaleMatrix = new ColorMatrix();
        grayscaleMatrix.setSaturation(0.0f);
        this.grayscaleFilter = new ColorMatrixColorFilter(grayscaleMatrix);
        ColorMatrix grayscaleInvertMatrix = new ColorMatrix();
        grayscaleInvertMatrix.setSaturation(0.0f);
        grayscaleInvertMatrix.postConcat(new ColorMatrix(INVERT_MATRIX));
        this.grayscaleInvertFilter = new ColorMatrixColorFilter(grayscaleInvertMatrix);
        this.invertFilter = new ColorMatrixColorFilter(INVERT_MATRIX);
    }

    public void destroy() {
        this.canvas = null;
    }

    public void drawBitmap(Bitmap bitmap, int left, int top) {
        this.canvas.drawBitmap(AndroidGraphicFactory.getBitmap(bitmap), (float)left, (float)top, this.bitmapPaint);
    }

    public void drawBitmap(Bitmap bitmap, int left, int top, Filter filter) {
        this.applyFilter(filter);
        this.canvas.drawBitmap(AndroidGraphicFactory.getBitmap(bitmap), (float)left, (float)top, this.bitmapPaint);
        if (filter != Filter.NONE) {
            this.bitmapPaint.setColorFilter(null);
        }
    }

    public void drawBitmap(Bitmap bitmap, Matrix matrix) {
        this.canvas.drawBitmap(AndroidGraphicFactory.getBitmap(bitmap), AndroidGraphicFactory.getMatrix(matrix), this.bitmapPaint);
    }

    public void drawBitmap(Bitmap bitmap, Matrix matrix, Filter filter) {
        this.applyFilter(filter);
        this.canvas.drawBitmap(AndroidGraphicFactory.getBitmap(bitmap), AndroidGraphicFactory.getMatrix(matrix), this.bitmapPaint);
        if (filter != Filter.NONE) {
            this.bitmapPaint.setColorFilter(null);
        }
    }

    public void drawCircle(int x, int y, int radius, Paint paint) {
        if (paint.isTransparent()) {
            return;
        }
        this.canvas.drawCircle((float)x, (float)y, (float)radius, AndroidGraphicFactory.getPaint(paint));
    }

    public void drawLine(int x1, int y1, int x2, int y2, Paint paint) {
        if (paint.isTransparent()) {
            return;
        }
        this.canvas.drawLine((float)x1, (float)y1, (float)x2, (float)y2, AndroidGraphicFactory.getPaint(paint));
    }

    public void drawPath(org.mapsforge.core.graphics.Path path, Paint paint) {
        if (paint.isTransparent()) {
            return;
        }
        this.canvas.drawPath(AndroidGraphicFactory.getPath(path), AndroidGraphicFactory.getPaint(paint));
    }

    public void drawText(String text, int x, int y, Paint paint) {
        if (text == null || text.trim().isEmpty()) {
            return;
        }
        if (paint.isTransparent()) {
            return;
        }
        this.canvas.drawText(text, (float)x, (float)y, AndroidGraphicFactory.getPaint(paint));
    }

    public void drawTextRotated(String text, int x1, int y1, int x2, int y2, Paint paint) {
        if (text == null || text.trim().isEmpty()) {
            return;
        }
        if (paint.isTransparent()) {
            return;
        }
        Path path = new Path();
        path.moveTo((float)x1, (float)y1);
        path.lineTo((float)x2, (float)y2);
        this.canvas.drawTextOnPath(text, path, 0.0f, 3.0f, AndroidGraphicFactory.getPaint(paint));
    }

    public void fillColor(Color color) {
        this.fillColor(AndroidGraphicFactory.getColor(color));
    }

    public void fillColor(int color) {
        int alpha = color >> 24 & 0xFF;
        this.canvas.drawColor(color, alpha == 0 ? PorterDuff.Mode.CLEAR : PorterDuff.Mode.SRC_OVER);
    }

    public Dimension getDimension() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public int getHeight() {
        return this.canvas.getHeight();
    }

    public int getWidth() {
        return this.canvas.getWidth();
    }

    public void resetClip() {
        this.canvas.clipRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), Region.Op.REPLACE);
    }

    public void setBitmap(Bitmap bitmap) {
        this.canvas.setBitmap(AndroidGraphicFactory.getBitmap(bitmap));
    }

    public void setClip(int left, int top, int width, int height) {
        this.setClipInternal(left, top, width, height, Region.Op.REPLACE);
    }

    public void setClipDifference(int left, int top, int width, int height) {
        this.setClipInternal(left, top, width, height, Region.Op.DIFFERENCE);
    }

    public void setClipInternal(int left, int top, int width, int height, Region.Op op) {
        this.canvas.clipRect((float)left, (float)top, (float)(left + width), (float)(top + height), op);
    }

    public void shadeBitmap(Bitmap bitmap, Rectangle hillRect, Rectangle tileRect, float magnitude) {
        this.shadePaint.setAlpha((int)(255.0f * magnitude));
        Rect atr = new Rect((int)hillRect.left, (int)hillRect.top, (int)hillRect.right, (int)hillRect.bottom);
        Rect asr = new Rect((int)tileRect.left, (int)tileRect.top, (int)tileRect.right, (int)tileRect.bottom);
        this.canvas.drawBitmap(AndroidGraphicFactory.getBitmap(bitmap), atr, asr, this.shadePaint);
    }
}

