/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.android.graphics;

import android.app.Application;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Path;
import android.graphics.Rect;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.Display;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.graphics.Matrix;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Position;
import org.mapsforge.core.graphics.ResourceBitmap;
import org.mapsforge.core.graphics.TileBitmap;
import org.mapsforge.core.mapelements.PointTextContainer;
import org.mapsforge.core.mapelements.SymbolContainer;
import org.mapsforge.core.model.Point;
import org.mapsforge.map.android.graphics.AndroidBitmap;
import org.mapsforge.map.android.graphics.AndroidCanvas;
import org.mapsforge.map.android.graphics.AndroidMatrix;
import org.mapsforge.map.android.graphics.AndroidPaint;
import org.mapsforge.map.android.graphics.AndroidPath;
import org.mapsforge.map.android.graphics.AndroidPointTextContainer;
import org.mapsforge.map.android.graphics.AndroidResourceBitmap;
import org.mapsforge.map.android.graphics.AndroidSvgBitmap;
import org.mapsforge.map.android.graphics.AndroidSvgBitmapStore;
import org.mapsforge.map.android.graphics.AndroidTileBitmap;
import org.mapsforge.map.model.DisplayModel;

public final class AndroidGraphicFactory
implements GraphicFactory {
    public static final boolean DEBUG_BITMAPS = false;
    public static AndroidGraphicFactory INSTANCE = new AndroidGraphicFactory(null);
    public static final boolean KEEP_RESOURCE_BITMAPS = true;
    public static final Bitmap.Config NON_TRANSPARENT_BITMAP = Bitmap.Config.RGB_565;
    public static final Bitmap.Config TRANSPARENT_BITMAP = Bitmap.Config.ARGB_8888;
    public static final Bitmap.Config MONO_ALPHA_BITMAP = Bitmap.Config.ALPHA_8;
    private final Application application;
    private File svgCacheDir;

    public static Bitmap convertToAndroidBitmap(Drawable drawable) {
        Bitmap bitmap;
        if (drawable instanceof BitmapDrawable) {
            bitmap = ((BitmapDrawable)drawable).getBitmap();
        } else {
            int width = drawable.getIntrinsicWidth();
            int height = drawable.getIntrinsicHeight();
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)TRANSPARENT_BITMAP);
            android.graphics.Canvas canvas = new android.graphics.Canvas(bitmap);
            Rect rect = drawable.getBounds();
            drawable.setBounds(0, 0, width, height);
            drawable.draw(canvas);
            drawable.setBounds(rect);
        }
        return bitmap;
    }

    public static org.mapsforge.core.graphics.Bitmap convertToBitmap(Drawable drawable) {
        return new AndroidBitmap(AndroidGraphicFactory.convertToAndroidBitmap(drawable));
    }

    public static org.mapsforge.core.graphics.Bitmap convertToBitmap(Drawable drawable, android.graphics.Paint paint) {
        Bitmap immutable = AndroidGraphicFactory.convertToAndroidBitmap(drawable);
        Bitmap mutable = immutable.copy(TRANSPARENT_BITMAP, true);
        android.graphics.Canvas canvas = new android.graphics.Canvas(mutable);
        canvas.drawBitmap(mutable, 0.0f, 0.0f, paint);
        return new AndroidBitmap(mutable);
    }

    public static Canvas createGraphicContext(android.graphics.Canvas canvas) {
        return new AndroidCanvas(canvas);
    }

    public static void createInstance(Application app) {
        INSTANCE = new AndroidGraphicFactory(app);
    }

    public static int getBytesPerPixel(Bitmap.Config config) {
        if (config == Bitmap.Config.ARGB_8888) {
            return 4;
        }
        if (config == Bitmap.Config.RGB_565) {
            return 2;
        }
        if (config == Bitmap.Config.ARGB_4444) {
            return 2;
        }
        if (config == Bitmap.Config.ALPHA_8) {
            return 1;
        }
        return 1;
    }

    public static android.graphics.Canvas getCanvas(Canvas canvas) {
        return ((AndroidCanvas)canvas).canvas;
    }

    public static android.graphics.Paint getPaint(Paint paint) {
        return ((AndroidPaint)paint).paint;
    }

    public static Bitmap getBitmap(org.mapsforge.core.graphics.Bitmap bitmap) {
        return ((AndroidBitmap)bitmap).bitmap;
    }

    static int getColor(org.mapsforge.core.graphics.Color color) {
        switch (color) {
            case BLACK: {
                return -16777216;
            }
            case BLUE: {
                return -16776961;
            }
            case GREEN: {
                return -16711936;
            }
            case RED: {
                return -65536;
            }
            case TRANSPARENT: {
                return 0;
            }
            case WHITE: {
                return -1;
            }
        }
        throw new IllegalArgumentException("unknown color: " + color);
    }

    static android.graphics.Matrix getMatrix(Matrix matrix) {
        return ((AndroidMatrix)matrix).matrix;
    }

    static Path getPath(org.mapsforge.core.graphics.Path path) {
        return ((AndroidPath)path).path;
    }

    private AndroidGraphicFactory(Application app) {
        this.application = app;
        if (app != null) {
            DisplayModel.setDeviceScaleFactor((float)app.getResources().getDisplayMetrics().scaledDensity);
        }
    }

    public static void clearResourceFileCache() {
        AndroidSvgBitmapStore.clear();
    }

    public static void clearResourceMemoryCache() {
        AndroidResourceBitmap.clearResourceBitmaps();
    }

    public org.mapsforge.core.graphics.Bitmap createBitmap(int width, int height) {
        return new AndroidBitmap(width, height, TRANSPARENT_BITMAP);
    }

    public org.mapsforge.core.graphics.Bitmap createBitmap(int width, int height, boolean isTransparent) {
        if (isTransparent) {
            return new AndroidBitmap(width, height, TRANSPARENT_BITMAP);
        }
        return new AndroidBitmap(width, height, NON_TRANSPARENT_BITMAP);
    }

    public Canvas createCanvas() {
        return new AndroidCanvas();
    }

    public int createColor(org.mapsforge.core.graphics.Color color) {
        return AndroidGraphicFactory.getColor(color);
    }

    public int createColor(int alpha, int red, int green, int blue) {
        return Color.argb((int)alpha, (int)red, (int)green, (int)blue);
    }

    public Matrix createMatrix() {
        return new AndroidMatrix();
    }

    public org.mapsforge.core.graphics.Bitmap createMonoBitmap(int width, int height, byte[] buffer) {
        AndroidBitmap androidBitmap = new AndroidBitmap(width, height, MONO_ALPHA_BITMAP);
        if (buffer != null) {
            ByteBuffer b = ByteBuffer.wrap(buffer);
            androidBitmap.bitmap.copyPixelsFromBuffer((Buffer)b);
        }
        return androidBitmap;
    }

    public Paint createPaint() {
        return new AndroidPaint();
    }

    public Paint createPaint(Paint paint) {
        return new AndroidPaint(paint);
    }

    public org.mapsforge.core.graphics.Path createPath() {
        return new AndroidPath();
    }

    public PointTextContainer createPointTextContainer(Point xy, Display display, int priority, String text, Paint paintFront, Paint paintBack, SymbolContainer symbolContainer, Position position, int maxTextWidth) {
        return new AndroidPointTextContainer(xy, display, priority, text, paintFront, paintBack, symbolContainer, position, maxTextWidth);
    }

    public ResourceBitmap createResourceBitmap(InputStream inputStream, int hash) throws IOException {
        return new AndroidResourceBitmap(inputStream, hash);
    }

    public TileBitmap createTileBitmap(InputStream inputStream, int tileSize, boolean isTransparent) {
        return new AndroidTileBitmap(inputStream, tileSize, isTransparent);
    }

    public TileBitmap createTileBitmap(int tileSize, boolean isTransparent) {
        return new AndroidTileBitmap(tileSize, isTransparent);
    }

    public boolean deleteFile(String name) {
        if (this.svgCacheDir != null) {
            return new File(this.svgCacheDir, name).delete();
        }
        return this.application.deleteFile(name);
    }

    public String[] fileList() {
        if (this.svgCacheDir != null) {
            return this.svgCacheDir.list();
        }
        return this.application.fileList();
    }

    public FileInputStream openFileInput(String name) throws FileNotFoundException {
        if (this.svgCacheDir != null) {
            return new FileInputStream(new File(this.svgCacheDir, name));
        }
        return this.application.openFileInput(name);
    }

    public FileOutputStream openFileOutput(String name, int mode) throws FileNotFoundException {
        if (this.svgCacheDir != null) {
            return new FileOutputStream(new File(this.svgCacheDir, name), mode == 32768);
        }
        return this.application.openFileOutput(name, mode);
    }

    public InputStream platformSpecificSources(String relativePathPrefix, String src) throws IOException {
        String pathName = (TextUtils.isEmpty((CharSequence)relativePathPrefix) ? "" : relativePathPrefix) + src;
        try {
            return this.application.getAssets().open(pathName);
        }
        catch (IOException e) {
            throw new FileNotFoundException("invalid resource: " + pathName);
        }
    }

    public ResourceBitmap renderSvg(InputStream inputStream, float scaleFactor, int width, int height, int percent, int hash) throws IOException {
        return new AndroidSvgBitmap(inputStream, hash, scaleFactor, width, height, percent);
    }

    public void setSvgCacheDir(File svgCacheDir) {
        this.svgCacheDir = svgCacheDir;
    }
}

