/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.android.graphics;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapShader;
import android.graphics.DashPathEffect;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PathEffect;
import android.graphics.Rect;
import android.graphics.Shader;
import android.graphics.Typeface;
import org.mapsforge.core.graphics.Align;
import org.mapsforge.core.graphics.Cap;
import org.mapsforge.core.graphics.Color;
import org.mapsforge.core.graphics.FontFamily;
import org.mapsforge.core.graphics.FontStyle;
import org.mapsforge.core.graphics.Join;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Style;
import org.mapsforge.core.model.Point;
import org.mapsforge.map.android.graphics.AndroidGraphicFactory;

class AndroidPaint
implements Paint {
    final android.graphics.Paint paint;
    private int shaderWidth;
    private int shaderHeight;
    private final Rect rect = new Rect();

    private static Paint.Align getAndroidAlign(Align align) {
        switch (align) {
            case CENTER: {
                return Paint.Align.CENTER;
            }
            case LEFT: {
                return Paint.Align.LEFT;
            }
            case RIGHT: {
                return Paint.Align.RIGHT;
            }
        }
        throw new IllegalArgumentException("unknown align: " + align);
    }

    private static Paint.Cap getAndroidCap(Cap cap) {
        switch (cap) {
            case BUTT: {
                return Paint.Cap.BUTT;
            }
            case ROUND: {
                return Paint.Cap.ROUND;
            }
            case SQUARE: {
                return Paint.Cap.SQUARE;
            }
        }
        throw new IllegalArgumentException("unknown cap: " + cap);
    }

    private static Paint.Join getAndroidJoin(Join join) {
        switch (join) {
            case BEVEL: {
                return Paint.Join.BEVEL;
            }
            case ROUND: {
                return Paint.Join.ROUND;
            }
            case MITER: {
                return Paint.Join.MITER;
            }
        }
        throw new IllegalArgumentException("unknown join: " + join);
    }

    private static Paint.Style getAndroidStyle(Style style) {
        switch (style) {
            case FILL: {
                return Paint.Style.FILL;
            }
            case STROKE: {
                return Paint.Style.STROKE;
            }
        }
        throw new IllegalArgumentException("unknown style: " + style);
    }

    private static int getFontStyle(FontStyle fontStyle) {
        switch (fontStyle) {
            case BOLD: {
                return 1;
            }
            case BOLD_ITALIC: {
                return 3;
            }
            case ITALIC: {
                return 2;
            }
            case NORMAL: {
                return 0;
            }
        }
        throw new IllegalArgumentException("unknown font style: " + fontStyle);
    }

    private static Typeface getTypeface(FontFamily fontFamily) {
        switch (fontFamily) {
            case DEFAULT: {
                return Typeface.DEFAULT;
            }
            case MONOSPACE: {
                return Typeface.MONOSPACE;
            }
            case SANS_SERIF: {
                return Typeface.SANS_SERIF;
            }
            case SERIF: {
                return Typeface.SERIF;
            }
        }
        throw new IllegalArgumentException("unknown font family: " + fontFamily);
    }

    AndroidPaint() {
        this.paint = new android.graphics.Paint();
        this.paint.setAntiAlias(true);
        this.paint.setStrokeCap(AndroidPaint.getAndroidCap(Cap.ROUND));
        this.paint.setStrokeJoin(Paint.Join.ROUND);
        this.paint.setStyle(AndroidPaint.getAndroidStyle(Style.FILL));
    }

    AndroidPaint(Paint paint) {
        this.paint = new android.graphics.Paint(((AndroidPaint)paint).paint);
    }

    public int getColor() {
        return this.paint.getColor();
    }

    public int getTextHeight(String text) {
        this.paint.getTextBounds(text, 0, text.length(), this.rect);
        return this.rect.height();
    }

    public int getTextWidth(String text) {
        return (int)this.paint.measureText(text);
    }

    public boolean isTransparent() {
        return this.paint.getShader() == null && this.paint.getAlpha() == 0;
    }

    @TargetApi(value=11)
    public void setBitmapShader(org.mapsforge.core.graphics.Bitmap bitmap) {
        if (bitmap == null) {
            return;
        }
        Bitmap androidBitmap = AndroidGraphicFactory.getBitmap(bitmap);
        if (androidBitmap == null) {
            return;
        }
        this.shaderWidth = bitmap.getWidth();
        this.shaderHeight = bitmap.getHeight();
        this.paint.setColor(AndroidGraphicFactory.getColor(Color.WHITE));
        this.paint.setShader((Shader)new BitmapShader(androidBitmap, Shader.TileMode.REPEAT, Shader.TileMode.REPEAT));
    }

    public void setBitmapShaderShift(Point origin) {
        Shader shader = this.paint.getShader();
        if (shader != null) {
            int relativeDx = (int)(-origin.x) % this.shaderWidth;
            int relativeDy = (int)(-origin.y) % this.shaderHeight;
            Matrix localMatrix = new Matrix();
            localMatrix.setTranslate((float)relativeDx, (float)relativeDy);
            shader.setLocalMatrix(localMatrix);
        }
    }

    public void setColor(Color color) {
        this.paint.setColor(AndroidGraphicFactory.getColor(color));
    }

    public void setColor(int color) {
        this.paint.setColor(color);
    }

    public void setDashPathEffect(float[] strokeDasharray) {
        DashPathEffect pathEffect = new DashPathEffect(strokeDasharray, 0.0f);
        this.paint.setPathEffect((PathEffect)pathEffect);
    }

    public void setStrokeCap(Cap cap) {
        this.paint.setStrokeCap(AndroidPaint.getAndroidCap(cap));
    }

    public void setStrokeJoin(Join join) {
        this.paint.setStrokeJoin(AndroidPaint.getAndroidJoin(join));
    }

    public void setStrokeWidth(float strokeWidth) {
        this.paint.setStrokeWidth(strokeWidth);
    }

    public void setStyle(Style style) {
        this.paint.setStyle(AndroidPaint.getAndroidStyle(style));
    }

    public void setTextAlign(Align align) {
        this.paint.setTextAlign(AndroidPaint.getAndroidAlign(align));
    }

    public void setTextSize(float textSize) {
        this.paint.setTextSize(textSize);
    }

    public void setTypeface(FontFamily fontFamily, FontStyle fontStyle) {
        this.paint.setTypeface(Typeface.create((Typeface)AndroidPaint.getTypeface(fontFamily), (int)AndroidPaint.getFontStyle(fontStyle)));
    }
}

