/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.android.graphics;

import android.graphics.Paint;
import android.text.Layout;
import android.text.StaticLayout;
import android.text.TextPaint;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.Display;
import org.mapsforge.core.graphics.Filter;
import org.mapsforge.core.graphics.GraphicUtils;
import org.mapsforge.core.graphics.Matrix;
import org.mapsforge.core.graphics.Paint;
import org.mapsforge.core.graphics.Position;
import org.mapsforge.core.mapelements.PointTextContainer;
import org.mapsforge.core.mapelements.SymbolContainer;
import org.mapsforge.core.model.Point;
import org.mapsforge.core.model.Rectangle;
import org.mapsforge.map.android.graphics.AndroidGraphicFactory;

public class AndroidPointTextContainer
extends PointTextContainer {
    private StaticLayout backLayout;
    private StaticLayout frontLayout;

    AndroidPointTextContainer(Point xy, Display display, int priority, String text, Paint paintFront, Paint paintBack, SymbolContainer symbolContainer, Position position, int maxTextWidth) {
        super(xy, display, priority, text, paintFront, paintBack, symbolContainer, position, maxTextWidth);
        float boxHeight;
        float boxWidth;
        if (this.textWidth > this.maxTextWidth) {
            TextPaint frontTextPaint = new TextPaint(AndroidGraphicFactory.getPaint(this.paintFront));
            TextPaint backTextPaint = null;
            if (this.paintBack != null) {
                backTextPaint = new TextPaint(AndroidGraphicFactory.getPaint(this.paintBack));
            }
            Layout.Alignment alignment = Layout.Alignment.ALIGN_CENTER;
            if (Position.LEFT == this.position || Position.BELOW_LEFT == this.position || Position.ABOVE_LEFT == this.position) {
                alignment = Layout.Alignment.ALIGN_OPPOSITE;
            } else if (Position.RIGHT == this.position || Position.BELOW_RIGHT == this.position || Position.ABOVE_RIGHT == this.position) {
                alignment = Layout.Alignment.ALIGN_NORMAL;
            }
            frontTextPaint.setTextAlign(Paint.Align.LEFT);
            if (this.paintBack != null) {
                backTextPaint.setTextAlign(Paint.Align.LEFT);
            }
            this.frontLayout = new StaticLayout((CharSequence)this.text, frontTextPaint, this.maxTextWidth, alignment, 1.0f, 0.0f, false);
            this.backLayout = null;
            if (this.paintBack != null) {
                this.backLayout = new StaticLayout((CharSequence)this.text, backTextPaint, this.maxTextWidth, alignment, 1.0f, 0.0f, false);
            }
            boxWidth = this.frontLayout.getWidth();
            boxHeight = this.frontLayout.getHeight();
        } else {
            boxWidth = this.textWidth;
            boxHeight = this.textHeight;
        }
        switch (this.position) {
            case CENTER: {
                this.boundary = new Rectangle((double)(-boxWidth / 2.0f), (double)(-boxHeight / 2.0f), (double)(boxWidth / 2.0f), (double)(boxHeight / 2.0f));
                break;
            }
            case BELOW: {
                this.boundary = new Rectangle((double)(-boxWidth / 2.0f), 0.0, (double)(boxWidth / 2.0f), (double)boxHeight);
                break;
            }
            case BELOW_LEFT: {
                this.boundary = new Rectangle((double)(-boxWidth), 0.0, 0.0, (double)boxHeight);
                break;
            }
            case BELOW_RIGHT: {
                this.boundary = new Rectangle(0.0, 0.0, (double)boxWidth, (double)boxHeight);
                break;
            }
            case ABOVE: {
                this.boundary = new Rectangle((double)(-boxWidth / 2.0f), (double)(-boxHeight), (double)(boxWidth / 2.0f), 0.0);
                break;
            }
            case ABOVE_LEFT: {
                this.boundary = new Rectangle((double)(-boxWidth), (double)(-boxHeight), 0.0, 0.0);
                break;
            }
            case ABOVE_RIGHT: {
                this.boundary = new Rectangle(0.0, (double)(-boxHeight), (double)boxWidth, 0.0);
                break;
            }
            case LEFT: {
                this.boundary = new Rectangle((double)(-boxWidth), (double)(-boxHeight / 2.0f), 0.0, (double)(boxHeight / 2.0f));
                break;
            }
            case RIGHT: {
                this.boundary = new Rectangle(0.0, (double)(-boxHeight / 2.0f), (double)boxWidth, (double)(boxHeight / 2.0f));
                break;
            }
        }
    }

    public void draw(Canvas canvas, Point origin, Matrix matrix, Filter filter) {
        if (!this.isVisible) {
            return;
        }
        android.graphics.Canvas androidCanvas = AndroidGraphicFactory.getCanvas(canvas);
        if (this.textWidth > this.maxTextWidth) {
            int color;
            androidCanvas.save();
            androidCanvas.translate((float)(this.xy.x - origin.x + this.boundary.left), (float)(this.xy.y - origin.y + this.boundary.top));
            if (this.backLayout != null) {
                color = this.backLayout.getPaint().getColor();
                if (filter != Filter.NONE) {
                    this.backLayout.getPaint().setColor(GraphicUtils.filterColor((int)color, (Filter)filter));
                }
                this.backLayout.draw(androidCanvas);
                if (filter != Filter.NONE) {
                    this.backLayout.getPaint().setColor(color);
                }
            }
            color = this.frontLayout.getPaint().getColor();
            if (filter != Filter.NONE) {
                this.frontLayout.getPaint().setColor(GraphicUtils.filterColor((int)color, (Filter)filter));
            }
            this.frontLayout.draw(androidCanvas);
            if (filter != Filter.NONE) {
                this.frontLayout.getPaint().setColor(color);
            }
            androidCanvas.restore();
        } else {
            int color;
            float textOffset = 0.0f;
            switch (this.position) {
                case CENTER: 
                case LEFT: 
                case RIGHT: {
                    textOffset = (float)this.textHeight / 2.0f;
                    break;
                }
                case BELOW: 
                case BELOW_LEFT: 
                case BELOW_RIGHT: {
                    textOffset = this.textHeight;
                    break;
                }
            }
            float adjustedX = (float)(this.xy.x - origin.x);
            float adjustedY = (float)(this.xy.y - origin.y) + textOffset;
            if (this.paintBack != null) {
                color = this.paintBack.getColor();
                if (filter != Filter.NONE) {
                    this.paintBack.setColor(GraphicUtils.filterColor((int)color, (Filter)filter));
                }
                androidCanvas.drawText(this.text, adjustedX, adjustedY, AndroidGraphicFactory.getPaint(this.paintBack));
                if (filter != Filter.NONE) {
                    this.paintBack.setColor(color);
                }
            }
            color = this.paintFront.getColor();
            if (filter != Filter.NONE) {
                this.paintFront.setColor(GraphicUtils.filterColor((int)color, (Filter)filter));
            }
            androidCanvas.drawText(this.text, adjustedX, adjustedY, AndroidGraphicFactory.getPaint(this.paintFront));
            if (filter != Filter.NONE) {
                this.paintFront.setColor(color);
            }
        }
    }
}

