/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.android.graphics;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.util.Pair;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.mapsforge.core.graphics.ResourceBitmap;
import org.mapsforge.map.android.graphics.AndroidBitmap;
import org.mapsforge.map.android.graphics.AndroidGraphicFactory;

public class AndroidResourceBitmap
extends AndroidBitmap
implements ResourceBitmap {
    protected static final Logger LOGGER = Logger.getLogger(AndroidResourceBitmap.class.getName());
    protected static Set<Integer> rBitmaps;
    protected static final Map<Integer, Pair<Bitmap, Integer>> RESOURCE_BITMAPS;
    protected static AtomicInteger rInstances;
    private final int hash;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearResourceBitmaps() {
        Map<Integer, Pair<Bitmap, Integer>> map = RESOURCE_BITMAPS;
        synchronized (map) {
            for (Pair<Bitmap, Integer> p : RESOURCE_BITMAPS.values()) {
                ((Bitmap)p.first).recycle();
            }
            RESOURCE_BITMAPS.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap getResourceBitmap(InputStream inputStream, int hash) throws IOException {
        Map<Integer, Pair<Bitmap, Integer>> map = RESOURCE_BITMAPS;
        synchronized (map) {
            Pair<Bitmap, Integer> data = RESOURCE_BITMAPS.get(hash);
            if (data != null) {
                Pair updated = new Pair(data.first, (Object)((Integer)data.second + 1));
                RESOURCE_BITMAPS.put(hash, (Pair<Bitmap, Integer>)updated);
                return (Bitmap)data.first;
            }
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)AndroidResourceBitmap.createBitmapFactoryOptions(AndroidGraphicFactory.TRANSPARENT_BITMAP));
            if (bitmap == null) {
                throw new IOException("BitmapFactory failed to decodeStream");
            }
            Pair updated = new Pair((Object)bitmap, (Object)1);
            RESOURCE_BITMAPS.put(hash, (Pair<Bitmap, Integer>)updated);
            return bitmap;
        }
    }

    private static boolean removeBitmap(int hash) {
        return false;
    }

    protected AndroidResourceBitmap(int hash) {
        this.hash = hash;
    }

    AndroidResourceBitmap(InputStream inputStream, int hash) throws IOException {
        this(hash);
        this.bitmap = AndroidResourceBitmap.getResourceBitmap(inputStream, hash);
    }

    @Override
    protected void destroyBitmap() {
        if (this.bitmap != null) {
            if (AndroidResourceBitmap.removeBitmap(this.hash)) {
                this.bitmap.recycle();
            }
            this.bitmap = null;
        }
    }

    static {
        RESOURCE_BITMAPS = new HashMap<Integer, Pair<Bitmap, Integer>>();
    }
}

