/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.android.graphics;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Picture;
import android.graphics.RectF;
import android.util.Pair;
import com.caverock.androidsvg.SVG;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.mapsforge.map.android.graphics.AndroidGraphicFactory;
import org.mapsforge.map.android.graphics.AndroidResourceBitmap;
import org.mapsforge.map.android.graphics.AndroidSvgBitmapStore;

public class AndroidSvgBitmap
extends AndroidResourceBitmap {
    public static float DEFAULT_SIZE = 400.0f;

    public static Bitmap getResourceBitmap(InputStream inputStream, float scaleFactor, float defaultSize, int width, int height, int percent) throws IOException {
        try {
            SVG svg = SVG.getFromInputStream((InputStream)inputStream);
            Picture picture = svg.renderToPicture();
            double scale = (double)scaleFactor / Math.sqrt((float)(picture.getHeight() * picture.getWidth()) / defaultSize);
            float bitmapWidth = (float)((double)picture.getWidth() * scale);
            float bitmapHeight = (float)((double)picture.getHeight() * scale);
            float aspectRatio = 1.0f * (float)picture.getWidth() / (float)picture.getHeight();
            if (width != 0 && height != 0) {
                bitmapWidth = width;
                bitmapHeight = height;
            } else if (width == 0 && height != 0) {
                bitmapWidth = (float)height * aspectRatio;
                bitmapHeight = height;
            } else if (width != 0 && height == 0) {
                bitmapHeight = (float)width / aspectRatio;
                bitmapWidth = width;
            }
            if (percent != 100) {
                bitmapWidth *= (float)percent / 100.0f;
                bitmapHeight *= (float)percent / 100.0f;
            }
            Bitmap bitmap = Bitmap.createBitmap((int)((int)Math.ceil(bitmapWidth)), (int)((int)Math.ceil(bitmapHeight)), (Bitmap.Config)AndroidGraphicFactory.TRANSPARENT_BITMAP);
            Canvas canvas = new Canvas(bitmap);
            canvas.drawPicture(picture, new RectF(0.0f, 0.0f, bitmapWidth, bitmapHeight));
            return bitmap;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap getResourceBitmapImpl(InputStream inputStream, int hash, float scaleFactor, int width, int height, int percent) throws IOException {
        Map map = RESOURCE_BITMAPS;
        synchronized (map) {
            Pair data = (Pair)RESOURCE_BITMAPS.get(hash);
            if (data != null) {
                Pair updated = new Pair(data.first, (Object)((Integer)data.second + 1));
                RESOURCE_BITMAPS.put(hash, updated);
                return (Bitmap)data.first;
            }
            Bitmap bitmap = AndroidSvgBitmapStore.get(hash);
            if (bitmap == null) {
                bitmap = AndroidSvgBitmap.getResourceBitmap(inputStream, scaleFactor, DEFAULT_SIZE, width, height, percent);
                AndroidSvgBitmapStore.put(hash, bitmap);
            }
            Pair updated = new Pair((Object)bitmap, (Object)1);
            RESOURCE_BITMAPS.put(hash, updated);
            return bitmap;
        }
    }

    public AndroidSvgBitmap(InputStream inputStream, int hash, float scaleFactor, int width, int height, int percent) throws IOException {
        super(hash);
        this.bitmap = AndroidSvgBitmap.getResourceBitmapImpl(inputStream, hash, scaleFactor, width, height, percent);
    }
}

