/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.android.graphics;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import java.io.Closeable;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.mapsforge.core.util.IOUtils;
import org.mapsforge.map.android.graphics.AndroidGraphicFactory;

public class AndroidSvgBitmapStore {
    private static final Logger LOGGER = Logger.getLogger(AndroidSvgBitmapStore.class.getName());
    private static final String SVG_PREFIX = "svg-";
    private static final String SVG_SUFFIX = ".png";

    public static void clear() {
        String[] files;
        for (String file : files = AndroidGraphicFactory.INSTANCE.fileList()) {
            if (!file.startsWith(SVG_PREFIX) || !file.endsWith(SVG_SUFFIX)) continue;
            AndroidGraphicFactory.INSTANCE.deleteFile(file);
        }
    }

    private static String createFileName(int hash) {
        StringBuilder sb = new StringBuilder().append(SVG_PREFIX).append(hash).append(SVG_SUFFIX);
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Bitmap get(int hash) {
        String fileName = AndroidSvgBitmapStore.createFileName(hash);
        FileInputStream inputStream = null;
        try {
            inputStream = AndroidGraphicFactory.INSTANCE.openFileInput(fileName);
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)inputStream);
            return bitmap;
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        finally {
            IOUtils.closeQuietly((Closeable)inputStream);
        }
        return null;
    }

    public static void put(int hash, Bitmap bitmap) {
        new Thread(new SvgStorer(hash, bitmap)).start();
    }

    private AndroidSvgBitmapStore() {
    }

    private static class SvgStorer
    implements Runnable {
        private Bitmap bitmap;
        private int hash;

        public SvgStorer(int hash, Bitmap bitmap) {
            this.hash = hash;
            this.bitmap = bitmap;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        @Override
        public void run() {
            FileOutputStream outputStream;
            block6: {
                String fileName = AndroidSvgBitmapStore.createFileName(this.hash);
                outputStream = null;
                try {
                    outputStream = AndroidGraphicFactory.INSTANCE.openFileOutput(fileName, 0);
                    if (this.bitmap.compress(Bitmap.CompressFormat.PNG, 0, (OutputStream)outputStream)) break block6;
                    LOGGER.warning("SVG Failed to write svg bitmap " + fileName);
                }
                catch (IllegalStateException e) {
                    LOGGER.warning("SVG Failed to stream bitmap to file " + fileName);
                    IOUtils.closeQuietly((Closeable)outputStream);
                }
                catch (FileNotFoundException e2) {
                    LOGGER.warning("SVG Failed to create file for svg bitmap " + fileName);
                    {
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(outputStream);
                            throw throwable;
                        }
                    }
                    IOUtils.closeQuietly((Closeable)outputStream);
                }
            }
            IOUtils.closeQuietly((Closeable)outputStream);
        }
    }
}

