/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.android.graphics;

import android.annotation.TargetApi;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Build;
import java.io.Closeable;
import java.io.InputStream;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;
import org.mapsforge.core.graphics.CorruptedInputStreamException;
import org.mapsforge.core.graphics.TileBitmap;
import org.mapsforge.core.util.IOUtils;
import org.mapsforge.map.android.graphics.AndroidBitmap;
import org.mapsforge.map.android.graphics.AndroidGraphicFactory;

public class AndroidTileBitmap
extends AndroidBitmap
implements TileBitmap {
    private static final Logger LOGGER = Logger.getLogger(AndroidTileBitmap.class.getName());
    private static Map<Integer, Set<SoftReference<Bitmap>>> reusableTileBitmaps = new HashMap<Integer, Set<SoftReference<Bitmap>>>();
    private static AtomicInteger tileInstances;
    private long expiration = 0L;
    private long timestamp = System.currentTimeMillis();

    private static int composeHash(int tileSize, boolean isTransparent) {
        if (isTransparent) {
            return tileSize + 0x10000000;
        }
        return tileSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Bitmap getTileBitmapFromReusableSet(int tileSize, boolean isTransparent) {
        int hash = AndroidTileBitmap.composeHash(tileSize, isTransparent);
        Map<Integer, Set<SoftReference<Bitmap>>> map = reusableTileBitmaps;
        synchronized (map) {
            Set<SoftReference<Bitmap>> subSet = reusableTileBitmaps.get(hash);
            if (subSet == null) {
                return null;
            }
            Bitmap bitmap = null;
            Iterator<SoftReference<Bitmap>> iterator = subSet.iterator();
            while (iterator.hasNext()) {
                Bitmap candidate = iterator.next().get();
                if (null != candidate && candidate.isMutable()) {
                    bitmap = candidate;
                    if (isTransparent) {
                        bitmap.eraseColor(0);
                    }
                    iterator.remove();
                    break;
                }
                iterator.remove();
            }
            return bitmap;
        }
    }

    AndroidTileBitmap(InputStream inputStream, int tileSize, boolean isTransparent) {
        try {
            this.bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)this.createTileBitmapFactoryOptions(tileSize, isTransparent));
            this.bitmap.getWidth();
        }
        catch (Exception e) {
            LOGGER.info("TILEBITMAP ERROR " + e.toString());
            this.bitmap = null;
            IOUtils.closeQuietly((Closeable)inputStream);
            this.destroy();
            throw new CorruptedInputStreamException("Corrupted bitmap input stream", (Throwable)e);
        }
    }

    @TargetApi(value=11)
    AndroidTileBitmap(int tileSize, boolean isTransparent) {
        if (Build.VERSION.SDK_INT >= 11) {
            this.bitmap = AndroidTileBitmap.getTileBitmapFromReusableSet(tileSize, isTransparent);
        }
        if (this.bitmap == null) {
            Bitmap.Config config = isTransparent ? AndroidGraphicFactory.TRANSPARENT_BITMAP : AndroidGraphicFactory.NON_TRANSPARENT_BITMAP;
            this.bitmap = AndroidBitmap.createAndroidBitmap(tileSize, tileSize, config);
        }
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public boolean isExpired() {
        if (this.expiration == 0L) {
            return false;
        }
        return this.expiration <= System.currentTimeMillis();
    }

    public void setExpiration(long expiration) {
        this.expiration = expiration;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    protected void destroy() {
        super.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @TargetApi(value=11)
    protected void destroyBitmap() {
        if (this.bitmap != null) {
            if (Build.VERSION.SDK_INT >= 11) {
                int tileSize = this.getHeight();
                Map<Integer, Set<SoftReference<Bitmap>>> map = reusableTileBitmaps;
                synchronized (map) {
                    int hash = AndroidTileBitmap.composeHash(tileSize, this.bitmap.hasAlpha());
                    if (!reusableTileBitmaps.containsKey(hash)) {
                        reusableTileBitmaps.put(hash, new HashSet());
                    }
                    Set<SoftReference<Bitmap>> sizeSpecificSet = reusableTileBitmaps.get(hash);
                    sizeSpecificSet.add(new SoftReference<Bitmap>(this.bitmap));
                }
            } else {
                this.bitmap.recycle();
            }
            this.bitmap = null;
        }
    }

    @TargetApi(value=11)
    private BitmapFactory.Options createTileBitmapFactoryOptions(int tileSize, boolean isTransparent) {
        Bitmap reusableBitmap;
        BitmapFactory.Options bitmapFactoryOptions = new BitmapFactory.Options();
        bitmapFactoryOptions.inPreferredConfig = isTransparent ? AndroidGraphicFactory.TRANSPARENT_BITMAP : AndroidGraphicFactory.NON_TRANSPARENT_BITMAP;
        if (Build.VERSION.SDK_INT >= 11 && (reusableBitmap = AndroidTileBitmap.getTileBitmapFromReusableSet(tileSize, isTransparent)) != null) {
            bitmapFactoryOptions.inMutable = true;
            bitmapFactoryOptions.inSampleSize = 1;
            bitmapFactoryOptions.inBitmap = AndroidTileBitmap.getTileBitmapFromReusableSet(tileSize, isTransparent);
        }
        return bitmapFactoryOptions;
    }
}

