/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.android.input;

import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewConfiguration;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.LinearLayout;
import android.widget.ZoomButton;
import android.widget.ZoomControls;
import org.mapsforge.map.android.util.AndroidUtil;
import org.mapsforge.map.android.view.MapView;
import org.mapsforge.map.model.common.Observer;

public class MapZoomControls
extends LinearLayout
implements Observer {
    private static final int DEFAULT_ZOOM_CONTROLS_GRAVITY = 85;
    private static final byte DEFAULT_ZOOM_LEVEL_MAX = 22;
    private static final byte DEFAULT_ZOOM_LEVEL_MIN = 0;
    private static final long DEFAULT_ZOOM_SPEED = 500L;
    private static final int MSG_ZOOM_CONTROLS_HIDE = 0;
    private static final int DEFAULT_HORIZONTAL_MARGIN = 5;
    private static final int DEFAULT_VERTICAL_MARGIN = 0;
    private static final long ZOOM_CONTROLS_TIMEOUT = ViewConfiguration.getZoomControlsTimeout();
    private boolean autoHide;
    private final ZoomButton buttonZoomIn;
    private final ZoomButton buttonZoomOut;
    private final MapView mapView;
    private boolean showMapZoomControls;
    private int zoomControlsGravity;
    private final Handler zoomControlsHideHandler;
    private byte zoomLevelMax;
    private byte zoomLevelMin;

    public MapZoomControls(Context context, MapView mapView) {
        super(context);
        this.mapView = mapView;
        this.autoHide = true;
        this.setMarginHorizontal(5);
        this.setMarginVertical(0);
        this.showMapZoomControls = true;
        this.zoomLevelMax = (byte)22;
        this.zoomLevelMin = 0;
        this.setVisibility(8);
        this.zoomControlsGravity = 85;
        this.zoomControlsHideHandler = new Handler(){

            public void handleMessage(Message message) {
                MapZoomControls.this.hide();
            }
        };
        ZoomControls defaultZoomControls = new ZoomControls(context);
        this.buttonZoomIn = (ZoomButton)defaultZoomControls.getChildAt(1);
        this.buttonZoomOut = (ZoomButton)defaultZoomControls.getChildAt(0);
        defaultZoomControls.removeAllViews();
        this.setOrientation(defaultZoomControls.getOrientation());
        this.setZoomInFirst(false);
        this.setZoomSpeed(500L);
        this.buttonZoomIn.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ((MapZoomControls)MapZoomControls.this).mapView.getModel().mapViewPosition.zoomIn();
            }
        });
        this.buttonZoomOut.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                ((MapZoomControls)MapZoomControls.this).mapView.getModel().mapViewPosition.zoomOut();
            }
        });
        this.mapView.getModel().mapViewPosition.addObserver((Observer)this);
    }

    private void changeZoomControls(int newZoomLevel) {
        this.buttonZoomIn.setEnabled(newZoomLevel < this.zoomLevelMax);
        this.buttonZoomOut.setEnabled(newZoomLevel > this.zoomLevelMin);
    }

    public void destroy() {
        this.mapView.getModel().mapViewPosition.removeObserver((Observer)this);
    }

    private void fade(int visibility, float startAlpha, float endAlpha) {
        AlphaAnimation anim = new AlphaAnimation(startAlpha, endAlpha);
        anim.setDuration(500L);
        this.startAnimation((Animation)anim);
        this.setVisibility(visibility);
    }

    public int getZoomControlsGravity() {
        return this.zoomControlsGravity;
    }

    public byte getZoomLevelMax() {
        return this.zoomLevelMax;
    }

    public byte getZoomLevelMin() {
        return this.zoomLevelMin;
    }

    public void hide() {
        this.fade(8, 1.0f, 0.0f);
    }

    public boolean isAutoHide() {
        return this.autoHide;
    }

    public boolean isShowMapZoomControls() {
        return this.showMapZoomControls;
    }

    public void onChange() {
        this.onZoomLevelChange(this.mapView.getModel().mapViewPosition.getZoomLevel());
    }

    public void onMapViewTouchEvent(MotionEvent event) {
        if (event.getPointerCount() > 1) {
            return;
        }
        if (this.showMapZoomControls && this.autoHide) {
            switch (event.getAction()) {
                case 0: {
                    this.showZoomControls();
                    break;
                }
                case 3: {
                    this.showZoomControlsWithTimeout();
                    break;
                }
                case 1: {
                    this.showZoomControlsWithTimeout();
                }
            }
        }
    }

    public void onZoomLevelChange(final int newZoomLevel) {
        if (AndroidUtil.currentThreadIsUiThread()) {
            this.changeZoomControls(newZoomLevel);
        } else {
            this.mapView.post(new Runnable(){

                @Override
                public void run() {
                    MapZoomControls.this.changeZoomControls(newZoomLevel);
                }
            });
        }
    }

    public void setAutoHide(boolean autoHide) {
        this.autoHide = autoHide;
        if (!this.autoHide) {
            this.showZoomControls();
        }
    }

    public void setMarginHorizontal(int marginHorizontal) {
        this.setPadding(marginHorizontal, this.getPaddingTop(), marginHorizontal, this.getPaddingBottom());
        this.mapView.requestLayout();
    }

    public void setMarginVertical(int marginVertical) {
        this.setPadding(this.getPaddingLeft(), marginVertical, this.getPaddingRight(), marginVertical);
        this.mapView.requestLayout();
    }

    public void setShowMapZoomControls(boolean showMapZoomControls) {
        this.showMapZoomControls = showMapZoomControls;
    }

    public void setZoomControlsGravity(int zoomControlsGravity) {
        this.zoomControlsGravity = zoomControlsGravity;
        this.mapView.requestLayout();
    }

    public void setZoomControlsOrientation(Orientation orientation) {
        this.setOrientation(orientation.layoutOrientation);
        this.setZoomInFirst(orientation.zoomInFirst);
    }

    public void setZoomInFirst(boolean zoomInFirst) {
        this.removeAllViews();
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-2, -2);
        if (zoomInFirst) {
            this.addView((View)this.buttonZoomIn, (ViewGroup.LayoutParams)layoutParams);
            this.addView((View)this.buttonZoomOut, (ViewGroup.LayoutParams)layoutParams);
        } else {
            this.addView((View)this.buttonZoomOut, (ViewGroup.LayoutParams)layoutParams);
            this.addView((View)this.buttonZoomIn, (ViewGroup.LayoutParams)layoutParams);
        }
    }

    public void setZoomInResource(int resId) {
        this.buttonZoomIn.setBackgroundResource(resId);
    }

    public void setZoomLevelMax(byte zoomLevelMax) {
        if (zoomLevelMax < this.zoomLevelMin) {
            throw new IllegalArgumentException();
        }
        this.zoomLevelMax = zoomLevelMax;
    }

    public void setZoomLevelMin(byte zoomLevelMin) {
        if (zoomLevelMin > this.zoomLevelMax) {
            throw new IllegalArgumentException();
        }
        this.zoomLevelMin = zoomLevelMin;
    }

    public void setZoomOutResource(int resId) {
        this.buttonZoomOut.setBackgroundResource(resId);
    }

    public void setZoomSpeed(long ms) {
        this.buttonZoomIn.setZoomSpeed(ms);
        this.buttonZoomOut.setZoomSpeed(ms);
    }

    public void show() {
        this.fade(0, 0.0f, 1.0f);
    }

    private void showZoomControls() {
        this.zoomControlsHideHandler.removeMessages(0);
        if (this.getVisibility() != 0) {
            this.show();
        }
    }

    private void showZoomControlsWithTimeout() {
        this.showZoomControls();
        this.zoomControlsHideHandler.sendEmptyMessageDelayed(0, ZOOM_CONTROLS_TIMEOUT);
    }

    public static enum Orientation {
        HORIZONTAL_IN_OUT(0, true),
        HORIZONTAL_OUT_IN(0, false),
        VERTICAL_IN_OUT(1, true),
        VERTICAL_OUT_IN(1, false);

        public final int layoutOrientation;
        public final boolean zoomInFirst;

        private Orientation(int layoutOrientation, boolean zoomInFirst) {
            this.layoutOrientation = layoutOrientation;
            this.zoomInFirst = zoomInFirst;
        }
    }
}

