/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.android.input;

import android.os.Handler;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.widget.Scroller;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.Point;
import org.mapsforge.map.android.view.MapView;
import org.mapsforge.map.layer.Layer;
import org.mapsforge.map.model.MapViewPosition;

public class TouchGestureHandler
extends GestureDetector.SimpleOnGestureListener
implements ScaleGestureDetector.OnScaleGestureListener,
Runnable {
    private final Scroller flinger;
    private int flingLastX;
    private int flingLastY;
    private float focusX;
    private float focusY;
    private final Handler handler = new Handler();
    private boolean isInDoubleTap;
    private boolean isInScale;
    private final MapView mapView;
    private LatLong pivot;
    private boolean scaleEnabled = true;
    private float scaleFactorCumulative;

    public TouchGestureHandler(MapView mapView) {
        this.mapView = mapView;
        this.flinger = new Scroller(mapView.getContext());
    }

    public void destroy() {
        this.handler.removeCallbacksAndMessages(null);
    }

    public boolean isScaleEnabled() {
        return this.scaleEnabled;
    }

    public boolean onDoubleTapEvent(MotionEvent e) {
        int action = e.getActionMasked();
        switch (action) {
            case 0: {
                this.isInDoubleTap = true;
                break;
            }
            case 1: {
                if (!this.isInDoubleTap) break;
                MapViewPosition mapViewPosition = this.mapView.getModel().mapViewPosition;
                if (mapViewPosition.getZoomLevel() < mapViewPosition.getZoomLevelMax()) {
                    Point center = this.mapView.getModel().mapViewDimension.getDimension().getCenter();
                    byte zoomLevelDiff = 1;
                    double moveHorizontal = (center.x - (double)e.getX()) / Math.pow(2.0, zoomLevelDiff);
                    double moveVertical = (center.y - (double)e.getY()) / Math.pow(2.0, zoomLevelDiff);
                    LatLong pivot = this.mapView.getMapViewProjection().fromPixels((double)e.getX(), (double)e.getY());
                    if (pivot != null) {
                        mapViewPosition.setPivot(pivot);
                        mapViewPosition.moveCenterAndZoom(moveHorizontal, moveVertical, zoomLevelDiff);
                    }
                }
                this.isInDoubleTap = false;
                return true;
            }
        }
        return false;
    }

    public boolean onDown(MotionEvent e) {
        this.isInScale = false;
        this.flinger.forceFinished(true);
        return true;
    }

    public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        if (!this.isInScale && e1.getPointerCount() == 1 && e2.getPointerCount() == 1) {
            this.flinger.fling(0, 0, (int)(-velocityX), (int)(-velocityY), Integer.MIN_VALUE, Integer.MAX_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
            this.flingLastY = 0;
            this.flingLastX = 0;
            this.handler.removeCallbacksAndMessages(null);
            this.handler.post((Runnable)this);
            return true;
        }
        return false;
    }

    public void onLongPress(MotionEvent e) {
        if (!this.isInScale && !this.isInDoubleTap) {
            Point tapXY = new Point((double)e.getX(), (double)e.getY());
            LatLong tapLatLong = this.mapView.getMapViewProjection().fromPixels(tapXY.x, tapXY.y);
            if (tapLatLong != null) {
                Point layerXY;
                Layer layer;
                for (int i = this.mapView.getLayerManager().getLayers().size() - 1; i >= 0 && !(layer = this.mapView.getLayerManager().getLayers().get(i)).onLongPress(tapLatLong, layerXY = this.mapView.getMapViewProjection().toPixels(layer.getPosition()), tapXY); --i) {
                }
            }
        }
    }

    public boolean onScale(ScaleGestureDetector detector) {
        this.scaleFactorCumulative *= detector.getScaleFactor();
        this.mapView.getModel().mapViewPosition.setPivot(this.pivot);
        this.mapView.getModel().mapViewPosition.setScaleFactorAdjustment((double)this.scaleFactorCumulative);
        return true;
    }

    public boolean onScaleBegin(ScaleGestureDetector detector) {
        if (!this.scaleEnabled) {
            return false;
        }
        this.isInScale = true;
        this.scaleFactorCumulative = 1.0f;
        if (this.isInDoubleTap) {
            this.pivot = null;
        } else {
            this.focusX = detector.getFocusX();
            this.focusY = detector.getFocusY();
            this.pivot = this.mapView.getMapViewProjection().fromPixels((double)this.focusX, (double)this.focusY);
        }
        return true;
    }

    public void onScaleEnd(ScaleGestureDetector detector) {
        double zoomLevelOffset = Math.log(this.scaleFactorCumulative) / Math.log(2.0);
        int zoomLevelDiff = Math.abs(zoomLevelOffset) > 1.0 ? (int)((int)Math.round(zoomLevelOffset < 0.0 ? Math.floor(zoomLevelOffset) : Math.ceil(zoomLevelOffset))) : (int)((int)Math.round(zoomLevelOffset));
        MapViewPosition mapViewPosition = this.mapView.getModel().mapViewPosition;
        if (zoomLevelDiff != 0 && this.pivot != null) {
            double moveHorizontal = 0.0;
            double moveVertical = 0.0;
            Point center = this.mapView.getModel().mapViewDimension.getDimension().getCenter();
            if (zoomLevelDiff > 0) {
                for (int i = 1; i <= zoomLevelDiff && mapViewPosition.getZoomLevel() + i <= mapViewPosition.getZoomLevelMax(); ++i) {
                    moveHorizontal += (center.x - (double)this.focusX) / Math.pow(2.0, i);
                    moveVertical += (center.y - (double)this.focusY) / Math.pow(2.0, i);
                }
            } else {
                for (int i = -1; i >= zoomLevelDiff && mapViewPosition.getZoomLevel() + i >= mapViewPosition.getZoomLevelMin(); --i) {
                    moveHorizontal -= (center.x - (double)this.focusX) / Math.pow(2.0, i + 1);
                    moveVertical -= (center.y - (double)this.focusY) / Math.pow(2.0, i + 1);
                }
            }
            mapViewPosition.setPivot(this.pivot);
            mapViewPosition.moveCenterAndZoom(moveHorizontal, moveVertical, (byte)zoomLevelDiff);
        } else {
            mapViewPosition.zoom((byte)zoomLevelDiff);
        }
        this.isInDoubleTap = false;
    }

    public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
        if (!this.isInScale && e1.getPointerCount() == 1 && e2.getPointerCount() == 1) {
            this.mapView.getModel().mapViewPosition.moveCenter((double)(-distanceX), (double)(-distanceY), false);
            return true;
        }
        return false;
    }

    public boolean onSingleTapConfirmed(MotionEvent e) {
        Point tapXY = new Point((double)e.getX(), (double)e.getY());
        LatLong tapLatLong = this.mapView.getMapViewProjection().fromPixels(tapXY.x, tapXY.y);
        if (tapLatLong != null) {
            for (int i = this.mapView.getLayerManager().getLayers().size() - 1; i >= 0; --i) {
                Point layerXY;
                Layer layer = this.mapView.getLayerManager().getLayers().get(i);
                if (!layer.onTap(tapLatLong, layerXY = this.mapView.getMapViewProjection().toPixels(layer.getPosition()), tapXY)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void run() {
        boolean flingerRunning = !this.flinger.isFinished() && this.flinger.computeScrollOffset();
        this.mapView.getModel().mapViewPosition.moveCenter((double)(this.flingLastX - this.flinger.getCurrX()), (double)(this.flingLastY - this.flinger.getCurrY()));
        this.flingLastX = this.flinger.getCurrX();
        this.flingLastY = this.flinger.getCurrY();
        if (flingerRunning) {
            this.handler.post((Runnable)this);
        }
    }

    public void setScaleEnabled(boolean scaleEnabled) {
        this.scaleEnabled = scaleEnabled;
    }
}

