/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.android.rendertheme;

import android.content.Context;
import android.text.TextUtils;
import java.io.IOException;
import java.io.InputStream;
import org.mapsforge.core.util.Utils;
import org.mapsforge.map.rendertheme.XmlRenderTheme;
import org.mapsforge.map.rendertheme.XmlRenderThemeMenuCallback;

public class AssetsRenderTheme
implements XmlRenderTheme {
    private final String assetName;
    private final InputStream inputStream;
    private final XmlRenderThemeMenuCallback menuCallback;
    private final String relativePathPrefix;

    public AssetsRenderTheme(Context context, String relativePathPrefix, String fileName) throws IOException {
        this(context, relativePathPrefix, fileName, null);
    }

    public AssetsRenderTheme(Context context, String relativePathPrefix, String fileName, XmlRenderThemeMenuCallback menuCallback) throws IOException {
        this.assetName = fileName;
        this.relativePathPrefix = relativePathPrefix;
        this.inputStream = context.getAssets().open((TextUtils.isEmpty((CharSequence)this.relativePathPrefix) ? "" : this.relativePathPrefix) + this.assetName);
        this.menuCallback = menuCallback;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AssetsRenderTheme)) {
            return false;
        }
        AssetsRenderTheme other = (AssetsRenderTheme)obj;
        if (!Utils.equals((Object)this.assetName, (Object)other.assetName)) {
            return false;
        }
        return Utils.equals((Object)this.relativePathPrefix, (Object)other.relativePathPrefix);
    }

    public XmlRenderThemeMenuCallback getMenuCallback() {
        return this.menuCallback;
    }

    public String getRelativePathPrefix() {
        return this.relativePathPrefix;
    }

    public InputStream getRenderThemeAsStream() {
        return this.inputStream;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.assetName == null ? 0 : this.assetName.hashCode());
        result = 31 * result + (this.relativePathPrefix == null ? 0 : this.relativePathPrefix.hashCode());
        return result;
    }
}

