/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.android.rotation;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.os.Build;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import org.mapsforge.map.android.rotation.SmoothCanvas;

public class RotateView
extends ViewGroup {
    private float heading = 0.0f;
    private final Matrix matrix = new Matrix();
    private final float[] points = new float[2];
    private final SmoothCanvas smoothCanvas = new SmoothCanvas();

    public RotateView(Context context) {
        this(context, null);
    }

    public RotateView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
    }

    protected void dispatchDraw(Canvas canvas) {
        if (this.heading == 0.0f) {
            super.dispatchDraw(canvas);
            return;
        }
        canvas.save(1);
        canvas.rotate(-this.heading, (float)this.getWidth() * 0.5f, (float)this.getHeight() * 0.5f);
        this.smoothCanvas.delegate = canvas;
        super.dispatchDraw((Canvas)this.smoothCanvas);
        canvas.restore();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean dispatchTouchEvent(MotionEvent event) {
        if (this.heading == 0.0f) {
            return super.dispatchTouchEvent(event);
        }
        MotionEvent rotatedEvent = this.rotateEvent(event, this.heading, (float)this.getWidth() * 0.5f, (float)this.getHeight() * 0.5f);
        try {
            boolean bl = super.dispatchTouchEvent(rotatedEvent);
            return bl;
        }
        finally {
            if (rotatedEvent != event) {
                rotatedEvent.recycle();
            }
        }
    }

    public float getHeading() {
        return this.heading;
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int width = this.getWidth();
        int height = this.getHeight();
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View view = this.getChildAt(i);
            int childWidth = view.getMeasuredWidth();
            int childHeight = view.getMeasuredHeight();
            int childLeft = (width - childWidth) / 2;
            int childTop = (height - childHeight) / 2;
            view.layout(childLeft, childTop, childLeft + childWidth, childTop + childHeight);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int w = RotateView.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec);
        int h = RotateView.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec);
        int sizeSpec = View.MeasureSpec.makeMeasureSpec((int)((int)Math.hypot(w, h)), (int)0x40000000);
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            this.getChildAt(i).measure(sizeSpec, sizeSpec);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    private MotionEvent rotateEvent(MotionEvent event, float degrees, float px, float py) {
        MotionEvent rotatedEvent;
        if (degrees == 0.0f) {
            return event;
        }
        this.matrix.setRotate(degrees, px, py);
        if (Build.VERSION.SDK_INT >= 11) {
            rotatedEvent = MotionEvent.obtain((MotionEvent)event);
            rotatedEvent.transform(this.matrix);
        } else {
            rotatedEvent = MotionEvent.obtainNoHistory((MotionEvent)event);
            this.points[0] = event.getX();
            this.points[1] = event.getY();
            this.matrix.mapPoints(this.points);
            rotatedEvent.setLocation(this.points[0], this.points[1]);
        }
        return rotatedEvent;
    }

    public void setHeading(float heading) {
        this.heading = heading;
    }
}

