/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.android.util;

import android.content.SharedPreferences;
import org.mapsforge.map.model.common.PreferencesFacade;

public class AndroidPreferences
implements PreferencesFacade {
    private SharedPreferences.Editor editor;
    private final SharedPreferences sharedPreferences;

    public AndroidPreferences(SharedPreferences sharedPreferences) {
        this.sharedPreferences = sharedPreferences;
    }

    public synchronized void clear() {
        this.createEditor();
        this.editor.clear();
    }

    public synchronized boolean getBoolean(String key, boolean defaultValue) {
        return this.sharedPreferences.getBoolean(key, defaultValue);
    }

    public synchronized byte getByte(String key, byte defaultValue) {
        int intValue = this.sharedPreferences.getInt(key, (int)defaultValue);
        if (intValue < -128 || intValue > 127) {
            throw new IllegalStateException("byte value out of range: " + intValue);
        }
        return (byte)intValue;
    }

    public synchronized double getDouble(String key, double defaultValue) {
        long longValue = this.sharedPreferences.getLong(key, Double.doubleToLongBits(defaultValue));
        return Double.longBitsToDouble(longValue);
    }

    public synchronized float getFloat(String key, float defaultValue) {
        return this.sharedPreferences.getFloat(key, defaultValue);
    }

    public synchronized int getInt(String key, int defaultValue) {
        return this.sharedPreferences.getInt(key, defaultValue);
    }

    public synchronized long getLong(String key, long defaultValue) {
        return this.sharedPreferences.getLong(key, defaultValue);
    }

    public synchronized String getString(String key, String defaultValue) {
        return this.sharedPreferences.getString(key, defaultValue);
    }

    public synchronized void putBoolean(String key, boolean value) {
        this.createEditor();
        this.editor.putBoolean(key, value);
    }

    public synchronized void putByte(String key, byte value) {
        this.createEditor();
        this.editor.putInt(key, (int)value);
    }

    public synchronized void putDouble(String key, double value) {
        this.createEditor();
        this.editor.putLong(key, Double.doubleToLongBits(value));
    }

    public synchronized void putFloat(String key, float value) {
        this.createEditor();
        this.editor.putFloat(key, value);
    }

    public synchronized void putInt(String key, int value) {
        this.createEditor();
        this.editor.putInt(key, value);
    }

    public synchronized void putLong(String key, long value) {
        this.createEditor();
        this.editor.putLong(key, value);
    }

    public synchronized void putString(String key, String value) {
        this.createEditor();
        this.editor.putString(key, value);
    }

    public synchronized void save() {
        if (this.editor != null) {
            this.editor.apply();
            this.editor = null;
        }
    }

    private void createEditor() {
        if (this.editor == null) {
            this.editor = this.sharedPreferences.edit();
        }
    }
}

