/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.android.util;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Point;
import android.os.Build;
import android.os.Looper;
import android.os.StatFs;
import android.view.Display;
import android.view.WindowManager;
import java.io.File;
import java.util.logging.Logger;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.model.Dimension;
import org.mapsforge.map.android.graphics.AndroidGraphicFactory;
import org.mapsforge.map.android.view.MapView;
import org.mapsforge.map.controller.FrameBufferController;
import org.mapsforge.map.datastore.MapDataStore;
import org.mapsforge.map.layer.cache.FileSystemTileCache;
import org.mapsforge.map.layer.cache.InMemoryTileCache;
import org.mapsforge.map.layer.cache.TileCache;
import org.mapsforge.map.layer.cache.TwoLevelTileCache;
import org.mapsforge.map.layer.hills.HillsRenderConfig;
import org.mapsforge.map.layer.renderer.TileRendererLayer;
import org.mapsforge.map.model.MapViewPosition;
import org.mapsforge.map.rendertheme.XmlRenderTheme;
import org.mapsforge.map.scalebar.DefaultMapScaleBar;
import org.mapsforge.map.scalebar.DistanceUnitAdapter;
import org.mapsforge.map.scalebar.MapScaleBar;

public final class AndroidUtil {
    private static final Logger LOGGER = Logger.getLogger(AndroidUtil.class.getName());

    public static TileCache createExternalStorageTileCache(Context c, String id, int firstLevelSize, int tileSize) {
        return AndroidUtil.createExternalStorageTileCache(c, id, firstLevelSize, tileSize, false);
    }

    public static TileCache createExternalStorageTileCache(Context c, String id, int firstLevelSize, int tileSize, boolean persistent) {
        return AndroidUtil.createExternalStorageTileCache(c.getExternalCacheDir(), id, firstLevelSize, tileSize, persistent);
    }

    public static TileCache createExternalStorageTileCache(File cacheDir, String id, int firstLevelSize, int tileSize, boolean persistent) {
        String cacheDirectoryName;
        File cacheDirectory;
        LOGGER.info("TILECACHE INMEMORY SIZE: " + Integer.toString(firstLevelSize));
        InMemoryTileCache firstLevelTileCache = new InMemoryTileCache(firstLevelSize);
        if (cacheDir != null && ((cacheDirectory = new File(cacheDirectoryName = cacheDir.getAbsolutePath() + File.separator + id)).exists() || cacheDirectory.mkdirs())) {
            int tileCacheFiles = AndroidUtil.estimateSizeOfFileSystemCache(cacheDirectoryName, firstLevelSize, tileSize);
            if (cacheDirectory.canWrite() && tileCacheFiles > 0) {
                try {
                    LOGGER.info("TILECACHE FILE SIZE: " + Integer.toString(tileCacheFiles));
                    FileSystemTileCache secondLevelTileCache = new FileSystemTileCache(tileCacheFiles, cacheDirectory, (GraphicFactory)AndroidGraphicFactory.INSTANCE, persistent);
                    return new TwoLevelTileCache((TileCache)firstLevelTileCache, (TileCache)secondLevelTileCache);
                }
                catch (IllegalArgumentException e) {
                    LOGGER.warning(e.getMessage());
                }
            }
        }
        return firstLevelTileCache;
    }

    public static TileCache createTileCache(Context c, File cacheDir, String id, int tileSize, float screenRatio, double overdraw, boolean persistent) {
        int cacheSize = AndroidUtil.getMinimumCacheSize(c, tileSize, overdraw, screenRatio);
        return AndroidUtil.createExternalStorageTileCache(cacheDir, id, cacheSize, tileSize, persistent);
    }

    public static TileCache createTileCache(Context c, String id, int tileSize, float screenRatio, double overdraw, boolean persistent) {
        int cacheSize = AndroidUtil.getMinimumCacheSize(c, tileSize, overdraw, screenRatio);
        return AndroidUtil.createExternalStorageTileCache(c, id, cacheSize, tileSize, persistent);
    }

    public static TileCache createTileCache(Context c, String id, int tileSize, float screenRatio, double overdraw) {
        return AndroidUtil.createTileCache(c, id, tileSize, screenRatio, overdraw, false);
    }

    public static TileCache createTileCache(File cacheDir, String id, int tileSize, int width, int height, double overdraw, boolean persistent) {
        int cacheSize = AndroidUtil.getMinimumCacheSize(tileSize, overdraw, width, height);
        return AndroidUtil.createExternalStorageTileCache(cacheDir, id, cacheSize, tileSize, persistent);
    }

    public static TileCache createTileCache(Context c, String id, int tileSize, int width, int height, double overdraw, boolean persistent) {
        int cacheSize = AndroidUtil.getMinimumCacheSize(tileSize, overdraw, width, height);
        return AndroidUtil.createExternalStorageTileCache(c, id, cacheSize, tileSize, persistent);
    }

    public static TileCache createTileCache(Context c, String id, int tileSize, int width, int height, double overdraw) {
        return AndroidUtil.createTileCache(c, id, tileSize, width, height, overdraw, false);
    }

    public static TileRendererLayer createTileRendererLayer(TileCache tileCache, MapViewPosition mapViewPosition, MapDataStore mapFile, XmlRenderTheme renderTheme) {
        TileRendererLayer tileRendererLayer = new TileRendererLayer(tileCache, mapFile, mapViewPosition, (GraphicFactory)AndroidGraphicFactory.INSTANCE);
        tileRendererLayer.setXmlRenderTheme(renderTheme);
        return tileRendererLayer;
    }

    public static TileRendererLayer createTileRendererLayer(TileCache tileCache, MapViewPosition mapViewPosition, MapDataStore mapFile, XmlRenderTheme renderTheme, boolean hasAlpha, boolean renderLabels, boolean cacheLabels) {
        TileRendererLayer tileRendererLayer = new TileRendererLayer(tileCache, mapFile, mapViewPosition, hasAlpha, renderLabels, cacheLabels, (GraphicFactory)AndroidGraphicFactory.INSTANCE);
        tileRendererLayer.setXmlRenderTheme(renderTheme);
        return tileRendererLayer;
    }

    public static TileRendererLayer createTileRendererLayer(TileCache tileCache, MapViewPosition mapViewPosition, MapDataStore mapFile, XmlRenderTheme renderTheme, boolean hasAlpha, boolean renderLabels, boolean cacheLabels, HillsRenderConfig hillsRenderConfig) {
        TileRendererLayer tileRendererLayer = new TileRendererLayer(tileCache, mapFile, mapViewPosition, hasAlpha, renderLabels, cacheLabels, (GraphicFactory)AndroidGraphicFactory.INSTANCE, hillsRenderConfig);
        tileRendererLayer.setXmlRenderTheme(renderTheme);
        return tileRendererLayer;
    }

    public static boolean currentThreadIsUiThread() {
        return Looper.getMainLooper().getThread() == Thread.currentThread();
    }

    public static int estimateSizeOfFileSystemCache(String cacheDirectoryName, int firstLevelSize, int tileSize) {
        int tileCacheFileSize = 4 * tileSize * tileSize;
        int maxCacheFiles = 2000;
        int result = (int)Math.min(2000L, AndroidUtil.getAvailableCacheSlots(cacheDirectoryName, tileCacheFileSize));
        if (firstLevelSize > result) {
            result = 0;
        }
        return result;
    }

    @TargetApi(value=18)
    public static long getAvailableCacheSlots(String directory, int fileSize) {
        StatFs statfs = new StatFs(directory);
        if (Build.VERSION.SDK_INT >= 18) {
            return statfs.getAvailableBytes() / (long)fileSize;
        }
        int blocksPerFile = Math.max(fileSize / statfs.getBlockSize(), 1);
        return statfs.getAvailableBlocks() / blocksPerFile;
    }

    @TargetApi(value=13)
    public static int getMinimumCacheSize(Context c, int tileSize, double overdrawFactor, float screenRatio) {
        int width;
        int height;
        WindowManager wm = (WindowManager)c.getSystemService("window");
        Display display = wm.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 13) {
            Point p = new Point();
            display.getSize(p);
            height = p.y;
            width = p.x;
        } else {
            height = display.getHeight();
            width = display.getWidth();
        }
        Dimension dimension = FrameBufferController.calculateFrameBufferDimension((Dimension)new Dimension(width, height), (double)overdrawFactor);
        return (int)Math.max(4.0f, screenRatio * (float)(2 + dimension.height / tileSize) * (float)(2 + dimension.width / tileSize));
    }

    public static int getMinimumCacheSize(int tileSize, double overdrawFactor, int width, int height) {
        Dimension dimension = FrameBufferController.calculateFrameBufferDimension((Dimension)new Dimension(width, height), (double)overdrawFactor);
        return Math.max(4, (2 + dimension.height / tileSize) * (2 + dimension.width / tileSize));
    }

    @TargetApi(value=11)
    public static void restartActivity(Activity activity) {
        if (Build.VERSION.SDK_INT >= 11) {
            activity.recreate();
        } else {
            Intent intent = activity.getIntent();
            intent.addFlags(65536);
            activity.finish();
            activity.overridePendingTransition(0, 0);
            activity.startActivity(intent);
            activity.overridePendingTransition(0, 0);
        }
    }

    public static void setMapScaleBar(MapView mapView, DistanceUnitAdapter primaryDistanceUnitAdapter, DistanceUnitAdapter secondaryDistanceUnitAdapter) {
        if (null == primaryDistanceUnitAdapter && null == secondaryDistanceUnitAdapter) {
            mapView.setMapScaleBar(null);
        } else {
            MapScaleBar scaleBar = mapView.getMapScaleBar();
            if (scaleBar == null) {
                scaleBar = new DefaultMapScaleBar(mapView.getModel().mapViewPosition, mapView.getModel().mapViewDimension, (GraphicFactory)AndroidGraphicFactory.INSTANCE, mapView.getModel().displayModel);
                mapView.setMapScaleBar(scaleBar);
            }
            if (scaleBar instanceof DefaultMapScaleBar) {
                if (null != secondaryDistanceUnitAdapter) {
                    ((DefaultMapScaleBar)scaleBar).setScaleBarMode(DefaultMapScaleBar.ScaleBarMode.BOTH);
                    ((DefaultMapScaleBar)scaleBar).setSecondaryDistanceUnitAdapter(secondaryDistanceUnitAdapter);
                } else {
                    ((DefaultMapScaleBar)scaleBar).setScaleBarMode(DefaultMapScaleBar.ScaleBarMode.SINGLE);
                }
            }
            scaleBar.setDistanceUnitAdapter(primaryDistanceUnitAdapter);
        }
    }

    private AndroidUtil() {
    }
}

