/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.android.util;

import android.app.Activity;
import android.os.Bundle;
import android.os.Environment;
import android.view.View;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.MapPosition;
import org.mapsforge.map.android.graphics.AndroidGraphicFactory;
import org.mapsforge.map.android.util.AndroidPreferences;
import org.mapsforge.map.android.view.MapView;
import org.mapsforge.map.datastore.MapDataStore;
import org.mapsforge.map.layer.cache.TileCache;
import org.mapsforge.map.layer.hills.HillsRenderConfig;
import org.mapsforge.map.model.MapViewPosition;
import org.mapsforge.map.model.common.PreferencesFacade;
import org.mapsforge.map.reader.MapFile;
import org.mapsforge.map.rendertheme.XmlRenderTheme;
import org.mapsforge.map.rendertheme.XmlRenderThemeStyleMenu;

public abstract class MapViewerTemplate
extends Activity {
    protected MapView mapView;
    protected PreferencesFacade preferencesFacade;
    protected XmlRenderThemeStyleMenu renderThemeStyleMenu;
    protected List<TileCache> tileCaches = new ArrayList<TileCache>();

    protected abstract int getLayoutId();

    protected abstract int getMapViewId();

    protected abstract String getMapFileName();

    protected abstract XmlRenderTheme getRenderTheme();

    protected abstract void createLayers();

    protected abstract void createTileCaches();

    protected void createControls() {
        this.initializePosition(this.mapView.getModel().mapViewPosition);
    }

    protected float getMaxTextWidthFactor() {
        return 0.7f;
    }

    protected byte getZoomLevelDefault() {
        return 12;
    }

    protected byte getZoomLevelMin() {
        return 0;
    }

    protected byte getZoomLevelMax() {
        return 24;
    }

    protected void createMapViews() {
        this.mapView = this.getMapView();
        this.mapView.getModel().init(this.preferencesFacade);
        this.mapView.setClickable(true);
        this.mapView.getMapScaleBar().setVisible(true);
        this.mapView.setBuiltInZoomControls(this.hasZoomControls());
        this.mapView.getMapZoomControls().setAutoHide(this.isZoomControlsAutoHide());
        this.mapView.getMapZoomControls().setZoomLevelMin(this.getZoomLevelMin());
        this.mapView.getMapZoomControls().setZoomLevelMax(this.getZoomLevelMax());
    }

    protected void createSharedPreferences() {
        this.preferencesFacade = new AndroidPreferences(this.getSharedPreferences(this.getPersistableId(), 0));
    }

    protected MapPosition getDefaultInitialPosition() {
        return new MapPosition(new LatLong(0.0, 0.0), this.getZoomLevelDefault());
    }

    protected MapPosition getInitialPosition() {
        MapDataStore mapFile = this.getMapFile();
        if (mapFile.startPosition() != null) {
            Byte startZoomLevel = mapFile.startZoomLevel();
            if (startZoomLevel == null) {
                startZoomLevel = new Byte(12);
            }
            return new MapPosition(mapFile.startPosition(), startZoomLevel.byteValue());
        }
        return this.getDefaultInitialPosition();
    }

    protected File getMapFileDirectory() {
        return Environment.getExternalStorageDirectory();
    }

    protected MapDataStore getMapFile() {
        return new MapFile(new File(this.getMapFileDirectory(), this.getMapFileName()));
    }

    protected String getPersistableId() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    protected float getScreenRatio() {
        return 1.0f;
    }

    protected boolean hasZoomControls() {
        return true;
    }

    protected boolean isZoomControlsAutoHide() {
        return true;
    }

    protected MapViewPosition initializePosition(MapViewPosition mvp) {
        LatLong center = mvp.getCenter();
        if (center.equals((Object)new LatLong(0.0, 0.0))) {
            mvp.setMapPosition(this.getInitialPosition());
        }
        mvp.setZoomLevelMax(this.getZoomLevelMax());
        mvp.setZoomLevelMin(this.getZoomLevelMin());
        return mvp;
    }

    protected void checkPermissionsAndCreateLayersAndControls() {
        this.createLayers();
        this.createControls();
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.createSharedPreferences();
        this.createMapViews();
        this.createTileCaches();
        this.checkPermissionsAndCreateLayersAndControls();
    }

    protected void onPause() {
        this.mapView.getModel().save(this.preferencesFacade);
        this.preferencesFacade.save();
        super.onPause();
    }

    protected void onDestroy() {
        this.mapView.destroyAll();
        AndroidGraphicFactory.clearResourceMemoryCache();
        this.tileCaches.clear();
        super.onDestroy();
    }

    protected void purgeTileCaches() {
        for (TileCache tileCache : this.tileCaches) {
            tileCache.purge();
        }
        this.tileCaches.clear();
    }

    protected void redrawLayers() {
        this.mapView.getLayerManager().redrawLayers();
    }

    protected void setContentView() {
        this.setContentView((View)this.mapView);
    }

    protected MapView getMapView() {
        this.setContentView(this.getLayoutId());
        return (MapView)this.findViewById(this.getMapViewId());
    }

    protected HillsRenderConfig getHillsRenderConfig() {
        return null;
    }
}

