/*
 * Decompiled with CFR 0.152.
 */
package org.mapsforge.map.android.view;

import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import android.view.View;
import android.view.ViewGroup;
import org.mapsforge.core.graphics.Canvas;
import org.mapsforge.core.graphics.GraphicContext;
import org.mapsforge.core.graphics.GraphicFactory;
import org.mapsforge.core.model.BoundingBox;
import org.mapsforge.core.model.Dimension;
import org.mapsforge.core.model.LatLong;
import org.mapsforge.core.model.MapPosition;
import org.mapsforge.core.model.Point;
import org.mapsforge.map.android.graphics.AndroidGraphicFactory;
import org.mapsforge.map.android.input.MapZoomControls;
import org.mapsforge.map.android.input.TouchGestureHandler;
import org.mapsforge.map.controller.FrameBufferController;
import org.mapsforge.map.controller.LayerManagerController;
import org.mapsforge.map.controller.MapViewController;
import org.mapsforge.map.layer.Layer;
import org.mapsforge.map.layer.LayerManager;
import org.mapsforge.map.layer.TileLayer;
import org.mapsforge.map.layer.labels.LabelStore;
import org.mapsforge.map.layer.renderer.TileRendererLayer;
import org.mapsforge.map.model.Model;
import org.mapsforge.map.model.common.Observer;
import org.mapsforge.map.scalebar.DefaultMapScaleBar;
import org.mapsforge.map.scalebar.MapScaleBar;
import org.mapsforge.map.util.MapPositionUtil;
import org.mapsforge.map.util.MapViewProjection;
import org.mapsforge.map.view.FpsCounter;
import org.mapsforge.map.view.FrameBuffer;
import org.mapsforge.map.view.FrameBufferHA;

public class MapView
extends ViewGroup
implements org.mapsforge.map.view.MapView,
Observer {
    private static final GraphicFactory GRAPHIC_FACTORY = AndroidGraphicFactory.INSTANCE;
    private final FpsCounter fpsCounter;
    private final FrameBuffer frameBuffer;
    private final FrameBufferController frameBufferController;
    private final GestureDetector gestureDetector;
    private GestureDetector gestureDetectorExternal;
    private LayerManager layerManager;
    private final Handler layoutHandler = new Handler();
    private MapScaleBar mapScaleBar;
    private final MapViewProjection mapViewProjection;
    private final MapZoomControls mapZoomControls;
    private final Model model;
    private final ScaleGestureDetector scaleGestureDetector;
    private final TouchGestureHandler touchGestureHandler;

    public MapView(Context context) {
        this(context, null);
    }

    public MapView(Context context, AttributeSet attributeSet) {
        super(context, attributeSet);
        this.setDescendantFocusability(393216);
        this.setWillNotDraw(false);
        this.model = new Model();
        this.fpsCounter = new FpsCounter(GRAPHIC_FACTORY, this.model.displayModel);
        this.frameBuffer = new FrameBufferHA(this.model.frameBufferModel, this.model.displayModel, GRAPHIC_FACTORY);
        this.frameBufferController = FrameBufferController.create((FrameBuffer)this.frameBuffer, (Model)this.model);
        this.layerManager = new LayerManager((org.mapsforge.map.view.MapView)this, this.model.mapViewPosition, GRAPHIC_FACTORY);
        this.layerManager.start();
        LayerManagerController.create((LayerManager)this.layerManager, (Model)this.model);
        MapViewController.create((org.mapsforge.map.view.MapView)this, (Model)this.model);
        this.touchGestureHandler = new TouchGestureHandler(this);
        this.gestureDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)this.touchGestureHandler);
        this.scaleGestureDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)this.touchGestureHandler);
        this.mapZoomControls = new MapZoomControls(context, this);
        this.addView((View)this.mapZoomControls, new ViewGroup.LayoutParams(-2, -2));
        this.mapScaleBar = new DefaultMapScaleBar(this.model.mapViewPosition, this.model.mapViewDimension, GRAPHIC_FACTORY, this.model.displayModel);
        this.mapViewProjection = new MapViewProjection((org.mapsforge.map.view.MapView)this);
        this.model.mapViewPosition.addObserver((Observer)this);
    }

    public void addLayer(Layer layer) {
        this.layerManager.getLayers().add(layer);
    }

    protected boolean checkLayoutParams(ViewGroup.LayoutParams p) {
        return p instanceof LayoutParams;
    }

    public void destroy() {
        this.touchGestureHandler.destroy();
        this.layoutHandler.removeCallbacksAndMessages(null);
        this.layerManager.interrupt();
        this.layerManager = null;
        this.frameBufferController.destroy();
        this.frameBuffer.destroy();
        if (this.mapScaleBar != null) {
            this.mapScaleBar.destroy();
        }
        this.mapZoomControls.destroy();
        this.getModel().mapViewPosition.destroy();
    }

    public void destroyAll() {
        for (Layer layer : this.layerManager.getLayers()) {
            LabelStore labelStore;
            this.layerManager.getLayers().remove(layer);
            layer.onDestroy();
            if (layer instanceof TileLayer) {
                ((TileLayer)layer).getTileCache().destroy();
            }
            if (!(layer instanceof TileRendererLayer) || (labelStore = ((TileRendererLayer)layer).getLabelStore()) == null) continue;
            labelStore.clear();
        }
        this.destroy();
    }

    protected ViewGroup.LayoutParams generateDefaultLayoutParams() {
        return new LayoutParams(-2, -2, null, LayoutParams.Alignment.BOTTOM_CENTER);
    }

    public ViewGroup.LayoutParams generateLayoutParams(AttributeSet attrs) {
        return new LayoutParams(this.getContext(), attrs);
    }

    protected ViewGroup.LayoutParams generateLayoutParams(ViewGroup.LayoutParams p) {
        return new LayoutParams(p);
    }

    public BoundingBox getBoundingBox() {
        return MapPositionUtil.getBoundingBox((MapPosition)this.model.mapViewPosition.getMapPosition(), (Dimension)this.getDimension(), (int)this.model.displayModel.getTileSize());
    }

    public Dimension getDimension() {
        return new Dimension(this.getWidth(), this.getHeight());
    }

    public FpsCounter getFpsCounter() {
        return this.fpsCounter;
    }

    public FrameBuffer getFrameBuffer() {
        return this.frameBuffer;
    }

    public LayerManager getLayerManager() {
        return this.layerManager;
    }

    public MapScaleBar getMapScaleBar() {
        return this.mapScaleBar;
    }

    public MapViewProjection getMapViewProjection() {
        return this.mapViewProjection;
    }

    public MapZoomControls getMapZoomControls() {
        return this.mapZoomControls;
    }

    public Model getModel() {
        return this.model;
    }

    public TouchGestureHandler getTouchGestureHandler() {
        return this.touchGestureHandler;
    }

    public void onChange() {
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.equals((Object)this.mapZoomControls)) continue;
            this.layoutHandler.post(new Runnable(){

                @Override
                public void run() {
                    MapView.this.requestLayout();
                }
            });
            break;
        }
    }

    protected void onDraw(android.graphics.Canvas androidCanvas) {
        Canvas graphicContext = AndroidGraphicFactory.createGraphicContext(androidCanvas);
        this.frameBuffer.draw((GraphicContext)graphicContext);
        if (this.mapScaleBar != null) {
            this.mapScaleBar.draw((GraphicContext)graphicContext);
        }
        this.fpsCounter.draw((GraphicContext)graphicContext);
        graphicContext.destroy();
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        if (this.mapZoomControls.getVisibility() != 8) {
            int childTop;
            int childLeft;
            int childGravity = this.mapZoomControls.getZoomControlsGravity();
            int childWidth = this.mapZoomControls.getMeasuredWidth();
            int childHeight = this.mapZoomControls.getMeasuredHeight();
            switch (childGravity & 7) {
                case 3: {
                    childLeft = left;
                    break;
                }
                case 1: {
                    childLeft = left + (right - left - childWidth) / 2;
                    break;
                }
                default: {
                    childLeft = right - childWidth;
                }
            }
            switch (childGravity & 0x70) {
                case 48: {
                    childTop = top;
                    break;
                }
                case 16: {
                    childTop = top + (bottom - top - childHeight) / 2;
                    break;
                }
                default: {
                    childTop = bottom - childHeight;
                }
            }
            this.mapZoomControls.layout(childLeft, childTop, childLeft + childWidth, childTop + childHeight);
        }
        int count = this.getChildCount();
        for (int i = 0; i < count; ++i) {
            View child = this.getChildAt(i);
            if (child.equals((Object)this.mapZoomControls) || child.getVisibility() == 8 || !this.checkLayoutParams(child.getLayoutParams())) continue;
            LayoutParams params = (LayoutParams)child.getLayoutParams();
            int childWidth = child.getMeasuredWidth();
            int childHeight = child.getMeasuredHeight();
            Point point = this.mapViewProjection.toPixels(params.latLong);
            if (point == null) continue;
            int childLeft = this.getPaddingLeft() + (int)Math.round(point.x);
            int childTop = this.getPaddingTop() + (int)Math.round(point.y);
            switch (params.alignment) {
                case TOP_LEFT: {
                    break;
                }
                case TOP_CENTER: {
                    childLeft -= childWidth / 2;
                    break;
                }
                case TOP_RIGHT: {
                    childLeft -= childWidth;
                    break;
                }
                case CENTER_LEFT: {
                    childTop -= childHeight / 2;
                    break;
                }
                case CENTER: {
                    childLeft -= childWidth / 2;
                    childTop -= childHeight / 2;
                    break;
                }
                case CENTER_RIGHT: {
                    childLeft -= childWidth;
                    childTop -= childHeight / 2;
                    break;
                }
                case BOTTOM_LEFT: {
                    childTop -= childHeight;
                    break;
                }
                case BOTTOM_CENTER: {
                    childLeft -= childWidth / 2;
                    childTop -= childHeight;
                    break;
                }
                case BOTTOM_RIGHT: {
                    childLeft -= childWidth;
                    childTop -= childHeight;
                }
            }
            child.layout(childLeft, childTop, childLeft + childWidth, childTop + childHeight);
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        this.measureChildren(widthMeasureSpec, heightMeasureSpec);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    protected void onSizeChanged(int width, int height, int oldWidth, int oldHeight) {
        this.model.mapViewDimension.setDimension(new Dimension(width, height));
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isClickable()) {
            return false;
        }
        this.mapZoomControls.onMapViewTouchEvent(event);
        if (this.gestureDetectorExternal != null && this.gestureDetectorExternal.onTouchEvent(event)) {
            return true;
        }
        boolean retVal = this.scaleGestureDetector.onTouchEvent(event);
        if (!this.scaleGestureDetector.isInProgress()) {
            retVal = this.gestureDetector.onTouchEvent(event);
        }
        return retVal;
    }

    public void repaint() {
        if (Thread.currentThread() == Looper.getMainLooper().getThread()) {
            this.invalidate();
        } else {
            this.postInvalidate();
        }
    }

    public void setBuiltInZoomControls(boolean showZoomControls) {
        this.mapZoomControls.setShowMapZoomControls(showZoomControls);
    }

    public void setCenter(LatLong center) {
        this.model.mapViewPosition.setCenter(center);
    }

    public void setGestureDetector(GestureDetector gestureDetector) {
        this.gestureDetectorExternal = gestureDetector;
    }

    public void setMapScaleBar(MapScaleBar mapScaleBar) {
        if (this.mapScaleBar != null) {
            this.mapScaleBar.destroy();
        }
        this.mapScaleBar = mapScaleBar;
    }

    public void setZoomLevel(byte zoomLevel) {
        this.model.mapViewPosition.setZoomLevel(zoomLevel);
    }

    public void setZoomLevelMax(byte zoomLevelMax) {
        this.model.mapViewPosition.setZoomLevelMax(zoomLevelMax);
        this.mapZoomControls.setZoomLevelMax(zoomLevelMax);
    }

    public void setZoomLevelMin(byte zoomLevelMin) {
        this.model.mapViewPosition.setZoomLevelMin(zoomLevelMin);
        this.mapZoomControls.setZoomLevelMin(zoomLevelMin);
    }

    public static class LayoutParams
    extends ViewGroup.LayoutParams {
        public LatLong latLong;
        public Alignment alignment;

        public LayoutParams(Context c, AttributeSet attrs) {
            super(c, attrs);
            this.alignment = Alignment.BOTTOM_CENTER;
        }

        public LayoutParams(int width, int height, LatLong latLong, Alignment alignment) {
            super(width, height);
            this.latLong = latLong;
            this.alignment = alignment;
        }

        public LayoutParams(ViewGroup.LayoutParams source) {
            super(source);
        }

        public static enum Alignment {
            TOP_LEFT,
            TOP_CENTER,
            TOP_RIGHT,
            CENTER_LEFT,
            CENTER,
            CENTER_RIGHT,
            BOTTOM_LEFT,
            BOTTOM_CENTER,
            BOTTOM_RIGHT;

        }
    }
}

