/*
 * Decompiled with CFR 0.152.
 */
package android.support.v4.widget;

import android.os.Build;
import android.support.v4.widget.PopupWindowCompatApi21;
import android.support.v4.widget.PopupWindowCompatApi23;
import android.support.v4.widget.PopupWindowCompatGingerbread;
import android.support.v4.widget.PopupWindowCompatKitKat;
import android.view.View;
import android.widget.PopupWindow;

public class PopupWindowCompat {
    static final PopupWindowImpl IMPL;

    private PopupWindowCompat() {
    }

    public static void showAsDropDown(PopupWindow popup, View anchor, int xoff, int yoff, int gravity) {
        IMPL.showAsDropDown(popup, anchor, xoff, yoff, gravity);
    }

    public static void setOverlapAnchor(PopupWindow popupWindow, boolean overlapAnchor) {
        IMPL.setOverlapAnchor(popupWindow, overlapAnchor);
    }

    public static boolean getOverlapAnchor(PopupWindow popupWindow) {
        return IMPL.getOverlapAnchor(popupWindow);
    }

    public static void setWindowLayoutType(PopupWindow popupWindow, int layoutType) {
        IMPL.setWindowLayoutType(popupWindow, layoutType);
    }

    public static int getWindowLayoutType(PopupWindow popupWindow) {
        return IMPL.getWindowLayoutType(popupWindow);
    }

    static {
        int version = Build.VERSION.SDK_INT;
        IMPL = version >= 23 ? new Api23PopupWindowImpl() : (version >= 21 ? new Api21PopupWindowImpl() : (version >= 19 ? new KitKatPopupWindowImpl() : (version >= 9 ? new GingerbreadPopupWindowImpl() : new BasePopupWindowImpl())));
    }

    static class Api23PopupWindowImpl
    extends Api21PopupWindowImpl {
        Api23PopupWindowImpl() {
        }

        @Override
        public void setOverlapAnchor(PopupWindow popupWindow, boolean overlapAnchor) {
            PopupWindowCompatApi23.setOverlapAnchor((PopupWindow)popupWindow, (boolean)overlapAnchor);
        }

        @Override
        public boolean getOverlapAnchor(PopupWindow popupWindow) {
            return PopupWindowCompatApi23.getOverlapAnchor((PopupWindow)popupWindow);
        }

        @Override
        public void setWindowLayoutType(PopupWindow popupWindow, int layoutType) {
            PopupWindowCompatApi23.setWindowLayoutType((PopupWindow)popupWindow, (int)layoutType);
        }

        @Override
        public int getWindowLayoutType(PopupWindow popupWindow) {
            return PopupWindowCompatApi23.getWindowLayoutType((PopupWindow)popupWindow);
        }
    }

    static class Api21PopupWindowImpl
    extends KitKatPopupWindowImpl {
        Api21PopupWindowImpl() {
        }

        @Override
        public void setOverlapAnchor(PopupWindow popupWindow, boolean overlapAnchor) {
            PopupWindowCompatApi21.setOverlapAnchor((PopupWindow)popupWindow, (boolean)overlapAnchor);
        }

        @Override
        public boolean getOverlapAnchor(PopupWindow popupWindow) {
            return PopupWindowCompatApi21.getOverlapAnchor((PopupWindow)popupWindow);
        }
    }

    static class KitKatPopupWindowImpl
    extends GingerbreadPopupWindowImpl {
        KitKatPopupWindowImpl() {
        }

        @Override
        public void showAsDropDown(PopupWindow popup, View anchor, int xoff, int yoff, int gravity) {
            PopupWindowCompatKitKat.showAsDropDown((PopupWindow)popup, (View)anchor, (int)xoff, (int)yoff, (int)gravity);
        }
    }

    static class GingerbreadPopupWindowImpl
    extends BasePopupWindowImpl {
        GingerbreadPopupWindowImpl() {
        }

        @Override
        public void setWindowLayoutType(PopupWindow popupWindow, int layoutType) {
            PopupWindowCompatGingerbread.setWindowLayoutType((PopupWindow)popupWindow, (int)layoutType);
        }

        @Override
        public int getWindowLayoutType(PopupWindow popupWindow) {
            return PopupWindowCompatGingerbread.getWindowLayoutType((PopupWindow)popupWindow);
        }
    }

    static class BasePopupWindowImpl
    implements PopupWindowImpl {
        BasePopupWindowImpl() {
        }

        @Override
        public void showAsDropDown(PopupWindow popup, View anchor, int xoff, int yoff, int gravity) {
            popup.showAsDropDown(anchor, xoff, yoff);
        }

        @Override
        public void setOverlapAnchor(PopupWindow popupWindow, boolean overlapAnchor) {
        }

        @Override
        public boolean getOverlapAnchor(PopupWindow popupWindow) {
            return false;
        }

        @Override
        public void setWindowLayoutType(PopupWindow popupWindow, int layoutType) {
        }

        @Override
        public int getWindowLayoutType(PopupWindow popupWindow) {
            return 0;
        }
    }

    static interface PopupWindowImpl {
        public void showAsDropDown(PopupWindow var1, View var2, int var3, int var4, int var5);

        public void setOverlapAnchor(PopupWindow var1, boolean var2);

        public boolean getOverlapAnchor(PopupWindow var1);

        public void setWindowLayoutType(PopupWindow var1, int var2);

        public int getWindowLayoutType(PopupWindow var1);
    }
}

