/*
 * Decompiled with CFR 0.152.
 */
package com.jakewharton.processphoenix;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.os.Bundle;
import android.os.Process;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class ProcessPhoenix
extends Activity {
    private static final String KEY_RESTART_INTENTS = "phoenix_restart_intents";

    public static void triggerRebirth(Context context) {
        ProcessPhoenix.triggerRebirth(context, ProcessPhoenix.getRestartIntent(context));
    }

    public static void triggerRebirth(Context context, Intent ... nextIntents) {
        Intent intent = new Intent(context, ProcessPhoenix.class);
        intent.addFlags(0x10000000);
        intent.putParcelableArrayListExtra(KEY_RESTART_INTENTS, new ArrayList<Intent>(Arrays.asList(nextIntents)));
        context.startActivity(intent);
        if (context instanceof Activity) {
            ((Activity)context).finish();
        }
        Runtime.getRuntime().exit(0);
    }

    private static Intent getRestartIntent(Context context) {
        Intent defaultIntent = new Intent("android.intent.action.MAIN", null);
        defaultIntent.addFlags(0x10008000);
        defaultIntent.addCategory("android.intent.category.DEFAULT");
        String packageName = context.getPackageName();
        PackageManager packageManager = context.getPackageManager();
        for (ResolveInfo resolveInfo : packageManager.queryIntentActivities(defaultIntent, 0)) {
            ActivityInfo activityInfo = resolveInfo.activityInfo;
            if (!activityInfo.packageName.equals(packageName)) continue;
            defaultIntent.setComponent(new ComponentName(packageName, activityInfo.name));
            return defaultIntent;
        }
        throw new IllegalStateException("Unable to determine default activity for " + packageName + ". Does an activity specify the DEFAULT category in its intent filter?");
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        ArrayList intents = this.getIntent().getParcelableArrayListExtra(KEY_RESTART_INTENTS);
        this.startActivities(intents.toArray(new Intent[intents.size()]));
        this.finish();
        Runtime.getRuntime().exit(0);
    }

    public static boolean isPhoenixProcess(Context context) {
        int currentPid = Process.myPid();
        ActivityManager manager = (ActivityManager)context.getSystemService("activity");
        List runningProcesses = manager.getRunningAppProcesses();
        if (runningProcesses != null) {
            for (ActivityManager.RunningAppProcessInfo processInfo : runningProcesses) {
                if (processInfo.pid != currentPid || !processInfo.processName.endsWith(":phoenix")) continue;
                return true;
            }
        }
        return false;
    }
}

