/*
 * Decompiled with CFR 0.152.
 */
package com.caverock.androidsvg;

public class IntegerParser {
    int pos;
    boolean isNegative;
    long value;

    public IntegerParser(boolean isNegative, long value, int pos) {
        this.isNegative = isNegative;
        this.value = value;
        this.pos = pos;
    }

    public int getEndPos() {
        return this.pos;
    }

    public static IntegerParser parseInt(String str) {
        return IntegerParser.parseInt(str, 0, str.length());
    }

    public static IntegerParser parseInt(String input, int startpos, int len) {
        int pos = startpos;
        boolean isNegative = false;
        long value = 0L;
        int sigStart = 0;
        if (pos >= len) {
            return null;
        }
        char ch = input.charAt(pos);
        switch (ch) {
            case '-': {
                isNegative = true;
            }
            case '+': {
                ++pos;
            }
        }
        sigStart = pos;
        while (pos < len) {
            ch = input.charAt(pos);
            if (ch < '0' || ch > '9') break;
            if (isNegative ? (value = value * 10L - (long)(ch - 48)) < Integer.MIN_VALUE : (value = value * 10L + (long)(ch - 48)) > Integer.MAX_VALUE) {
                return null;
            }
            ++pos;
        }
        if (pos == sigStart) {
            return null;
        }
        return new IntegerParser(isNegative, value, pos);
    }

    public int value() {
        return (int)this.value;
    }

    public static IntegerParser parseHex(String str) {
        return IntegerParser.parseHex(str, 0, str.length());
    }

    /*
     * Unable to fully structure code
     */
    public static IntegerParser parseHex(String input, int startpos, int len) {
        pos = startpos;
        value = 0L;
        if (pos < len) ** GOTO lbl17
        return null;
lbl-1000:
        // 1 sources

        {
            ch = input.charAt(pos);
            if (ch >= '0' && ch <= '9') {
                value = value * 16L + (long)(ch - 48);
            } else if (ch >= 'A' && ch <= 'F') {
                value = value * 16L + (long)(ch - 65) + 10L;
            } else {
                if (ch < 'a' || ch > 'f') break;
                value = value * 16L + (long)(ch - 97) + 10L;
            }
            if (value > 0xFFFFFFFFL) {
                return null;
            }
            ++pos;
lbl17:
            // 2 sources

            ** while (pos < len)
        }
lbl18:
        // 2 sources

        if (pos == startpos) {
            return null;
        }
        return new IntegerParser(false, value, pos);
    }
}

