/*
 * Decompiled with CFR 0.152.
 */
package com.caverock.androidsvg;

public class NumberParser {
    int pos;
    boolean isNegative;
    long significand;
    int numDigits;
    int exponent;
    static long TOO_BIG = 0xCCCCCCCCCCCCCCCL;
    private static final float[] positivePowersOf10 = new float[]{1.0f, 10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f, 1.0E7f, 1.0E8f, 1.0E9f, 1.0E10f, 1.0E11f, 1.0E12f, 1.0E13f, 1.0E14f, 1.0E15f, 1.0E16f, 1.0E17f, 1.0E18f, 1.0E19f, 1.0E20f, 1.0E21f, 1.0E22f, 1.0E23f, 1.0E24f, 1.0E25f, 1.0E26f, 1.0E27f, 1.0E28f, 1.0E29f, 1.0E30f, 1.0E31f, 1.0E32f, 1.0E33f, 1.0E34f, 1.0E35f, 1.0E36f, 1.0E37f, 1.0E38f};
    private static final float[] negativePowersOf10 = new float[]{1.0f, 0.1f, 0.01f, 0.001f, 1.0E-4f, 1.0E-5f, 1.0E-6f, 1.0E-7f, 1.0E-8f, 1.0E-9f, 1.0E-10f, 1.0E-11f, 1.0E-12f, 1.0E-13f, 1.0E-14f, 1.0E-15f, 1.0E-16f, 1.0E-17f, 1.0E-18f, 1.0E-19f, 1.0E-20f, 1.0E-21f, 1.0E-22f, 1.0E-23f, 1.0E-24f, 1.0E-25f, 1.0E-26f, 1.0E-27f, 1.0E-28f, 1.0E-29f, 1.0E-30f, 1.0E-31f, 1.0E-32f, 1.0E-33f, 1.0E-34f, 1.0E-35f, 1.0E-36f, 1.0E-37f, 1.0E-38f};

    public NumberParser(boolean isNegative, long significand, int exponent, int pos) {
        this.isNegative = isNegative;
        this.significand = significand;
        this.exponent = exponent;
        this.pos = pos;
    }

    public int getEndPos() {
        return this.pos;
    }

    public static NumberParser parseNumber(String str) {
        return NumberParser.parseNumber(str, 0, str.length());
    }

    public static NumberParser parseNumber(String input, int startpos, int len) {
        int pos = startpos;
        boolean isNegative = false;
        long significand = 0L;
        int numDigits = 0;
        int numLeadingZeroes = 0;
        int numTrailingZeroes = 0;
        boolean decimalSeen = false;
        int sigStart = 0;
        int decimalPos = 0;
        int exponent = 0;
        if (pos >= len) {
            return null;
        }
        char ch = input.charAt(pos);
        switch (ch) {
            case '-': {
                isNegative = true;
            }
            case '+': {
                ++pos;
            }
        }
        sigStart = pos;
        while (pos < len) {
            ch = input.charAt(pos);
            if (ch == '0') {
                if (numDigits == 0) {
                    ++numLeadingZeroes;
                } else {
                    ++numTrailingZeroes;
                }
            } else if (ch >= '1' && ch <= '9') {
                numDigits += numTrailingZeroes;
                while (numTrailingZeroes > 0) {
                    if (significand > TOO_BIG) {
                        return null;
                    }
                    significand *= 10L;
                    --numTrailingZeroes;
                }
                if (significand > TOO_BIG) {
                    return null;
                }
                significand = significand * 10L + (long)(ch - 48);
                ++numDigits;
                if (significand < 0L) {
                    return null;
                }
            } else {
                if (ch != '.' || decimalSeen) break;
                decimalPos = pos - sigStart;
                decimalSeen = true;
            }
            ++pos;
        }
        if (decimalSeen && pos == decimalPos + 1) {
            return null;
        }
        if (numDigits == 0) {
            if (numLeadingZeroes == 0) {
                return null;
            }
            numDigits = 1;
        }
        exponent = decimalSeen ? decimalPos - numLeadingZeroes - numDigits : numTrailingZeroes;
        if (pos < len && ((ch = input.charAt(pos)) == 'E' || ch == 'e')) {
            boolean expIsNegative = false;
            int expVal = 0;
            if (++pos == len) {
                return null;
            }
            switch (input.charAt(pos)) {
                case '-': {
                    expIsNegative = true;
                }
                case '+': {
                    ++pos;
                }
            }
            int expStart = pos;
            while (pos < len) {
                ch = input.charAt(pos);
                if (ch < '0' || ch > '9') break;
                if ((long)expVal > TOO_BIG) {
                    return null;
                }
                expVal = expVal * 10 + (ch - 48);
                ++pos;
            }
            if (pos == expStart) {
                return null;
            }
            exponent = expIsNegative ? (exponent -= expVal) : (exponent += expVal);
        }
        if (exponent + numDigits > 39 || exponent + numDigits < -44) {
            return null;
        }
        if (significand == 0L) {
            return new NumberParser(isNegative, 0L, 0, pos);
        }
        return new NumberParser(isNegative, significand, exponent, pos);
    }

    public float value() {
        float f = this.significand;
        if (this.exponent > 0) {
            f *= positivePowersOf10[this.exponent];
        } else if (this.exponent < 0) {
            if (this.exponent < -38) {
                f = (float)((double)f * 1.0E-20);
                this.exponent += 20;
            }
            f *= negativePowersOf10[-this.exponent];
        }
        return this.isNegative ? -f : f;
    }
}

