/*
 * Decompiled with CFR 0.152.
 */
package com.caverock.androidsvg;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Paint;
import android.graphics.Picture;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.PictureDrawable;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import com.caverock.androidsvg.R;
import com.caverock.androidsvg.SVG;
import com.caverock.androidsvg.SVGParseException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;

public class SVGImageView
extends ImageView {
    private static Method setLayerTypeMethod = null;

    public SVGImageView(Context context) {
        super(context);
        try {
            setLayerTypeMethod = View.class.getMethod("setLayerType", Integer.TYPE, Paint.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }

    public SVGImageView(Context context, AttributeSet attrs) {
        super(context, attrs, 0);
        try {
            setLayerTypeMethod = View.class.getMethod("setLayerType", Integer.TYPE, Paint.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.init(attrs, 0);
    }

    public SVGImageView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        try {
            setLayerTypeMethod = View.class.getMethod("setLayerType", Integer.TYPE, Paint.class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        this.init(attrs, defStyle);
    }

    private void init(AttributeSet attrs, int defStyle) {
        if (this.isInEditMode()) {
            return;
        }
        TypedArray a = this.getContext().getTheme().obtainStyledAttributes(attrs, R.styleable.SVGImageView, defStyle, 0);
        try {
            int resourceId = a.getResourceId(0, -1);
            if (resourceId != -1) {
                this.setImageResource(resourceId);
                return;
            }
            String url = a.getString(0);
            if (url != null) {
                Uri uri = Uri.parse((String)url);
                if (this.internalSetImageURI(uri, false)) {
                    return;
                }
                this.setImageAsset(url);
            }
        }
        finally {
            a.recycle();
        }
    }

    public void setSVG(SVG mysvg) {
        if (mysvg == null) {
            throw new IllegalArgumentException("Null value passed to setSVG()");
        }
        this.setSoftwareLayerType();
        this.setImageDrawable((Drawable)new PictureDrawable(mysvg.renderToPicture()));
    }

    public void setImageResource(int resourceId) {
        new LoadResourceTask().execute(new Integer[]{resourceId});
    }

    public void setImageURI(Uri uri) {
        this.internalSetImageURI(uri, true);
    }

    public void setImageAsset(String filename) {
        new LoadAssetTask().execute(new String[]{filename});
    }

    private boolean internalSetImageURI(Uri uri, boolean isDirectRequestFromUser) {
        InputStream is = null;
        try {
            is = this.getContext().getContentResolver().openInputStream(uri);
        }
        catch (FileNotFoundException e) {
            if (isDirectRequestFromUser) {
                Log.e((String)"SVGImageView", (String)("File not found: " + uri));
            }
            return false;
        }
        new LoadURITask().execute(new InputStream[]{is});
        return true;
    }

    private void setSoftwareLayerType() {
        if (setLayerTypeMethod == null) {
            return;
        }
        try {
            int LAYER_TYPE_SOFTWARE = View.class.getField("LAYER_TYPE_SOFTWARE").getInt(new View(this.getContext()));
            setLayerTypeMethod.invoke((Object)this, LAYER_TYPE_SOFTWARE, null);
        }
        catch (Exception e) {
            Log.w((String)"SVGImageView", (String)"Unexpected failure calling setLayerType", (Throwable)e);
        }
    }

    private class LoadAssetTask
    extends AsyncTask<String, Integer, Picture> {
        private LoadAssetTask() {
        }

        protected Picture doInBackground(String ... filename) {
            try {
                SVG svg = SVG.getFromAsset(SVGImageView.this.getContext().getAssets(), filename[0]);
                return svg.renderToPicture();
            }
            catch (SVGParseException e) {
                Log.e((String)"SVGImageView", (String)("Error loading file " + filename + ": " + e.getMessage()));
            }
            catch (FileNotFoundException e) {
                Log.e((String)"SVGImageView", (String)("File not found: " + filename));
            }
            catch (IOException e) {
                Log.e((String)"SVGImageView", (String)("Unable to load asset file: " + filename), (Throwable)e);
            }
            return null;
        }

        protected void onPostExecute(Picture picture) {
            if (picture != null) {
                SVGImageView.this.setSoftwareLayerType();
                SVGImageView.this.setImageDrawable((Drawable)new PictureDrawable(picture));
            }
        }
    }

    private class LoadResourceTask
    extends AsyncTask<Integer, Integer, Picture> {
        private LoadResourceTask() {
        }

        protected Picture doInBackground(Integer ... resourceId) {
            try {
                SVG svg = SVG.getFromResource(SVGImageView.this.getContext(), (int)resourceId[0]);
                return svg.renderToPicture();
            }
            catch (SVGParseException e) {
                Log.e((String)"SVGImageView", (String)String.format("Error loading resource 0x%x: %s", resourceId, e.getMessage()));
                return null;
            }
        }

        protected void onPostExecute(Picture picture) {
            if (picture != null) {
                SVGImageView.this.setSoftwareLayerType();
                SVGImageView.this.setImageDrawable((Drawable)new PictureDrawable(picture));
            }
        }
    }

    private class LoadURITask
    extends AsyncTask<InputStream, Integer, Picture> {
        private LoadURITask() {
        }

        protected Picture doInBackground(InputStream ... is) {
            try {
                SVG svg = SVG.getFromInputStream(is[0]);
                Picture picture = svg.renderToPicture();
                return picture;
            }
            catch (SVGParseException e) {
                Log.e((String)"SVGImageView", (String)("Parse error loading URI: " + e.getMessage()));
            }
            finally {
                try {
                    is[0].close();
                }
                catch (IOException iOException) {}
            }
            return null;
        }

        protected void onPostExecute(Picture picture) {
            if (picture != null) {
                SVGImageView.this.setSoftwareLayerType();
                SVGImageView.this.setImageDrawable((Drawable)new PictureDrawable(picture));
            }
        }
    }
}

