/*
 * Decompiled with CFR 0.152.
 */
package com.jensdriller.libs.undobar;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.widget.RelativeLayout;

class MaxWidthRelativeLayout
extends RelativeLayout {
    private int mMaxWidth;

    public MaxWidthRelativeLayout(Context context) {
        super(context);
        this.init(null);
    }

    public MaxWidthRelativeLayout(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(attrs);
    }

    public MaxWidthRelativeLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.init(attrs);
    }

    @TargetApi(value=21)
    public MaxWidthRelativeLayout(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(attrs);
    }

    private void init(AttributeSet attrs) {
        if (attrs != null) {
            TypedArray a = this.getContext().obtainStyledAttributes(attrs, new int[]{0x101011F});
            this.mMaxWidth = a.getDimensionPixelSize(0, -1);
            a.recycle();
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measuredWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (this.mMaxWidth > 0 && this.mMaxWidth < measuredWidth) {
            int measureMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)this.mMaxWidth, (int)measureMode);
        }
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}

