/*
 * Decompiled with CFR 0.152.
 */
package com.jensdriller.libs.undobar;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.os.Build;
import android.os.Handler;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.Window;
import com.jensdriller.libs.undobar.R;
import com.jensdriller.libs.undobar.UndoBarView;
import com.jensdriller.libs.undobar.ViewCompat;
import com.jensdriller.libs.undobar.ViewCompatImpl;

public class UndoBar {
    public static final int DEFAULT_DURATION = 5000;
    public static final int DEFAULT_ANIMATION_DURATION = 300;
    protected final Context mContext;
    protected final UndoBarView mView;
    protected final ViewCompat mViewCompat;
    protected final Handler mHandler = new Handler();
    private final Runnable mHideRunnable = new Runnable(){

        @Override
        public void run() {
            UndoBar.this.onHide();
        }
    };
    private final View.OnClickListener mOnUndoClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            UndoBar.this.onUndo();
        }
    };
    protected Listener mUndoListener;
    protected Parcelable mUndoToken;
    protected CharSequence mUndoMessage;
    protected int mDuration = 5000;
    protected int mAnimationDuration = 300;
    protected boolean mUseEnglishLocale;
    protected Style mStyle = Style.DEFAULT;
    protected int mUndoColor = -1;
    protected boolean mAlignParentBottom;

    public UndoBar(Activity activity) {
        this(activity.getWindow());
    }

    public UndoBar(Activity activity, Style style) {
        this(activity.getWindow(), style);
    }

    public UndoBar(Dialog dialog) {
        this(dialog.getWindow());
    }

    public UndoBar(Dialog dialog, Style style) {
        this(dialog.getWindow(), style);
    }

    public UndoBar(Window window) {
        this(window, null);
    }

    public UndoBar(Window window, Style style) {
        if (style == null) {
            style = Style.DEFAULT;
        }
        this.mContext = window.getContext();
        this.mStyle = style;
        this.mView = this.getView(window);
        this.mView.setOnUndoClickListener(this.mOnUndoClickListener);
        this.mViewCompat = new ViewCompatImpl((View)this.mView);
        this.hide(false);
    }

    public void setMessage(CharSequence message) {
        this.mUndoMessage = message;
    }

    public void setMessage(int messageResId) {
        this.mUndoMessage = this.mContext.getString(messageResId);
    }

    public void setListener(Listener undoListener) {
        this.mUndoListener = undoListener;
    }

    public void setUndoToken(Parcelable undoToken) {
        this.mUndoToken = undoToken;
    }

    public void setDuration(int duration) {
        this.mDuration = duration;
    }

    public void setAnimationDuration(int animationDuration) {
        this.mAnimationDuration = animationDuration;
    }

    public void setUseEnglishLocale(boolean useEnglishLocale) {
        this.mUseEnglishLocale = useEnglishLocale;
    }

    public void setUndoColor(int color) {
        this.mUndoColor = color;
    }

    public void setUndoColorResId(int colorResId) {
        this.mUndoColor = this.mContext.getResources().getColor(colorResId);
    }

    public void setAlignParentBottom(boolean alignParentBottom) {
        this.mAlignParentBottom = alignParentBottom;
    }

    public void show() {
        this.show(true);
    }

    public void show(boolean shouldAnimate) {
        this.mView.setMessage(this.mUndoMessage);
        this.mView.setButtonLabel(this.mUseEnglishLocale ? R.string.undo_english : R.string.undo);
        if (this.isLollipopStyle(this.mStyle)) {
            this.mView.setUndoColor(this.mUndoColor);
            if (this.mAlignParentBottom && this.isAlignBottomPossible()) {
                UndoBar.removeMargins((View)this.mView);
            }
        }
        this.mHandler.removeCallbacks(this.mHideRunnable);
        this.mHandler.postDelayed(this.mHideRunnable, (long)this.mDuration);
        this.mView.setVisibility(0);
        if (shouldAnimate) {
            this.animateIn();
        } else {
            this.mViewCompat.setAlpha(1.0f);
        }
    }

    private boolean isLollipopStyle(Style style) {
        return style == Style.LOLLIPOP || style == Style.DEFAULT && Build.VERSION.SDK_INT >= 21;
    }

    private boolean isAlignBottomPossible() {
        return this.mContext.getResources().getBoolean(R.bool.is_align_bottom_possible);
    }

    private static void removeMargins(View view) {
        ViewGroup.MarginLayoutParams layoutParams = (ViewGroup.MarginLayoutParams)view.getLayoutParams();
        layoutParams.bottomMargin = 0;
        layoutParams.rightMargin = 0;
        layoutParams.topMargin = 0;
        layoutParams.leftMargin = 0;
        view.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
    }

    public void hide() {
        this.hide(true);
    }

    public void hide(boolean shouldAnimate) {
        this.mHandler.removeCallbacks(this.mHideRunnable);
        if (shouldAnimate) {
            this.animateOut();
        } else {
            this.mViewCompat.setAlpha(0.0f);
            this.mView.setVisibility(8);
            this.mUndoMessage = null;
            this.mUndoToken = null;
        }
    }

    public boolean isVisible() {
        return this.mView.getVisibility() == 0;
    }

    protected void animateIn() {
        this.mViewCompat.animateIn(this.mAnimationDuration);
    }

    protected void animateOut() {
        this.mViewCompat.animateOut(this.mAnimationDuration, new ViewCompat.AnimatorListener(){

            @Override
            public void onAnimationEnd() {
                UndoBar.this.mView.setVisibility(8);
                UndoBar.this.mUndoMessage = null;
                UndoBar.this.mUndoToken = null;
            }
        });
    }

    protected void onHide() {
        this.hide(true);
        this.safelyNotifyOnHide();
        this.mUndoListener = null;
    }

    protected void onUndo() {
        this.hide(true);
        this.safelyNotifyOnUndo();
    }

    protected void safelyNotifyOnHide() {
        if (this.mUndoListener != null) {
            this.mUndoListener.onHide();
        }
    }

    protected void safelyNotifyOnUndo() {
        if (this.mUndoListener != null) {
            this.mUndoListener.onUndo(this.mUndoToken);
        }
    }

    protected UndoBarView getView(Window window) {
        UndoBarView undoBarView;
        ViewGroup decorView = (ViewGroup)window.getDecorView();
        ViewGroup rootView = (ViewGroup)decorView.findViewById(0x1020002);
        if (rootView == null) {
            rootView = decorView;
        }
        if ((undoBarView = (UndoBarView)rootView.findViewById(R.id.undoBar)) == null || undoBarView.getTag() != this.mStyle) {
            rootView.removeView((View)undoBarView);
            undoBarView = (UndoBarView)LayoutInflater.from((Context)rootView.getContext()).inflate(this.mStyle.getLayoutResId(), rootView, false);
            undoBarView.setTag((Object)this.mStyle);
            rootView.addView((View)undoBarView);
        }
        return undoBarView;
    }

    public static class Builder {
        private final Window mWindow;
        private CharSequence mUndoMessage;
        private Listener mUndoListener;
        private Parcelable mUndoToken;
        private int mDuration = 5000;
        private int mAnimationDuration = 300;
        private boolean mUseEnglishLocale;
        private Style mStyle;
        private int mUndoColor = -1;
        private boolean mAlignParentBottom;

        public Builder(Activity activity) {
            this.mWindow = activity.getWindow();
        }

        public Builder(Dialog dialog) {
            this.mWindow = dialog.getWindow();
        }

        public Builder(Window window) {
            this.mWindow = window;
        }

        public Builder setMessage(int messageResId) {
            this.mUndoMessage = this.mWindow.getContext().getString(messageResId);
            return this;
        }

        public Builder setMessage(CharSequence message) {
            this.mUndoMessage = message;
            return this;
        }

        public Builder setListener(Listener undoListener) {
            this.mUndoListener = undoListener;
            return this;
        }

        public Builder setUndoToken(Parcelable undoToken) {
            this.mUndoToken = undoToken;
            return this;
        }

        public Builder setDuration(int duration) {
            this.mDuration = duration;
            return this;
        }

        public Builder setAnimationDuration(int animationDuration) {
            this.mAnimationDuration = animationDuration;
            return this;
        }

        public Builder setUseEnglishLocale(boolean useEnglishLocale) {
            this.mUseEnglishLocale = useEnglishLocale;
            return this;
        }

        public Builder setStyle(Style style) {
            this.mStyle = style;
            return this;
        }

        public Builder setUndoColor(int undoColor) {
            this.mUndoColor = undoColor;
            return this;
        }

        public Builder setUndoColorResId(int undoColorResId) {
            this.mUndoColor = this.mWindow.getContext().getResources().getColor(undoColorResId);
            return this;
        }

        public Builder setAlignParentBottom(boolean alignParentBottom) {
            this.mAlignParentBottom = alignParentBottom;
            return this;
        }

        public UndoBar create() {
            UndoBar undoBarController = new UndoBar(this.mWindow, this.mStyle);
            undoBarController.setListener(this.mUndoListener);
            undoBarController.setUndoToken(this.mUndoToken);
            undoBarController.setMessage(this.mUndoMessage);
            undoBarController.setDuration(this.mDuration);
            undoBarController.setAnimationDuration(this.mAnimationDuration);
            undoBarController.setUseEnglishLocale(this.mUseEnglishLocale);
            undoBarController.setUndoColor(this.mUndoColor);
            undoBarController.setAlignParentBottom(this.mAlignParentBottom);
            return undoBarController;
        }

        public void show() {
            this.show(true);
        }

        public void show(boolean shouldAnimate) {
            this.create().show(shouldAnimate);
        }
    }

    public static interface Listener {
        public void onHide();

        public void onUndo(Parcelable var1);
    }

    public static enum Style {
        DEFAULT(R.layout.undo_bar),
        HOLO(R.layout.undo_bar_holo),
        KITKAT(R.layout.undo_bar_kitkat),
        LOLLIPOP(R.layout.undo_bar_lollipop);

        private final int mLayoutResId;

        private Style(int layoutResId) {
            this.mLayoutResId = layoutResId;
        }

        int getLayoutResId() {
            return this.mLayoutResId;
        }
    }
}

