/*
 * Decompiled with CFR 0.152.
 */
package com.jensdriller.libs.undobar;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Parcel;
import android.os.Parcelable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.TextView;
import com.jensdriller.libs.undobar.MaxWidthRelativeLayout;
import com.jensdriller.libs.undobar.R;

class UndoBarView
extends MaxWidthRelativeLayout {
    private TextView mMessage;
    private TextView mButton;

    public UndoBarView(Context context) {
        super(context);
    }

    public UndoBarView(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public UndoBarView(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    @TargetApi(value=21)
    public UndoBarView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mMessage = (TextView)this.findViewById(R.id.message);
        this.mButton = (TextView)this.findViewById(R.id.button);
    }

    void setMessage(CharSequence message) {
        this.mMessage.setText(message);
    }

    void setButtonLabel(int buttonLabelResId) {
        this.mButton.setText(buttonLabelResId);
    }

    void setUndoColor(int color) {
        this.mButton.setTextColor(color);
    }

    void setOnUndoClickListener(View.OnClickListener onClickListener) {
        this.mButton.setOnClickListener(onClickListener);
    }

    public Parcelable onSaveInstanceState() {
        Parcelable superState = super.onSaveInstanceState();
        SavedState ss = new SavedState(superState);
        ss.message = this.mMessage.getText().toString();
        return ss;
    }

    public void onRestoreInstanceState(Parcelable state) {
        if (!(state instanceof SavedState)) {
            super.onRestoreInstanceState(state);
            return;
        }
        SavedState ss = (SavedState)state;
        super.onRestoreInstanceState(ss.getSuperState());
        this.setMessage(ss.message);
    }

    private static class SavedState
    extends View.BaseSavedState {
        String message;
        public static final Parcelable.Creator<SavedState> CREATOR = new Parcelable.Creator<SavedState>(){

            public SavedState createFromParcel(Parcel in) {
                return new SavedState(in);
            }

            public SavedState[] newArray(int size) {
                return new SavedState[size];
            }
        };

        SavedState(Parcelable superState) {
            super(superState);
        }

        public void writeToParcel(Parcel dest, int flags) {
            super.writeToParcel(dest, flags);
            dest.writeString(this.message);
        }

        private SavedState(Parcel in) {
            super(in);
            this.message = in.readString();
        }
    }
}

