/*
 * Decompiled with CFR 0.152.
 */
package locus.api.android;

import android.content.Context;
import android.content.Intent;
import locus.api.android.utils.LocusUtils;
import locus.api.android.utils.exceptions.RequiredVersionMissingException;
import locus.api.utils.Logger;

public class ActionDisplay {
    private static final String TAG = "ActionDisplay";

    protected static boolean sendData(String action, Context context, Intent intent, boolean callImport, boolean center) throws RequiredVersionMissingException {
        return ActionDisplay.sendData(action, context, intent, callImport, center, LocusUtils.VersionCode.UPDATE_01);
    }

    protected static boolean sendData(String action, Context context, Intent intent, boolean callImport, boolean center, LocusUtils.VersionCode vc) throws RequiredVersionMissingException {
        if (!LocusUtils.isLocusAvailable(context, vc.vcFree, vc.vcPro, 0)) {
            throw new RequiredVersionMissingException(vc.vcFree);
        }
        if (!ActionDisplay.hasData(intent)) {
            Logger.logW((String)TAG, (String)"Intent 'null' or not contain any data");
            return false;
        }
        intent.setAction(action);
        intent.putExtra("INTENT_EXTRA_CENTER_ON_DATA", center);
        if (action.equals("locus.api.android.ACTION_DISPLAY_DATA_SILENTLY")) {
            context.sendBroadcast(intent);
        } else {
            intent.putExtra("INTENT_EXTRA_CALL_IMPORT", callImport);
            context.startActivity(intent);
        }
        return true;
    }

    public static boolean hasData(Intent intent) {
        if (intent == null) {
            return false;
        }
        return intent.getByteArrayExtra("INTENT_EXTRA_POINTS_DATA") != null || intent.getByteArrayExtra("INTENT_EXTRA_POINTS_DATA_ARRAY") != null || intent.getStringExtra("INTENT_EXTRA_POINTS_FILE_PATH") != null || intent.getByteArrayExtra("INTENT_EXTRA_TRACKS_SINGLE") != null || intent.getByteArrayExtra("INTENT_EXTRA_TRACKS_MULTI") != null || intent.getByteArrayExtra("INTENT_EXTRA_CIRCLES_MULTI") != null;
    }

    protected static boolean removeSpecialDataSilently(Context ctx, LocusUtils.LocusVersion lv, String extraName, long[] itemsId) throws RequiredVersionMissingException {
        if (!lv.isVersionValid(LocusUtils.VersionCode.UPDATE_02)) {
            throw new RequiredVersionMissingException(LocusUtils.VersionCode.UPDATE_02);
        }
        if (itemsId == null || itemsId.length == 0) {
            Logger.logW((String)TAG, (String)"Intent 'null' or not contain any data");
            return false;
        }
        Intent intent = new Intent("locus.api.android.ACTION_REMOVE_DATA_SILENTLY");
        intent.setPackage(lv.getPackageName());
        intent.putExtra(extraName, itemsId);
        ctx.sendBroadcast(intent);
        return true;
    }

    public static enum ExtraAction {
        NONE,
        CENTER,
        IMPORT;

    }
}

