/*
 * Decompiled with CFR 0.152.
 */
package locus.api.android;

import android.content.Context;
import android.content.Intent;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.List;
import locus.api.android.ActionDisplay;
import locus.api.android.objects.PackWaypoints;
import locus.api.android.utils.exceptions.RequiredVersionMissingException;
import locus.api.objects.Storable;
import locus.api.utils.Logger;
import locus.api.utils.Utils;

public class ActionDisplayPoints
extends ActionDisplay {
    private static final String TAG = "ActionDisplayPoints";

    public static boolean sendPack(Context context, PackWaypoints data, ActionDisplay.ExtraAction extraAction) throws RequiredVersionMissingException {
        return ActionDisplayPoints.sendPack("locus.api.android.ACTION_DISPLAY_DATA", context, data, extraAction == ActionDisplay.ExtraAction.IMPORT, extraAction == ActionDisplay.ExtraAction.CENTER);
    }

    public static boolean sendPackSilent(Context context, PackWaypoints data, boolean centerOnData) throws RequiredVersionMissingException {
        return ActionDisplayPoints.sendPack("locus.api.android.ACTION_DISPLAY_DATA_SILENTLY", context, data, false, centerOnData);
    }

    private static boolean sendPack(String action, Context context, PackWaypoints data, boolean callImport, boolean centerOnData) throws RequiredVersionMissingException {
        if (data == null) {
            return false;
        }
        Intent intent = new Intent();
        intent.putExtra("INTENT_EXTRA_POINTS_DATA", data.getAsBytes());
        return ActionDisplayPoints.sendData(action, context, intent, callImport, centerOnData);
    }

    public static boolean sendPacks(Context context, List<PackWaypoints> data, ActionDisplay.ExtraAction extraAction) throws RequiredVersionMissingException {
        return ActionDisplayPoints.sendPacks("locus.api.android.ACTION_DISPLAY_DATA", context, data, extraAction == ActionDisplay.ExtraAction.IMPORT, extraAction == ActionDisplay.ExtraAction.CENTER);
    }

    public static boolean sendPacksSilent(Context context, List<PackWaypoints> data, boolean centerOnData) throws RequiredVersionMissingException {
        return ActionDisplayPoints.sendPacks("locus.api.android.ACTION_DISPLAY_DATA_SILENTLY", context, data, false, centerOnData);
    }

    private static boolean sendPacks(String action, Context context, List<PackWaypoints> data, boolean callImport, boolean centerOnData) throws RequiredVersionMissingException {
        if (data == null) {
            return false;
        }
        Intent intent = new Intent();
        intent.putExtra("INTENT_EXTRA_POINTS_DATA_ARRAY", Storable.getAsBytes(data));
        return ActionDisplayPoints.sendData(action, context, intent, callImport, centerOnData);
    }

    public static boolean sendPacksFile(Context context, ArrayList<PackWaypoints> data, String filepath, ActionDisplay.ExtraAction extraAction) throws RequiredVersionMissingException {
        return ActionDisplayPoints.sendPacksFile("locus.api.android.ACTION_DISPLAY_DATA", context, data, filepath, extraAction == ActionDisplay.ExtraAction.IMPORT, extraAction == ActionDisplay.ExtraAction.CENTER);
    }

    public static boolean sendPacksFileSilent(Context context, ArrayList<PackWaypoints> data, String filepath, boolean centerOnData) throws RequiredVersionMissingException {
        return ActionDisplayPoints.sendPacksFile("locus.api.android.ACTION_DISPLAY_DATA_SILENTLY", context, data, filepath, false, centerOnData);
    }

    private static boolean sendPacksFile(String action, Context context, List<PackWaypoints> data, String filepath, boolean callImport, boolean centerOnData) throws RequiredVersionMissingException {
        if (ActionDisplayPoints.sendDataWriteOnCard(data, filepath)) {
            Intent intent = new Intent();
            intent.putExtra("INTENT_EXTRA_POINTS_FILE_PATH", filepath);
            return ActionDisplayPoints.sendData(action, context, intent, callImport, centerOnData);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean sendDataWriteOnCard(List<PackWaypoints> data, String filepath) {
        boolean bl;
        if (data == null || data.size() == 0) {
            return false;
        }
        DataOutputStream dos = null;
        try {
            File file = new File(filepath);
            file.getParentFile().mkdirs();
            if (file.exists()) {
                file.delete();
            }
            dos = new DataOutputStream(new FileOutputStream(file, false));
            Storable.writeList(data, (DataOutputStream)dos);
            dos.flush();
            bl = true;
        }
        catch (Exception e) {
            boolean bl2;
            try {
                Logger.logE((String)TAG, (String)("sendDataWriteOnCard(" + filepath + ", " + data + ")"), (Exception)e);
                bl2 = false;
            }
            catch (Throwable throwable) {
                Utils.closeStream(dos);
                throw throwable;
            }
            Utils.closeStream((Closeable)dos);
            return bl2;
        }
        Utils.closeStream((Closeable)dos);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<PackWaypoints> readDataWriteOnCard(String filepath) {
        List list;
        File file = new File(filepath);
        if (!file.exists()) {
            return new ArrayList<PackWaypoints>();
        }
        DataInputStream dis = null;
        try {
            dis = new DataInputStream(new FileInputStream(file));
            list = Storable.readList(PackWaypoints.class, (DataInputStream)dis);
        }
        catch (Exception e) {
            try {
                Logger.logE((String)TAG, (String)("getDataFile(" + filepath + ")"), (Exception)e);
            }
            catch (Throwable throwable) {
                Utils.closeStream(dis);
                throw throwable;
            }
            Utils.closeStream((Closeable)dis);
            return new ArrayList<PackWaypoints>();
        }
        Utils.closeStream((Closeable)dis);
        return list;
    }

    public void removePackFromLocus(Context ctx, String packName) throws RequiredVersionMissingException {
        if (packName == null || packName.length() == 0) {
            return;
        }
        PackWaypoints pw = new PackWaypoints(packName);
        Intent intent = new Intent();
        intent.putExtra("INTENT_EXTRA_POINTS_DATA", pw.getAsBytes());
        ActionDisplayPoints.sendPackSilent(ctx, pw, false);
    }
}

