/*
 * Decompiled with CFR 0.152.
 */
package locus.api.android;

import android.content.Context;
import android.content.Intent;
import java.util.List;
import locus.api.android.ActionDisplay;
import locus.api.android.utils.exceptions.RequiredVersionMissingException;
import locus.api.objects.Storable;
import locus.api.objects.extra.Track;
import locus.api.utils.Logger;

public class ActionDisplayTracks
extends ActionDisplay {
    private static final String TAG = ActionDisplayTracks.class.getSimpleName();

    public static boolean sendTrack(Context context, Track track, ActionDisplay.ExtraAction extraAction) throws RequiredVersionMissingException {
        return ActionDisplayTracks.sendTrack("locus.api.android.ACTION_DISPLAY_DATA", context, track, extraAction == ActionDisplay.ExtraAction.IMPORT, extraAction == ActionDisplay.ExtraAction.CENTER, false);
    }

    public static boolean sendTrack(Context context, Track track, ActionDisplay.ExtraAction extraAction, boolean startNavigation) throws RequiredVersionMissingException {
        return ActionDisplayTracks.sendTrack("locus.api.android.ACTION_DISPLAY_DATA", context, track, extraAction == ActionDisplay.ExtraAction.IMPORT, extraAction == ActionDisplay.ExtraAction.CENTER, startNavigation);
    }

    public static boolean sendTrackSilent(Context context, Track track, boolean centerOnData) throws RequiredVersionMissingException {
        return ActionDisplayTracks.sendTrack("locus.api.android.ACTION_DISPLAY_DATA_SILENTLY", context, track, false, centerOnData, false);
    }

    private static boolean sendTrack(String action, Context context, Track track, boolean callImport, boolean centerOnData, boolean startNavigation) throws RequiredVersionMissingException {
        if (track == null || track.getPoints().size() == 0) {
            Logger.logE((String)TAG, (String)("sendTrack(" + action + ", " + context + ", " + track + ", " + callImport + ", " + centerOnData + ", " + startNavigation + "), " + "track is null or contain no points"));
            return false;
        }
        Intent intent = new Intent();
        intent.putExtra("INTENT_EXTRA_TRACKS_SINGLE", track.getAsBytes());
        intent.putExtra("INTENT_EXTRA_START_NAVIGATION", startNavigation);
        return ActionDisplayTracks.sendData(action, context, intent, callImport, centerOnData);
    }

    public static boolean sendTracks(Context context, List<Track> tracks, ActionDisplay.ExtraAction extraAction) throws RequiredVersionMissingException {
        return ActionDisplayTracks.sendTracks("locus.api.android.ACTION_DISPLAY_DATA", context, tracks, extraAction == ActionDisplay.ExtraAction.IMPORT, extraAction == ActionDisplay.ExtraAction.CENTER);
    }

    public static boolean sendTracksSilent(Context context, List<Track> tracks, boolean centerOnData) throws RequiredVersionMissingException {
        return ActionDisplayTracks.sendTracks("locus.api.android.ACTION_DISPLAY_DATA_SILENTLY", context, tracks, false, centerOnData);
    }

    private static boolean sendTracks(String action, Context context, List<Track> tracks, boolean callImport, boolean centerOnData) throws RequiredVersionMissingException {
        if (tracks == null || tracks.size() == 0) {
            return false;
        }
        Intent intent = new Intent();
        intent.putExtra("INTENT_EXTRA_TRACKS_MULTI", Storable.getAsBytes(tracks));
        return ActionDisplayTracks.sendData(action, context, intent, callImport, centerOnData);
    }
}

