/*
 * Decompiled with CFR 0.152.
 */
package locus.api.android;

import android.app.Activity;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.text.TextUtils;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.util.ArrayList;
import java.util.List;
import locus.api.android.utils.LocusInfo;
import locus.api.android.utils.LocusUtils;
import locus.api.android.utils.Utils;
import locus.api.android.utils.exceptions.RequiredVersionMissingException;
import locus.api.objects.Storable;
import locus.api.objects.extra.ExtraData;
import locus.api.objects.extra.Location;
import locus.api.objects.extra.Track;
import locus.api.objects.extra.Waypoint;
import locus.api.utils.DataReaderBigEndian;
import locus.api.utils.DataWriterBigEndian;
import locus.api.utils.Logger;

public class ActionTools {
    private static final String TAG = "ActionTools";

    public static void actionPickFile(Activity activity, int requestCode) throws ActivityNotFoundException {
        ActionTools.intentPick("org.openintents.action.PICK_FILE", activity, requestCode, null, null);
    }

    public static void actionPickFile(Activity activity, int requestCode, String title, String[] filter) throws ActivityNotFoundException {
        ActionTools.intentPick("org.openintents.action.PICK_FILE", activity, requestCode, title, filter);
    }

    public static void actionPickDir(Activity activity, int requestCode) throws ActivityNotFoundException {
        ActionTools.intentPick("org.openintents.action.PICK_DIRECTORY", activity, requestCode, null, null);
    }

    public static void actionPickDir(Activity activity, int requestCode, String title) throws ActivityNotFoundException {
        ActionTools.intentPick("org.openintents.action.PICK_DIRECTORY", activity, requestCode, title, null);
    }

    private static void intentPick(String action, Activity activity, int requestCode, String title, String[] filter) {
        Intent intent = new Intent(action);
        if (title != null && title.length() > 0) {
            intent.putExtra("org.openintents.extra.TITLE", title);
        }
        if (filter != null && filter.length > 0) {
            intent.putExtra("org.openintents.extra.FILTER", filter);
        }
        activity.startActivityForResult(intent, requestCode);
    }

    public static void actionPickLocation(Activity act) throws RequiredVersionMissingException {
        if (!LocusUtils.isLocusAvailable((Context)act, 235, 235, 0)) {
            throw new RequiredVersionMissingException(235);
        }
        Intent intent = new Intent("locus.api.android.ACTION_PICK_LOCATION");
        act.startActivity(intent);
    }

    public static void actionStartNavigation(Activity act, String name, double latitude, double longitude) throws RequiredVersionMissingException {
        if (!LocusUtils.isLocusAvailable((Context)act, LocusUtils.VersionCode.UPDATE_01)) {
            throw new RequiredVersionMissingException(LocusUtils.VersionCode.UPDATE_01);
        }
        Intent intent = new Intent("locus.api.android.ACTION_NAVIGATION_START");
        if (name != null) {
            intent.putExtra("INTENT_EXTRA_NAME", name);
        }
        intent.putExtra("INTENT_EXTRA_LATITUDE", latitude);
        intent.putExtra("INTENT_EXTRA_LONGITUDE", longitude);
        act.startActivity(intent);
    }

    public static void actionStartNavigation(Activity act, Waypoint wpt) throws RequiredVersionMissingException {
        if (!LocusUtils.isLocusAvailable((Context)act, LocusUtils.VersionCode.UPDATE_01)) {
            throw new RequiredVersionMissingException(LocusUtils.VersionCode.UPDATE_01);
        }
        Intent intent = new Intent("locus.api.android.ACTION_NAVIGATION_START");
        LocusUtils.addWaypointToIntent(intent, wpt);
        act.startActivity(intent);
    }

    public static void actionStartNavigation(Activity act, String address) throws RequiredVersionMissingException {
        if (!LocusUtils.isLocusAvailable((Context)act, LocusUtils.VersionCode.UPDATE_08)) {
            throw new RequiredVersionMissingException(LocusUtils.VersionCode.UPDATE_08);
        }
        Intent intent = new Intent("locus.api.android.ACTION_NAVIGATION_START");
        intent.putExtra("INTENT_EXTRA_ADDRESS_TEXT", address);
        act.startActivity(intent);
    }

    public static void actionStartGuiding(Activity act, String name, double latitude, double longitude) throws RequiredVersionMissingException {
        Intent intent;
        if (LocusUtils.isLocusAvailable((Context)act, 243, 243, 0)) {
            intent = new Intent("locus.api.android.ACTION_GUIDING_START");
            if (name != null) {
                intent.putExtra("INTENT_EXTRA_NAME", name);
            }
        } else {
            throw new RequiredVersionMissingException(243);
        }
        intent.putExtra("INTENT_EXTRA_LATITUDE", latitude);
        intent.putExtra("INTENT_EXTRA_LONGITUDE", longitude);
        act.startActivity(intent);
    }

    public static void actionStartGuiding(Activity act, Waypoint wpt) throws RequiredVersionMissingException {
        if (!LocusUtils.isLocusAvailable((Context)act, 243, 243, 0)) {
            throw new RequiredVersionMissingException(243);
        }
        Intent intent = new Intent("locus.api.android.ACTION_GUIDING_START");
        LocusUtils.addWaypointToIntent(intent, wpt);
        act.startActivity(intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Waypoint getLocusWaypoint(Context ctx, LocusUtils.LocusVersion lv, long wptId) throws RequiredVersionMissingException {
        int minVersion = LocusUtils.VersionCode.UPDATE_01.vcFree;
        if (!LocusUtils.isLocusFreePro(lv, minVersion)) {
            throw new RequiredVersionMissingException(minVersion);
        }
        Uri scheme = ActionTools.getContentProviderData(lv, LocusUtils.VersionCode.UPDATE_01, "waypoint");
        if (scheme == null) {
            throw new RequiredVersionMissingException(minVersion);
        }
        scheme = ContentUris.withAppendedId((Uri)scheme, (long)wptId);
        Cursor cursor = ctx.getContentResolver().query(scheme, null, null, null, null);
        if (cursor == null || !cursor.moveToFirst()) {
            Logger.logW((String)TAG, (String)("getLocusWaypoint(" + ctx + ", " + wptId + "), " + "'cursor' in not valid"));
            return null;
        }
        try {
            Waypoint waypoint = new Waypoint(cursor.getBlob(1));
            return waypoint;
        }
        catch (Exception e) {
            Logger.logE((String)TAG, (String)("getLocusWaypoint(" + ctx + ", " + wptId + ")"), (Exception)e);
        }
        finally {
            Utils.closeQuietly(cursor);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long[] getLocusWaypointId(Context ctx, LocusUtils.LocusVersion lv, String wptName) throws RequiredVersionMissingException {
        int minVersion = LocusUtils.VersionCode.UPDATE_03.vcFree;
        if (!LocusUtils.isLocusFreePro(lv, minVersion)) {
            throw new RequiredVersionMissingException(minVersion);
        }
        Uri scheme = ActionTools.getContentProviderData(lv, LocusUtils.VersionCode.UPDATE_03, "waypoint");
        if (scheme == null) {
            throw new RequiredVersionMissingException(minVersion);
        }
        Cursor cursor = ctx.getContentResolver().query(scheme, null, "getWaypointId", new String[]{wptName}, null);
        long[] result = null;
        try {
            result = new long[cursor.getCount()];
            int m = result.length;
            for (int i = 0; i < m; ++i) {
                cursor.moveToPosition(i);
                result[i] = cursor.getLong(0);
            }
        }
        catch (Exception e) {
            Logger.logE((String)TAG, (String)("getLocusWaypointId(" + ctx + ", " + wptName + ")"), (Exception)e);
        }
        finally {
            Utils.closeQuietly(cursor);
        }
        return result;
    }

    public static int updateLocusWaypoint(Context context, LocusUtils.LocusVersion lv, Waypoint wpt, boolean forceOverwrite) throws RequiredVersionMissingException {
        return ActionTools.updateLocusWaypoint(context, lv, wpt, forceOverwrite, false);
    }

    public static int updateLocusWaypoint(Context ctx, LocusUtils.LocusVersion lv, Waypoint wpt, boolean forceOverwrite, boolean loadAllGcWaypoints) throws RequiredVersionMissingException {
        int minVersion = LocusUtils.VersionCode.UPDATE_01.vcFree;
        if (!LocusUtils.isLocusFreePro(lv, minVersion)) {
            throw new RequiredVersionMissingException(minVersion);
        }
        Uri scheme = ActionTools.getContentProviderData(lv, LocusUtils.VersionCode.UPDATE_01, "waypoint");
        if (scheme != null) {
            ContentValues cv = new ContentValues();
            cv.put("waypoint", wpt.getAsBytes());
            cv.put("forceOverwrite", Boolean.valueOf(forceOverwrite));
            cv.put("loadAllGcWaypoints", Boolean.valueOf(loadAllGcWaypoints));
            return ctx.getContentResolver().update(scheme, cv, null, null);
        }
        throw new RequiredVersionMissingException(minVersion);
    }

    public static void displayWaypointScreen(Context ctx, LocusUtils.LocusVersion lv, long wptId) throws RequiredVersionMissingException {
        ActionTools.displayWaypointScreen(ctx, lv, wptId, "");
    }

    public static void displayWaypointScreen(Context ctx, LocusUtils.LocusVersion lv, long wptId, String packageName, String className, String returnDataName, String returnDataValue) throws RequiredVersionMissingException {
        String callback = ExtraData.generateCallbackString((String)"", (String)packageName, (String)className, (String)returnDataName, (String)returnDataValue);
        ActionTools.displayWaypointScreen(ctx, lv, wptId, callback);
    }

    private static void displayWaypointScreen(Context ctx, LocusUtils.LocusVersion lv, long wptId, String callback) throws RequiredVersionMissingException {
        if (!LocusUtils.isLocusFreePro(lv, LocusUtils.VersionCode.UPDATE_07.vcFree)) {
            throw new RequiredVersionMissingException(LocusUtils.VersionCode.UPDATE_07);
        }
        Intent intent = new Intent("locus.api.android.ACTION_DISPLAY_POINT_SCREEN");
        intent.putExtra("INTENT_EXTRA_ITEM_ID", wptId);
        if (callback != null && callback.length() > 0) {
            intent.putExtra("TAG_EXTRA_CALLBACK", callback);
        }
        ctx.startActivity(intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Track getLocusTrack(Context ctx, LocusUtils.LocusVersion lv, long trackId) throws RequiredVersionMissingException {
        int minVersion = LocusUtils.VersionCode.UPDATE_10.vcFree;
        if (!LocusUtils.isLocusFreePro(lv, minVersion)) {
            throw new RequiredVersionMissingException(minVersion);
        }
        Uri scheme = ActionTools.getContentProviderData(lv, LocusUtils.VersionCode.UPDATE_10, "track");
        if (scheme == null) {
            throw new RequiredVersionMissingException(minVersion);
        }
        scheme = ContentUris.withAppendedId((Uri)scheme, (long)trackId);
        Cursor cursor = ctx.getContentResolver().query(scheme, null, null, null, null);
        if (cursor == null || !cursor.moveToFirst()) {
            Logger.logW((String)TAG, (String)("getLocusTrack(" + ctx + ", " + trackId + "), " + "'cursor' in not valid"));
            return null;
        }
        try {
            Track track = new Track(cursor.getBlob(1));
            return track;
        }
        catch (Exception e) {
            Logger.logE((String)TAG, (String)("getLocusTrack(" + ctx + ", " + trackId + ")"), (Exception)e);
        }
        finally {
            Utils.closeQuietly(cursor);
        }
        return null;
    }

    public static void actionTrackRecordStart(Context ctx, LocusUtils.LocusVersion lv) throws RequiredVersionMissingException {
        ActionTools.actionTrackRecordStart(ctx, lv, null);
    }

    public static void actionTrackRecordStart(Context ctx, LocusUtils.LocusVersion lv, String profileName) throws RequiredVersionMissingException {
        Intent intent = ActionTools.actionTrackRecord("locus.api.android.ACTION_TRACK_RECORD_START", lv);
        if (profileName != null && profileName.length() > 0) {
            intent.putExtra("INTENT_EXTRA_TRACK_REC_PROFILE", profileName);
        }
        ctx.sendBroadcast(intent);
    }

    public static void actionTrackRecordPause(Context ctx, LocusUtils.LocusVersion lv) throws RequiredVersionMissingException {
        ctx.sendBroadcast(ActionTools.actionTrackRecord("locus.api.android.ACTION_TRACK_RECORD_PAUSE", lv));
    }

    public static void actionTrackRecordStop(Context ctx, LocusUtils.LocusVersion lv, boolean autoSave) throws RequiredVersionMissingException {
        Intent intent = ActionTools.actionTrackRecord("locus.api.android.ACTION_TRACK_RECORD_STOP", lv);
        intent.putExtra("INTENT_EXTRA_TRACK_REC_AUTO_SAVE", autoSave);
        ctx.sendBroadcast(intent);
    }

    public static void actionTrackRecordAddWpt(Context ctx, LocusUtils.LocusVersion lv) throws RequiredVersionMissingException {
        ActionTools.actionTrackRecordAddWpt(ctx, lv, false);
    }

    public static void actionTrackRecordAddWpt(Context ctx, LocusUtils.LocusVersion lv, boolean autoSave) throws RequiredVersionMissingException {
        ActionTools.actionTrackRecordAddWpt(ctx, lv, null, autoSave);
    }

    public static void actionTrackRecordAddWpt(Context ctx, LocusUtils.LocusVersion lv, String wptName, boolean autoSave) throws RequiredVersionMissingException {
        Intent intent = ActionTools.actionTrackRecord("locus.api.android.ACTION_TRACK_RECORD_ADD_WPT", lv);
        if (wptName != null && wptName.length() > 0) {
            intent.putExtra("INTENT_EXTRA_NAME", wptName);
        }
        intent.putExtra("INTENT_EXTRA_TRACK_REC_AUTO_SAVE", autoSave);
        ctx.sendBroadcast(intent);
    }

    public static void actionTrackRecordAddWpt(Context ctx, LocusUtils.LocusVersion lv, String wptName, String actionAfter) throws RequiredVersionMissingException {
        Intent intent = ActionTools.actionTrackRecord("locus.api.android.ACTION_TRACK_RECORD_ADD_WPT", lv);
        if (wptName != null && wptName.length() > 0) {
            intent.putExtra("INTENT_EXTRA_NAME", wptName);
        }
        intent.putExtra("INTENT_EXTRA_TRACK_REC_AUTO_SAVE", false);
        intent.putExtra("INTENT_EXTRA_TRACK_REC_ACTION_AFTER", actionAfter);
        ctx.sendBroadcast(intent);
    }

    private static Intent actionTrackRecord(String action, LocusUtils.LocusVersion lv) throws RequiredVersionMissingException {
        int minVersion = LocusUtils.VersionCode.UPDATE_02.vcFree;
        if (!LocusUtils.isLocusFreePro(lv, minVersion)) {
            throw new RequiredVersionMissingException(minVersion);
        }
        Intent intent = new Intent(action);
        intent.setPackage(lv.getPackageName());
        return intent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<TrackRecordProfileSimple> getTrackRecordingProfiles(Context ctx, LocusUtils.LocusVersion lv) throws RequiredVersionMissingException {
        Uri scheme = ActionTools.getContentProviderData(lv, LocusUtils.VersionCode.UPDATE_09, "trackRecordProfileNames");
        if (scheme == null) {
            throw new RequiredVersionMissingException(LocusUtils.VersionCode.UPDATE_09);
        }
        Cursor cursor = ctx.getContentResolver().query(scheme, null, null, null, null);
        ArrayList<TrackRecordProfileSimple> profiles = new ArrayList<TrackRecordProfileSimple>();
        try {
            for (int i = 0; i < cursor.getCount(); ++i) {
                cursor.moveToPosition(i);
                TrackRecordProfileSimple prof = new TrackRecordProfileSimple(cursor.getLong(0), cursor.getString(1), cursor.getString(2), cursor.getBlob(3));
                profiles.add(prof);
            }
        }
        catch (Exception e) {
            Logger.logE((String)TAG, (String)("getItemPurchaseState(" + ctx + ", " + (Object)((Object)lv) + ")"), (Exception)e);
        }
        finally {
            Utils.closeQuietly(cursor);
        }
        return profiles;
    }

    public static void callAddNewWmsMap(Context context, String wmsUrl) throws RequiredVersionMissingException, InvalidObjectException {
        if (!LocusUtils.isLocusAvailable(context, LocusUtils.VersionCode.UPDATE_01)) {
            throw new RequiredVersionMissingException(LocusUtils.VersionCode.UPDATE_01);
        }
        if (TextUtils.isEmpty((CharSequence)wmsUrl)) {
            throw new InvalidObjectException("WMS Url address '" + wmsUrl + "', is not valid!");
        }
        Intent intent = new Intent("locus.api.android.ACTION_ADD_NEW_WMS_MAP");
        intent.putExtra("INTENT_EXTRA_ADD_NEW_WMS_MAP_URL", wmsUrl);
        context.startActivity(intent);
    }

    @Deprecated
    public static String getLocusRootDirectory(Context context) throws RequiredVersionMissingException {
        LocusInfo locusInfo = ActionTools.getLocusInfoData(context);
        if (locusInfo != null) {
            return locusInfo.getRootDirectory();
        }
        return null;
    }

    @Deprecated
    public static boolean isPeriodicUpdatesEnabled(Context context) throws RequiredVersionMissingException {
        LocusInfo locusInfo = ActionTools.getLocusInfoData(context);
        return locusInfo != null && locusInfo.isPeriodicUpdatesEnabled();
    }

    private static LocusInfo getLocusInfoData(Context ctx) throws RequiredVersionMissingException {
        return ActionTools.getLocusInfo(ctx, LocusUtils.createLocusVersion(ctx));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LocusInfo getLocusInfo(Context ctx, LocusUtils.LocusVersion lv) throws RequiredVersionMissingException {
        Uri scheme = ActionTools.getContentProviderData(lv, LocusUtils.VersionCode.UPDATE_01, "info");
        if (scheme == null) {
            Logger.logD((String)TAG, (String)("getLocusInfo(" + ctx + ", " + (Object)((Object)lv) + "), invalid version"));
            throw new RequiredVersionMissingException(LocusUtils.VersionCode.UPDATE_01);
        }
        Cursor cursor = ctx.getContentResolver().query(scheme, null, null, null, null);
        try {
            LocusInfo locusInfo = LocusInfo.create(cursor);
            return locusInfo;
        }
        catch (Exception e) {
            Logger.logE((String)TAG, (String)("getLocusInfo(" + ctx + ", " + (Object)((Object)lv) + ")"), (Exception)e);
        }
        finally {
            Utils.closeQuietly(cursor);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getItemPurchaseState(Context ctx, LocusUtils.LocusVersion lv, long itemId) throws RequiredVersionMissingException {
        Uri scheme = ActionTools.getContentProviderData(lv, LocusUtils.VersionCode.UPDATE_06, "itemPurchaseState");
        if (scheme == null) {
            throw new RequiredVersionMissingException(LocusUtils.VersionCode.UPDATE_06);
        }
        scheme = ContentUris.withAppendedId((Uri)scheme, (long)itemId);
        Cursor cursor = ctx.getContentResolver().query(scheme, null, null, null, null);
        try {
            for (int i = 0; i < cursor.getCount(); ++i) {
                cursor.moveToPosition(i);
                String key = cursor.getString(0);
                if (!key.equals("purchaseState")) continue;
                int n = cursor.getInt(1);
                return n;
            }
        }
        catch (Exception e) {
            Logger.logE((String)TAG, (String)("getItemPurchaseState(" + ctx + ", " + (Object)((Object)lv) + ")"), (Exception)e);
        }
        finally {
            Utils.closeQuietly(cursor);
        }
        return 0;
    }

    public static void displayLocusStoreItemDetail(Context ctx, LocusUtils.LocusVersion lv, long itemId) throws RequiredVersionMissingException {
        if (lv == null || !lv.isVersionValid(LocusUtils.VersionCode.UPDATE_12)) {
            Logger.logW((String)TAG, (String)"displayLocusStoreItemDetail(), invalid Locus version");
            throw new RequiredVersionMissingException(LocusUtils.VersionCode.UPDATE_12);
        }
        Intent intent = new Intent("locus.api.android.ACTION_DISPLAY_STORE_ITEM");
        intent.putExtra("INTENT_EXTRA_ITEM_ID", itemId);
        ctx.startActivity(intent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BitmapLoadResult getMapPreview(Context ctx, LocusUtils.LocusVersion lv, Location locCenter, int zoomValue, int widthPx, int heightPx, boolean tinyMode) throws RequiredVersionMissingException {
        Uri scheme = ActionTools.getContentProviderData(lv, LocusUtils.VersionCode.UPDATE_04, "mapPreview");
        if (scheme == null) {
            throw new RequiredVersionMissingException(LocusUtils.VersionCode.UPDATE_04);
        }
        StringBuilder sbQuery = new StringBuilder();
        sbQuery.append("lon=").append(locCenter.getLongitude()).append(",");
        sbQuery.append("lat=").append(locCenter.getLatitude()).append(",");
        sbQuery.append("zoom=").append(zoomValue).append(",");
        sbQuery.append("width=").append(widthPx).append(",");
        sbQuery.append("height=").append(heightPx).append(",");
        sbQuery.append("tinyMode=").append(tinyMode ? 1 : 0);
        Cursor cursor = ctx.getContentResolver().query(scheme, null, sbQuery.toString(), null, null);
        try {
            byte[] img = null;
            int notYetLoadedTiles = 0;
            for (int i = 0; i < cursor.getCount(); ++i) {
                cursor.moveToPosition(i);
                String key = new String(cursor.getBlob(0));
                byte[] data = cursor.getBlob(1);
                if (key.equals("mapPreview")) {
                    img = data;
                    continue;
                }
                if (!key.equals("mapPreviewMissingTiles")) continue;
                notYetLoadedTiles = Utils.parseInt((String)new String(data));
            }
            BitmapLoadResult bitmapLoadResult = new BitmapLoadResult(img, notYetLoadedTiles);
            return bitmapLoadResult;
        }
        catch (Exception e) {
            Logger.logE((String)TAG, (String)"getMapPreview()", (Exception)e);
            BitmapLoadResult bitmapLoadResult = new BitmapLoadResult(null, 0);
            return bitmapLoadResult;
        }
        finally {
            Utils.closeQuietly(cursor);
        }
    }

    public static void enablePeriodicUpdatesReceiver(Context ctx, LocusUtils.LocusVersion lv, Class<? extends BroadcastReceiver> receiver) throws RequiredVersionMissingException {
        Logger.logD((String)TAG, (String)("enableReceiver(" + ctx + ")"));
        PackageManager pm = ctx.getPackageManager();
        pm.setComponentEnabledSetting(new ComponentName(ctx, receiver), 1, 1);
        ActionTools.refreshPeriodicUpdateListeners(ctx, lv);
    }

    public static void disablePeriodicUpdatesReceiver(Context ctx, LocusUtils.LocusVersion lv, Class<? extends BroadcastReceiver> receiver) throws RequiredVersionMissingException {
        Logger.logD((String)TAG, (String)("disableReceiver(" + ctx + ")"));
        PackageManager pm = ctx.getPackageManager();
        pm.setComponentEnabledSetting(new ComponentName(ctx, receiver), 2, 1);
        ActionTools.refreshPeriodicUpdateListeners(ctx, lv);
    }

    private static void refreshPeriodicUpdateListeners(Context ctx, LocusUtils.LocusVersion lv) throws RequiredVersionMissingException {
        if (!LocusUtils.isLocusFreePro(lv, LocusUtils.VersionCode.UPDATE_01.vcFree)) {
            throw new RequiredVersionMissingException(LocusUtils.VersionCode.UPDATE_01);
        }
        Intent intent = new Intent("com.asamm.locus.ACTION_REFRESH_PERIODIC_UPDATE_LISTENERS");
        intent.setPackage(lv.getPackageName());
        ctx.sendBroadcast(intent);
    }

    private static Uri getContentProviderData(LocusUtils.LocusVersion lv, LocusUtils.VersionCode vc, String path) {
        return ActionTools.getContentProviderUri(lv, vc, "LocusDataProvider", path);
    }

    public static Uri getContentProviderGeocaching(LocusUtils.LocusVersion lv, LocusUtils.VersionCode vc, String path) {
        return ActionTools.getContentProviderUri(lv, vc, "GeocachingDataProvider", path);
    }

    private static Uri getContentProviderUri(LocusUtils.LocusVersion lv, LocusUtils.VersionCode vc, String provider, String path) {
        if (provider == null || provider.length() == 0 || path == null || path.length() == 0) {
            Logger.logW((String)TAG, (String)"getContentProviderUri(), invalid 'authority' or 'path'parameters");
            return null;
        }
        if (lv == null || vc == null || !lv.isVersionValid(vc)) {
            Logger.logW((String)TAG, (String)"getContentProviderUri(), invalid Locus version");
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (lv.isVersionFree()) {
            sb.append("content://menion.android.locus.free");
        } else if (lv.isVersionPro()) {
            sb.append("content://menion.android.locus.pro");
        } else if (lv.isVersionGis()) {
            sb.append("content://menion.android.locus.gis");
        } else {
            Logger.logW((String)TAG, (String)("getContentProviderUri(), unknown Locus version:" + (Object)((Object)lv)));
            return null;
        }
        return Uri.parse((String)sb.append(".").append(provider).append("/").append(path).toString());
    }

    public static class BitmapLoadResult
    extends Storable {
        private byte[] mImg;
        private int mNotYetLoadedTiles;

        public BitmapLoadResult() {
        }

        private BitmapLoadResult(byte[] img, int notYetLoadedTiles) {
            this.mImg = img;
            this.mNotYetLoadedTiles = notYetLoadedTiles;
        }

        public boolean isValid() {
            return this.mImg != null;
        }

        public byte[] getImageB() {
            return this.mImg;
        }

        public Bitmap getImage() {
            return BitmapFactory.decodeByteArray((byte[])this.mImg, (int)0, (int)this.mImg.length);
        }

        public int getNumOfNotYetLoadedTiles() {
            return this.mNotYetLoadedTiles;
        }

        protected int getVersion() {
            return 0;
        }

        public void reset() {
            this.mImg = null;
            this.mNotYetLoadedTiles = 0;
        }

        protected void readObject(int version, DataReaderBigEndian dr) throws IOException {
            int size = dr.readInt();
            if (size > 0) {
                this.mImg = new byte[size];
                dr.readBytes(this.mImg);
                this.mNotYetLoadedTiles = dr.readInt();
            }
        }

        protected void writeObject(DataWriterBigEndian dw) throws IOException {
            if (this.mImg == null || this.mImg.length == 0) {
                dw.writeInt(0);
            } else {
                dw.writeInt(this.mImg.length);
                dw.write(this.mImg);
            }
            dw.writeInt(this.mNotYetLoadedTiles);
        }
    }

    public static class TrackRecordProfileSimple
    extends Storable {
        private long mId;
        private String mName;
        private String mDesc;
        private byte[] mImg;

        public TrackRecordProfileSimple() {
        }

        private TrackRecordProfileSimple(long id, String name, String desc, byte[] img) {
            this.mId = id;
            this.mName = name == null ? "" : name;
            this.mDesc = desc == null ? "" : desc;
            this.mImg = img;
        }

        public long getId() {
            return this.mId;
        }

        public String getName() {
            return this.mName;
        }

        public String getDesc() {
            return this.mDesc;
        }

        public byte[] getIcon() {
            return this.mImg;
        }

        protected int getVersion() {
            return 0;
        }

        public void reset() {
            this.mId = 0L;
            this.mName = "";
            this.mDesc = "";
            this.mImg = null;
        }

        protected void readObject(int version, DataReaderBigEndian dr) throws IOException {
            this.mId = dr.readLong();
            this.mName = dr.readString();
            this.mDesc = dr.readString();
            int imgSize = dr.readInt();
            if (imgSize > 0) {
                this.mImg = new byte[imgSize];
                dr.readBytes(this.mImg);
            }
        }

        protected void writeObject(DataWriterBigEndian dw) throws IOException {
            dw.writeLong(this.mId);
            dw.writeString(this.mName);
            dw.writeString(this.mDesc);
            int imgSize = this.mImg != null ? this.mImg.length : 0;
            dw.writeInt(imgSize);
            if (imgSize > 0) {
                dw.write(this.mImg);
            }
        }
    }
}

