/*
 * Decompiled with CFR 0.152.
 */
package locus.api.android.features.computeTrack;

import android.app.Service;
import android.content.Context;
import android.content.Intent;
import android.os.IBinder;
import android.os.RemoteException;
import locus.api.android.features.computeTrack.ComputeTrackParameters;
import locus.api.android.features.computeTrack.IComputeTrackService;
import locus.api.android.objects.ParcelableContainer;
import locus.api.android.utils.LocusUtils;
import locus.api.objects.extra.Track;
import locus.api.utils.Logger;

public abstract class ComputeTrackService
extends Service {
    private static final String TAG = ComputeTrackService.class.getSimpleName();
    private final IComputeTrackService.Stub mBinder = new IComputeTrackService.Stub(){

        @Override
        public String getAttribution() {
            return ComputeTrackService.this.getAttribution();
        }

        @Override
        public int[] getTrackTypes() throws RemoteException {
            return ComputeTrackService.this.getTrackTypes();
        }

        @Override
        public Intent getIntentForSettings() {
            return ComputeTrackService.this.getIntentForSettings();
        }

        @Override
        public int getNumOfTransitPoints() {
            return ComputeTrackService.this.getNumOfTransitPoints();
        }

        @Override
        public ParcelableContainer computeTrack(ParcelableContainer trackParams) throws RemoteException {
            try {
                byte[] containerData = trackParams.getData();
                ComputeTrackParameters params = new ComputeTrackParameters(containerData);
                LocusUtils.LocusVersion lv = LocusUtils.getActiveVersion((Context)ComputeTrackService.this);
                if (lv == null) {
                    Logger.logW((String)TAG, (String)"Problem with finding running Locus instance");
                    return null;
                }
                Track track = ComputeTrackService.this.computeTrack(lv, params);
                if (track != null) {
                    return new ParcelableContainer(track.getAsBytes());
                }
                return null;
            }
            catch (Exception e) {
                Logger.logE((String)TAG, (String)("computeTrack(" + trackParams + ")"), (Exception)e);
                return null;
            }
        }
    };

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    public abstract String getAttribution();

    public abstract int[] getTrackTypes();

    public abstract Intent getIntentForSettings();

    public int getNumOfTransitPoints() {
        return 0;
    }

    public abstract Track computeTrack(LocusUtils.LocusVersion var1, ComputeTrackParameters var2);
}

