/*
 * Decompiled with CFR 0.152.
 */
package locus.api.android.features.geocaching.fieldNotes;

import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import locus.api.android.ActionTools;
import locus.api.android.features.geocaching.fieldNotes.FieldNote;
import locus.api.android.features.geocaching.fieldNotes.FieldNoteImage;
import locus.api.android.utils.LocusUtils;
import locus.api.android.utils.Utils;
import locus.api.android.utils.exceptions.RequiredVersionMissingException;

public class FieldNotesHelper {
    public static final String PATH_FIELD_NOTES = "fieldNotes";
    public static final String PATH_FIELD_NOTE_IMAGES = "fieldNoteImages";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getCount(Context ctx, LocusUtils.LocusVersion lv) throws RequiredVersionMissingException {
        Cursor c;
        block3: {
            int n;
            Uri cpUri = FieldNotesHelper.getUriFieldNoteTable(lv);
            c = null;
            try {
                c = ctx.getContentResolver().query(cpUri, new String[]{"_id"}, null, null, null);
                if (c != null) break block3;
                n = 0;
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(c);
                throw throwable;
            }
            Utils.closeQuietly(c);
            return n;
        }
        int n = c.getCount();
        Utils.closeQuietly(c);
        return n;
    }

    public static List<FieldNote> getAll(Context ctx, LocusUtils.LocusVersion lv) throws RequiredVersionMissingException {
        return FieldNotesHelper.get(ctx, lv, "");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FieldNote get(Context ctx, LocusUtils.LocusVersion lv, long id) throws RequiredVersionMissingException {
        Cursor c;
        block3: {
            FieldNote fieldNote;
            Uri cpUri = FieldNotesHelper.getUriFieldNoteTable(lv);
            cpUri = ContentUris.withAppendedId((Uri)cpUri, (long)id);
            c = null;
            try {
                c = ctx.getContentResolver().query(cpUri, null, null, null, null);
                if (c != null && c.getCount() == 1) break block3;
                fieldNote = null;
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(c);
                throw throwable;
            }
            Utils.closeQuietly(c);
            return fieldNote;
        }
        FieldNote fn = FieldNotesHelper.create(c).get(0);
        FieldNotesHelper.getImages(ctx, lv, fn);
        FieldNote fieldNote = fn;
        Utils.closeQuietly(c);
        return fieldNote;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<FieldNote> get(Context ctx, LocusUtils.LocusVersion lv, String cacheCode) throws RequiredVersionMissingException {
        Cursor c;
        block3: {
            ArrayList<FieldNote> arrayList;
            Uri cpUri = FieldNotesHelper.getUriFieldNoteTable(lv);
            c = null;
            try {
                c = cacheCode == null || cacheCode.length() == 0 ? ctx.getContentResolver().query(cpUri, null, null, null, null) : ctx.getContentResolver().query(cpUri, null, "cache_code=?", new String[]{cacheCode}, null);
                if (c != null) break block3;
                arrayList = new ArrayList<FieldNote>();
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(c);
                throw throwable;
            }
            Utils.closeQuietly(c);
            return arrayList;
        }
        List<FieldNote> list = FieldNotesHelper.create(c);
        Utils.closeQuietly(c);
        return list;
    }

    public static boolean delete(Context ctx, LocusUtils.LocusVersion lv, long fieldNoteId) throws RequiredVersionMissingException {
        Uri cpUri = FieldNotesHelper.getUriFieldNoteTable(lv);
        int res = ctx.getContentResolver().delete(cpUri, "_id=?", new String[]{Long.toString(fieldNoteId)});
        FieldNotesHelper.deleteImages(ctx, lv, fieldNoteId);
        return res == 1;
    }

    public static int deleteAll(Context ctx, LocusUtils.LocusVersion lv) throws RequiredVersionMissingException {
        Uri cpUri = FieldNotesHelper.getUriFieldNoteTable(lv);
        int count = ctx.getContentResolver().delete(cpUri, null, null);
        FieldNotesHelper.deleteImagesAll(ctx, lv);
        return count;
    }

    public static boolean insert(Context ctx, LocusUtils.LocusVersion lv, FieldNote gcFn) throws RequiredVersionMissingException {
        Uri cpUri = FieldNotesHelper.getUriFieldNoteTable(lv);
        ContentValues cv = FieldNotesHelper.createContentValues(gcFn);
        Uri newRow = ctx.getContentResolver().insert(cpUri, cv);
        if (newRow != null) {
            gcFn.setId(Utils.parseLong((String)newRow.getLastPathSegment()));
            FieldNotesHelper.storeAllImages(ctx, lv, gcFn);
            return true;
        }
        return false;
    }

    public static boolean update(Context ctx, LocusUtils.LocusVersion lv, FieldNote gcFn) throws RequiredVersionMissingException {
        ContentValues cv = FieldNotesHelper.createContentValues(gcFn);
        if (FieldNotesHelper.update(ctx, lv, gcFn, cv)) {
            FieldNotesHelper.storeAllImages(ctx, lv, gcFn);
            return true;
        }
        return false;
    }

    public static boolean update(Context ctx, LocusUtils.LocusVersion lv, FieldNote fn, ContentValues cv) throws RequiredVersionMissingException {
        Uri cpUri = FieldNotesHelper.getUriFieldNoteTable(lv);
        int newRow = ctx.getContentResolver().update(cpUri, cv, "_id=?", new String[]{Long.toString(fn.getId())});
        return newRow == 1;
    }

    private static void storeAllImages(Context ctx, LocusUtils.LocusVersion lv, FieldNote fn) throws RequiredVersionMissingException {
        Iterator<FieldNoteImage> images = fn.getImages();
        while (images.hasNext()) {
            FieldNoteImage img = images.next();
            img.setFieldNoteId(fn.getId());
            if (img.getId() >= 0L) {
                FieldNotesHelper.updateImage(ctx, lv, img);
                continue;
            }
            FieldNotesHelper.insertImage(ctx, lv, img);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FieldNoteImage getImage(Context ctx, LocusUtils.LocusVersion lv, long imgId) throws RequiredVersionMissingException {
        Cursor c;
        block3: {
            FieldNoteImage fieldNoteImage;
            Uri cpUri = FieldNotesHelper.getUriFieldNoteImagesTable(lv);
            cpUri = ContentUris.withAppendedId((Uri)cpUri, (long)imgId);
            c = null;
            try {
                c = ctx.getContentResolver().query(cpUri, null, null, null, null);
                if (c != null && c.getCount() == 1) break block3;
                fieldNoteImage = null;
            }
            catch (Throwable throwable) {
                Utils.closeQuietly(c);
                throw throwable;
            }
            Utils.closeQuietly(c);
            return fieldNoteImage;
        }
        FieldNoteImage fieldNoteImage = FieldNotesHelper.createFieldNoteImages(c).get(0);
        Utils.closeQuietly(c);
        return fieldNoteImage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void getImages(Context ctx, LocusUtils.LocusVersion lv, FieldNote fn) throws RequiredVersionMissingException {
        Uri cpUri = FieldNotesHelper.getUriFieldNoteImagesTable(lv);
        Cursor c = null;
        try {
            c = ctx.getContentResolver().query(cpUri, new String[]{"_id"}, "field_note_id=?", new String[]{Long.toString(fn.getId())}, null);
            if (c != null) {
                List<FieldNoteImage> images = FieldNotesHelper.createFieldNoteImages(c);
                int m = images.size();
                for (int i = 0; i < m; ++i) {
                    fn.addImage(images.get(i));
                }
            }
        }
        catch (Throwable throwable) {
            Utils.closeQuietly(c);
            throw throwable;
        }
        Utils.closeQuietly(c);
    }

    private static void deleteImages(Context ctx, LocusUtils.LocusVersion lv, long fieldNoteId) throws RequiredVersionMissingException {
        Uri cpUri = FieldNotesHelper.getUriFieldNoteImagesTable(lv);
        ctx.getContentResolver().delete(cpUri, "field_note_id=?", new String[]{Long.toString(fieldNoteId)});
    }

    private static void deleteImagesAll(Context ctx, LocusUtils.LocusVersion lv) throws RequiredVersionMissingException {
        Uri cpUri = FieldNotesHelper.getUriFieldNoteImagesTable(lv);
        ctx.getContentResolver().delete(cpUri, null, null);
    }

    private static boolean updateImage(Context ctx, LocusUtils.LocusVersion lv, FieldNoteImage img) throws RequiredVersionMissingException {
        Uri cpUri = FieldNotesHelper.getUriFieldNoteImagesTable(lv);
        ContentValues cv = FieldNotesHelper.createContentValues(img, false);
        int newRow = ctx.getContentResolver().update(cpUri, cv, "_id=?", new String[]{Long.toString(img.getId())});
        return newRow == 1;
    }

    private static boolean insertImage(Context ctx, LocusUtils.LocusVersion lv, FieldNoteImage img) throws RequiredVersionMissingException {
        Uri cpUri = FieldNotesHelper.getUriFieldNoteImagesTable(lv);
        ContentValues cv = FieldNotesHelper.createContentValues(img, true);
        Uri newRow = ctx.getContentResolver().insert(cpUri, cv);
        return newRow != null;
    }

    private static Uri getUriFieldNoteTable(LocusUtils.LocusVersion lv) throws RequiredVersionMissingException {
        Uri uri = ActionTools.getContentProviderGeocaching(lv, LocusUtils.VersionCode.UPDATE_05, PATH_FIELD_NOTES);
        if (uri == null) {
            throw new RequiredVersionMissingException(LocusUtils.VersionCode.UPDATE_05);
        }
        return uri;
    }

    private static Uri getUriFieldNoteImagesTable(LocusUtils.LocusVersion lv) throws RequiredVersionMissingException {
        Uri uri = ActionTools.getContentProviderGeocaching(lv, LocusUtils.VersionCode.UPDATE_05, PATH_FIELD_NOTE_IMAGES);
        if (uri == null) {
            throw new RequiredVersionMissingException(LocusUtils.VersionCode.UPDATE_05);
        }
        return uri;
    }

    private static List<FieldNote> create(Cursor cursor) {
        ArrayList<FieldNote> res = new ArrayList<FieldNote>();
        if (cursor == null) {
            throw new IllegalArgumentException("Cursor cannot be 'null'");
        }
        int m = cursor.getCount();
        for (int i = 0; i < m; ++i) {
            int iLogged;
            int iFavorite;
            cursor.moveToPosition(i);
            FieldNote fn = new FieldNote();
            fn.setId(cursor.getLong(cursor.getColumnIndexOrThrow("_id")));
            fn.setCacheCode(cursor.getString(cursor.getColumnIndexOrThrow("cache_code")));
            fn.setCacheName(cursor.getString(cursor.getColumnIndexOrThrow("cache_name")));
            fn.setType(cursor.getInt(cursor.getColumnIndexOrThrow("type")));
            fn.setTime(cursor.getLong(cursor.getColumnIndex("time")));
            int iNote = cursor.getColumnIndex("note");
            if (iNote >= 0) {
                fn.setNote(cursor.getString(iNote));
            }
            if ((iFavorite = cursor.getColumnIndex("favorite")) >= 0) {
                fn.setFavorite(cursor.getInt(iFavorite) == 1);
            }
            if ((iLogged = cursor.getColumnIndex("logged")) >= 0) {
                fn.setLogged(cursor.getInt(iLogged) == 1);
            }
            res.add(fn);
        }
        return res;
    }

    private static ContentValues createContentValues(FieldNote fn) {
        if (fn == null) {
            throw new IllegalArgumentException("Field note cannot be 'null'");
        }
        ContentValues cv = new ContentValues();
        cv.put("cache_code", fn.getCacheCode());
        cv.put("cache_name", fn.getCacheName());
        cv.put("type", Integer.valueOf(fn.getType()));
        cv.put("time", Long.valueOf(fn.getTime()));
        cv.put("note", fn.getNote());
        cv.put("favorite", Boolean.valueOf(fn.isFavorite()));
        cv.put("logged", Boolean.valueOf(fn.isLogged()));
        return cv;
    }

    private static List<FieldNoteImage> createFieldNoteImages(Cursor cursor) {
        ArrayList<FieldNoteImage> res = new ArrayList<FieldNoteImage>();
        if (cursor == null) {
            throw new IllegalArgumentException("Cursor cannot be 'null'");
        }
        int m = cursor.getCount();
        for (int i = 0; i < m; ++i) {
            int iData;
            int iDesc;
            int iCap;
            cursor.moveToPosition(i);
            FieldNoteImage img = new FieldNoteImage();
            img.setId(cursor.getLong(cursor.getColumnIndexOrThrow("_id")));
            int iFnId = cursor.getColumnIndex("field_note_id");
            if (iFnId >= 0) {
                img.setFieldNoteId(cursor.getLong(iFnId));
            }
            if ((iCap = cursor.getColumnIndex("caption")) >= 0) {
                img.setCaption(cursor.getString(iCap));
            }
            if ((iDesc = cursor.getColumnIndex("description")) >= 0) {
                img.setDescription(cursor.getString(iDesc));
            }
            if ((iData = cursor.getColumnIndex("data")) >= 0) {
                img.setImage(cursor.getBlob(iData));
            }
            res.add(img);
        }
        return res;
    }

    private static ContentValues createContentValues(FieldNoteImage img, boolean alsoData) {
        if (img == null || img.getImage() == null) {
            throw new IllegalArgumentException("Field note image cannot be 'null'");
        }
        ContentValues cv = new ContentValues();
        cv.put("field_note_id", Long.valueOf(img.getFieldNoteId()));
        cv.put("caption", img.getCaption());
        cv.put("description", img.getDescription());
        if (alsoData) {
            cv.put("data", img.getImage());
        }
        return cv;
    }

    public static void logOnline(Context ctx, LocusUtils.LocusVersion lv, long[] ids, boolean createLog) throws RequiredVersionMissingException {
        if (ctx == null || lv == null || ids == null || ids.length == 0) {
            throw new IllegalArgumentException("logOnline(" + ctx + ", " + (Object)((Object)lv) + ", " + ids + "), " + "invalid parameters");
        }
        if (!lv.isVersionValid(LocusUtils.VersionCode.UPDATE_05)) {
            throw new RequiredVersionMissingException(LocusUtils.VersionCode.UPDATE_05);
        }
        Intent intent = new Intent("locus.api.android.LOG_FIELD_NOTES");
        intent.putExtra("INTENT_EXTRA_FIELD_NOTES_IDS", ids);
        intent.putExtra("INTENT_EXTRA_FIELD_NOTES_CREATE_LOG", createLog);
        ctx.startActivity(intent);
    }

    public static class ColFieldNoteImage {
        public static final String ID = "_id";
        public static final String FIELD_NOTE_ID = "field_note_id";
        public static final String CAPTION = "caption";
        public static final String DESCRIPTION = "description";
        public static final String DATA = "data";
    }

    public static class ColFieldNote {
        public static final String ID = "_id";
        public static final String CACHE_CODE = "cache_code";
        public static final String CACHE_NAME = "cache_name";
        public static final String TYPE = "type";
        public static final String TIME = "time";
        public static final String NOTE = "note";
        public static final String FAVORITE = "favorite";
        public static final String LOGGED = "logged";
    }
}

