/*
 * Decompiled with CFR 0.152.
 */
package locus.api.android.features.mapProvider;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.IOException;
import java.util.List;
import locus.api.android.features.mapProvider.data.MapConfigLayer;
import locus.api.android.features.mapProvider.data.MapTileRequest;
import locus.api.android.features.mapProvider.data.MapTileResponse;
import locus.api.objects.Storable;
import locus.api.utils.Logger;

public class MapDataContainer
implements Parcelable {
    private static final String TAG = MapDataContainer.class.getSimpleName();
    private static final int DATA_TYPE_UNDEFINED = 0;
    public static final int DATA_TYPE_CONFIGURATION = 1;
    public static final int DATA_TYPE_TILE_REQUEST = 2;
    public static final int DATA_TYPE_TILE_RESPONSE = 3;
    private int mDataType;
    private List<MapConfigLayer> mMapConfigs;
    private MapTileRequest mMapTileRequest;
    private MapTileResponse mMapTileResponse;
    public static final Parcelable.Creator<MapDataContainer> CREATOR = new Parcelable.Creator<MapDataContainer>(){

        public MapDataContainer createFromParcel(Parcel in) {
            return new MapDataContainer(in);
        }

        public MapDataContainer[] newArray(int size) {
            return new MapDataContainer[size];
        }
    };

    public MapDataContainer(List<MapConfigLayer> mapConfigs) {
        this.mDataType = 1;
        this.mMapConfigs = mapConfigs;
    }

    public MapDataContainer(MapTileRequest tileRequest) {
        this.mDataType = 2;
        this.mMapTileRequest = tileRequest;
    }

    public MapDataContainer(MapTileResponse tileResponse) {
        this.mDataType = 3;
        this.mMapTileResponse = tileResponse;
    }

    public boolean isValid(int requestedType) {
        if (this.mDataType != requestedType) {
            Logger.logW((String)TAG, (String)("isValid(" + requestedType + "), " + "invalid type:" + this.mDataType));
            return false;
        }
        if (this.mDataType == 1) {
            return this.mMapConfigs != null && this.mMapConfigs.size() > 0;
        }
        if (this.mDataType == 2) {
            return this.mMapTileRequest != null;
        }
        if (this.mDataType == 3) {
            return this.mMapTileResponse != null;
        }
        return false;
    }

    public List<MapConfigLayer> getMapConfigurations() {
        return this.mMapConfigs;
    }

    public MapTileRequest getTileRequest() {
        return this.mMapTileRequest;
    }

    public MapTileResponse getTileResponse() {
        return this.mMapTileResponse;
    }

    private MapDataContainer(Parcel in) {
        try {
            this.readFromParcel(in);
        }
        catch (IOException e) {
            this.mDataType = 0;
            Logger.logE((String)TAG, (String)("DataTransporter(" + in + ")"), (Exception)e);
        }
    }

    private void readFromParcel(Parcel in) throws IOException {
        this.mDataType = in.readInt();
        if (this.mDataType == 1) {
            byte[] data = new byte[in.readInt()];
            in.readByteArray(data);
            this.mMapConfigs = Storable.readList(MapConfigLayer.class, (byte[])data);
        } else if (this.mDataType == 2) {
            byte[] data = new byte[in.readInt()];
            in.readByteArray(data);
            this.mMapTileRequest = new MapTileRequest(data);
        } else if (this.mDataType == 3) {
            byte[] data = new byte[in.readInt()];
            in.readByteArray(data);
            this.mMapTileResponse = new MapTileResponse(data);
        }
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mDataType);
        if (this.mDataType == 1) {
            this.writeObject(dest, Storable.getAsBytes(this.mMapConfigs));
        } else if (this.mDataType == 2) {
            this.writeObject(dest, this.mMapTileRequest.getAsBytes());
        } else if (this.mDataType == 3) {
            this.writeObject(dest, this.mMapTileResponse.getAsBytes());
        }
    }

    private void writeObject(Parcel dest, byte[] data) {
        dest.writeInt(data.length);
        dest.writeByteArray(data);
    }

    public int describeContents() {
        return 0;
    }
}

